/*
 * Decompiled with CFR 0.152.
 */
package org.epic.core.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.epic.perleditor.PerlEditorPlugin;

public class PerlMainPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text executableText;
    private Text browserLabelText;
    private Button warningsCheckBox;
    private Button taintCheckBox;
    private Button debugConsoleCheckBox;
    private Button suspendAtFirstCheckBox;
    private Button validateCheckBox;
    private Scale syntaxCheckInterval;
    private Combo interpreterTypeCombo;
    private Label syntaxIntervalSecondsLabel;
    private Composite fParent;
    private String[] intepreterTypes = new String[]{"Standard", "Cygwin"};

    protected Control createContents(Composite parent) {
        this.fParent = parent;
        Composite top = new Composite(parent, 0);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        top.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        top.setLayout((Layout)layout);
        Composite buttonComposite = new Composite(top, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 3;
        buttonComposite.setLayout((Layout)buttonLayout);
        data = new GridData(1810);
        buttonComposite.setLayoutData((Object)data);
        Label executableLabel = new Label(buttonComposite, 0);
        executableLabel.setText("Perl executable:");
        this.executableText = new Text(buttonComposite, 2048);
        Button browseButton = new Button(buttonComposite, 0x1000008);
        browseButton.setText("...");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileBrowser = new FileDialog(PerlMainPreferencePage.this.fParent.getShell());
                String dir = fileBrowser.open();
                if (dir != null) {
                    PerlMainPreferencePage.this.executableText.setText("\"" + dir + "\"");
                }
            }
        });
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.executableText.setLayoutData((Object)data);
        this.executableText.setText(PerlEditorPlugin.getDefault().getPerlExecutable());
        new Label(buttonComposite, 0).setText("Interpreter type:");
        this.interpreterTypeCombo = new Combo(buttonComposite, 8);
        this.interpreterTypeCombo.setItems(this.intepreterTypes);
        this.interpreterTypeCombo.setText(PerlEditorPlugin.getDefault().getPreferenceStore().getString("INTERPRETER_TYPE"));
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.warningsCheckBox = new Button(top, 32);
        this.warningsCheckBox.setText("Enable warnings");
        this.warningsCheckBox.setSelection(PerlEditorPlugin.getDefault().getBooleanPreference("SHOW_WARNINGS"));
        this.warningsCheckBox.setLayoutData((Object)data);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.taintCheckBox = new Button(top, 32);
        this.taintCheckBox.setText("Enable taint mode");
        this.taintCheckBox.setSelection(PerlEditorPlugin.getDefault().getBooleanPreference("USE_TAINT_MODE"));
        this.taintCheckBox.setLayoutData((Object)data);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.debugConsoleCheckBox = new Button(top, 32);
        this.debugConsoleCheckBox.setText("Enable debugger console (experimental)");
        this.debugConsoleCheckBox.setSelection(PerlEditorPlugin.getDefault().getBooleanPreference("ENABLE_DEBUG_CONSOLE"));
        this.debugConsoleCheckBox.setLayoutData((Object)data);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.suspendAtFirstCheckBox = new Button(top, 32);
        this.suspendAtFirstCheckBox.setText("Suspend debugger at first statement");
        this.suspendAtFirstCheckBox.setSelection(PerlEditorPlugin.getDefault().getBooleanPreference("SUSPEND_AT_FIRST_CONSOLE"));
        this.suspendAtFirstCheckBox.setLayoutData((Object)data);
        Composite browserComposite = new Composite(top, 0);
        GridLayout browserLayout = new GridLayout();
        browserLayout.numColumns = 2;
        browserComposite.setLayout((Layout)browserLayout);
        data = new GridData(1810);
        browserComposite.setLayoutData((Object)data);
        Label browserLabel = new Label(browserComposite, 0);
        browserLabel.setText("Default Web-Start page:");
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.browserLabelText = new Text(browserComposite, 2048);
        this.browserLabelText.setLayoutData((Object)data);
        this.browserLabelText.setText(PerlEditorPlugin.getDefault().getPreferenceStore().getString("WEB_BROWSER"));
        Composite syntaxIntervalComposite = new Composite(top, 0);
        GridLayout syncIntervalLayout = new GridLayout();
        syncIntervalLayout.numColumns = 3;
        syntaxIntervalComposite.setLayout((Layout)syncIntervalLayout);
        data = new GridData(1810);
        syntaxIntervalComposite.setLayoutData((Object)data);
        this.validateCheckBox = new Button(syntaxIntervalComposite, 32);
        this.validateCheckBox.setText("Validate source when idle for ");
        this.validateCheckBox.setSelection(PerlEditorPlugin.getDefault().getBooleanPreference("SYNTAX_VALIDATION_PREFERENCE"));
        this.syntaxCheckInterval = new Scale(syntaxIntervalComposite, 256);
        this.syntaxCheckInterval.setMinimum(1);
        this.syntaxCheckInterval.setMaximum(10000);
        this.syntaxCheckInterval.setIncrement(100);
        this.syntaxIntervalSecondsLabel = new Label(syntaxIntervalComposite, 0);
        this.displayInterval(PerlEditorPlugin.getDefault().getPreferenceStore().getInt("SYNTAX_VALIDATION_IDLE_INTERVAL"));
        this.syntaxCheckInterval.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PerlMainPreferencePage.this.displayInterval(PerlMainPreferencePage.this.syntaxCheckInterval.getSelection());
            }
        });
        syntaxIntervalComposite.setLayoutData((Object)data);
        return new Composite(parent, 0);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(PerlEditorPlugin.getDefault().getPreferenceStore());
    }

    protected void performDefaults() {
        IPreferenceStore prefs = PerlEditorPlugin.getDefault().getPreferenceStore();
        this.executableText.setText(prefs.getDefaultString("PERL_EXECUTABLE"));
        this.warningsCheckBox.setSelection(prefs.getDefaultBoolean("SHOW_WARNINGS"));
        this.taintCheckBox.setSelection(prefs.getDefaultBoolean("USE_TAINT_MODE"));
        this.debugConsoleCheckBox.setSelection(prefs.getDefaultBoolean("ENABLE_DEBUG_CONSOLE"));
        this.suspendAtFirstCheckBox.setSelection(prefs.getDefaultBoolean("SUSPEND_AT_FIRST_CONSOLE"));
        this.interpreterTypeCombo.setText(prefs.getDefaultString("INTERPRETER_TYPE"));
        this.browserLabelText.setText(prefs.getDefaultString("WEB_BROWSER"));
        this.validateCheckBox.setSelection(prefs.getDefaultBoolean("SYNTAX_VALIDATION_PREFERENCE"));
        int defaultInterval = prefs.getDefaultInt("SYNTAX_VALIDATION_IDLE_INTERVAL");
        this.displayInterval(defaultInterval);
    }

    public boolean performOk() {
        IPreferenceStore prefs = PerlEditorPlugin.getDefault().getPreferenceStore();
        PerlEditorPlugin.getDefault().setPerlExecutable(this.executableText.getText());
        prefs.setValue("SHOW_WARNINGS", this.warningsCheckBox.getSelection());
        prefs.setValue("USE_TAINT_MODE", this.taintCheckBox.getSelection());
        prefs.setValue("ENABLE_DEBUG_CONSOLE", this.debugConsoleCheckBox.getSelection());
        prefs.setValue("SUSPEND_AT_FIRST_CONSOLE", this.suspendAtFirstCheckBox.getSelection());
        prefs.setValue("SYNTAX_VALIDATION_PREFERENCE", this.validateCheckBox.getSelection());
        prefs.setValue("INTERPRETER_TYPE", this.interpreterTypeCombo.getText());
        prefs.setValue("SYNTAX_VALIDATION_IDLE_INTERVAL", this.syntaxCheckInterval.getSelection());
        prefs.setValue("WEB_BROWSER", this.browserLabelText.getText());
        return super.performOk();
    }

    private void displayInterval(int interval) {
        float intervalDisplay = (float)Math.round((float)interval / 10.0f) / 100.0f;
        this.syntaxIntervalSecondsLabel.setText(String.valueOf(intervalDisplay) + " seconds ");
        this.syntaxCheckInterval.setSelection(interval);
    }
}

