/*
 * Decompiled with CFR 0.152.
 */
package org.epic.core;

import java.util.HashMap;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.epic.core.ResourceMessages;
import org.epic.perleditor.preferences.ModuleStarterPreferencePage;

public class PerlNewProjectCreationPage
extends WizardNewProjectCreationPage {
    private Link moduleStarterPrefLink;
    private Button moduleButton;
    private Label moduleNameLabel;
    private Text moduleNameText;
    private boolean useModule;
    private boolean useModuleStarter;
    static /* synthetic */ Class class$0;

    public PerlNewProjectCreationPage(String pageName) {
        super(pageName);
        this.useModule = false;
        this.useModuleStarter = false;
        this.setTitle(ResourceMessages.getString("NewProject.title"));
        this.setDescription(ResourceMessages.getString("NewProject.description"));
    }

    public PerlNewProjectCreationPage() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.epic.core.PerlNewProjectCreationPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this(clazz.getName());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.useModuleStarter = ModuleStarterPreferencePage.isModuleStarterEnabled();
        Composite composite = (Composite)this.getControl();
        Group group = new Group(composite, 0);
        group.setText("Module::Starter Information");
        group.setLayoutData((Object)new GridData(4, 1, true, false));
        group.setLayout((Layout)new GridLayout(2, false));
        this.moduleButton = new Button((Composite)group, 32);
        this.moduleButton.setText("&Use Module::Starter");
        this.moduleButton.setSelection(false);
        this.moduleButton.setEnabled(this.useModuleStarter);
        this.moduleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PerlNewProjectCreationPage.this.useModule = PerlNewProjectCreationPage.this.moduleButton.getSelection();
                PerlNewProjectCreationPage.this.setModuleName();
            }
        });
        this.moduleButton.setToolTipText(ResourceMessages.getString("NewProject.moduleStarterTooltip"));
        this.moduleStarterPrefLink = new Link((Composite)group, 0);
        this.moduleStarterPrefLink.setFont(group.getFont());
        this.moduleStarterPrefLink.setText(ResourceMessages.getString("NewProject.moduleStarterPrefDesc"));
        this.moduleStarterPrefLink.setLayoutData((Object)new GridData(3, 2, false, false));
        this.moduleStarterPrefLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String moduleStarterID = "org.epic.perleditor.preferences.ModuleStarterPreferencePage";
                HashMap<String, Boolean> data = new HashMap<String, Boolean>();
                data.put("PropertyAndPreferencePage.nolink", Boolean.TRUE);
                PreferencesUtil.createPreferenceDialogOn((Shell)PerlNewProjectCreationPage.this.getShell(), (String)moduleStarterID, (String[])new String[]{moduleStarterID}, data).open();
                PerlNewProjectCreationPage.this.toggleEnabled(ModuleStarterPreferencePage.isModuleStarterEnabled());
            }
        });
        this.moduleNameLabel = new Label((Composite)group, 16384);
        this.moduleNameLabel.setText("Module Name");
        this.moduleNameText = new Text((Composite)group, 16392);
        GridData moduleNameData = new GridData(768);
        moduleNameData.widthHint = 250;
        this.moduleNameText.setLayoutData((Object)moduleNameData);
        this.moduleNameText.setFont(parent.getFont());
        this.toggleEnabled(ModuleStarterPreferencePage.isModuleStarterEnabled());
        this.setModuleName();
    }

    public void setPageComplete(boolean complete) {
        super.setPageComplete(complete);
        this.setModuleName();
    }

    boolean getUseModule() {
        return this.useModule;
    }

    String getModuleName() {
        return this.moduleNameText.getText().trim();
    }

    private void setModuleName() {
        String projectName = this.getProjectName();
        if (projectName == null || !this.useModule) {
            projectName = "";
        }
        if (this.moduleNameText != null) {
            this.moduleNameText.setText(projectName.replaceAll("-", "::"));
        }
    }

    private void toggleEnabled(boolean enabled) {
        this.moduleButton.setEnabled(enabled);
        this.moduleNameLabel.setEnabled(enabled);
        this.moduleNameText.setEnabled(enabled);
    }
}

