/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.remote;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.epic.core.PerlCore;
import org.epic.core.PerlProject;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.remote.RemoteLaunchConfigurationDelegate;
import org.epic.debug.util.RemotePathMapper;

public class CreateRemotePackageJob
extends Job {
    private final byte[] buffer;
    private final File archiveFile;
    private final ZipOutputStream zipOut;
    private final ILaunch launch;
    private final RemoteLaunchConfigurationDelegate launchDelegate;
    private final RemotePathMapper mapper;

    public CreateRemotePackageJob(RemoteLaunchConfigurationDelegate launchDelegate, ILaunch launch, RemotePathMapper mapper) throws CoreException {
        super("Create Remote Debug Package");
        this.launch = launch;
        this.launchDelegate = launchDelegate;
        this.mapper = mapper;
        this.buffer = new byte[1024];
        this.archiveFile = launchDelegate.getDebugPackageFile(launch);
        this.zipOut = this.createOutputStream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        monitor.beginTask("Create Remote Debug Package", this.countProjectFiles());
        try {
            try {
                this.addProjectFilesToArchive(monitor);
                this.addHelperScriptToArchive("dumpvar_epic.pm");
                this.addHelperScriptToArchive("epic_breakpoints.pm");
                this.addHelperScriptToArchive("autoflush_epic.pm");
                this.addPerl5DbToArchive();
                this.addStartScriptToArchive();
                iStatus = Status.OK_STATUS;
                Object var3_4 = null;
            }
            catch (CoreException e) {
                this.archiveFile.delete();
                PerlDebugPlugin.log(e);
                IStatus iStatus2 = e.getStatus();
                Object var3_5 = null;
                monitor.done();
                try {
                    this.zipOut.close();
                    return iStatus2;
                }
                catch (IOException e2) {
                    PerlDebugPlugin.log(e2);
                }
                return iStatus2;
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            monitor.done();
            try {}
            catch (IOException e2) {
                PerlDebugPlugin.log(e2);
                throw throwable;
            }
            this.zipOut.close();
            throw throwable;
        }
        monitor.done();
        try {}
        catch (IOException e2) {
            PerlDebugPlugin.log(e2);
            return iStatus;
        }
        this.zipOut.close();
        return iStatus;
    }

    private void addProjectFilesToArchive(IProgressMonitor monitor) throws CoreException {
        ProjectFileArchiver visitor = new ProjectFileArchiver(monitor);
        this.getProject().accept((IResourceVisitor)visitor);
    }

    private void addHelperScriptToArchive(String scriptName) throws CoreException {
        try {
            this.addFileToArchive(PerlDebugPlugin.getDefault().getBundle().getEntry(scriptName).openStream(), String.valueOf(this.getWorkingDirPrefix()) + scriptName);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "Could not locate helper script " + scriptName, (Throwable)e));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addFileToArchive(InputStream in, String pathInArchive) throws CoreException {
        try {
            try {
                int len;
                this.zipOut.putNextEntry(new ZipEntry(pathInArchive));
                while ((len = in.read(this.buffer)) > 0) {
                    this.zipOut.write(this.buffer, 0, len);
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "Could not write zip entry " + pathInArchive, (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        in.close();
    }

    private void addPerl5DbToArchive() throws CoreException {
        try {
            File perl5Db = PerlDebugPlugin.getDefault().patchPerl5Db();
            this.addFileToArchive(new BufferedInputStream(new FileInputStream(perl5Db)), String.valueOf(this.getWorkingDirPrefix()) + "perl5db.pl");
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "Could not add patched perl5db.pl to archive", (Throwable)e));
        }
    }

    private void addStartScriptToArchive() throws CoreException {
        try {
            this.zipOut.putNextEntry(new ZipEntry("start_epicDB.pl"));
            String startDB = "$ENV{PERLDB_OPTS}=\"RemotePort=" + this.launchDelegate.getEpicDebuggerIP(this.launch) + ":" + this.launchDelegate.getEpicDebuggerPort(this.launch) + " DumpReused ReadLine=0 PrintRet=0\";\n" + "if( ! -d \"" + this.launchDelegate.getRemoteProjectDir(this.launch) + "\" ) {die(\"Target directory does not exist!\")};\n" + "chdir(\"" + this.launchDelegate.getRemoteProjectDir(this.launch) + "/" + this.launchDelegate.getScriptPath(this.launch).removeLastSegments(1) + "\");" + "\nsystem(\"perl -d " + this.createIncPath() + " " + this.launchDelegate.getRemoteProjectDir(this.launch) + "/" + this.launchDelegate.getScriptPath(this.launch) + "\");";
            this.zipOut.write(startDB.getBytes());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "Could not write zip entry for start_epicDB.pl", (Throwable)e));
        }
    }

    private String createIncPath() throws CoreException {
        StringBuffer buf = new StringBuffer();
        String localProjectDir = this.getPerlProject().getProjectDir().toString();
        String remoteProjectDir = this.launchDelegate.getRemoteProjectDir(this.launch);
        buf.append(" -I \\\"");
        buf.append(this.launchDelegate.getRemoteProjectDir(this.launch));
        buf.append("\\\"");
        Iterator i = this.getPerlProject().getRawIncPath().iterator();
        while (i.hasNext()) {
            String path = new Path((String)i.next()).toString();
            if (path.startsWith(localProjectDir)) {
                path = String.valueOf(remoteProjectDir) + path.substring(localProjectDir.length());
            }
            buf.append(" -I \\\"");
            buf.append(path);
            buf.append("\\\"");
        }
        return buf.toString();
    }

    private int countProjectFiles() {
        PerlFileCounter visitor = new PerlFileCounter();
        try {
            this.getProject().accept((IResourceVisitor)visitor);
            return visitor.getCount();
        }
        catch (CoreException e) {
            PerlDebugPlugin.log(e);
            return 0;
        }
    }

    private ZipOutputStream createOutputStream() throws CoreException {
        try {
            return new ZipOutputStream(new FileOutputStream(this.archiveFile));
        }
        catch (FileNotFoundException e) {
            throw new CoreException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "Could not write remote debug package file " + this.archiveFile.getAbsolutePath(), (Throwable)e));
        }
    }

    private PerlProject getPerlProject() throws CoreException {
        return PerlCore.create((IProject)this.getProject());
    }

    private IProject getProject() throws CoreException {
        return this.launchDelegate.getProject(this.launch);
    }

    private String getWorkingDirPrefix() throws CoreException {
        String prefix = this.launchDelegate.getScriptPath(this.launch).removeLastSegments(1).toString();
        if (prefix.length() > 0) {
            prefix = String.valueOf(prefix) + "/";
        }
        return prefix;
    }

    private class ProjectFileArchiver
    implements IResourceVisitor {
        private final IProgressMonitor monitor;

        public ProjectFileArchiver(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.isLinked() && resource instanceof IFolder) {
                CreateRemotePackageJob.this.mapper.addLinkedFolderMapping((IFolder)resource);
            }
            if (resource instanceof IFile) {
                this.addFileToArchive((IFile)resource);
                this.monitor.worked(1);
            }
            return true;
        }

        private void addFileToArchive(IFile resource) throws CoreException {
            try {
                CreateRemotePackageJob.this.addFileToArchive(new BufferedInputStream(new FileInputStream(resource.getLocation().toString())), resource.getFullPath().removeFirstSegments(1).toString());
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "Could not read file " + resource.getLocation(), (Throwable)e));
            }
        }
    }

    private static class PerlFileCounter
    implements IResourceVisitor {
        private static final String PERL_EDITOR_ID = "org.epic.perleditor.editors.PerlEditor";
        private static final String EMB_PERL_FILE_EXTENSION = "epl";
        private final IEditorRegistry registry = PerlDebugPlugin.getDefault().getWorkbench().getEditorRegistry();
        private int count = 0;

        public int getCount() {
            return this.count;
        }

        public boolean visit(IResource resource) throws CoreException {
            IEditorDescriptor defaultEditorDescriptor = this.registry.getDefaultEditor(resource.getFullPath().toString());
            if (defaultEditorDescriptor != null && defaultEditorDescriptor.getId().equals(PERL_EDITOR_ID) && !resource.getFileExtension().equals(EMB_PERL_FILE_EXTENSION)) {
                ++this.count;
            }
            return true;
        }
    }
}

