/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.db;

import org.eclipse.core.runtime.Assert;
import org.epic.debug.db.DumpedEntity;

class DumpedEntityReader {
    private final String input;
    private int i;

    public DumpedEntityReader(String input) {
        Assert.isNotNull((Object)input);
        this.input = input;
        this.i = 0;
    }

    public boolean hasMoreEntities() {
        return this.i < this.input.length();
    }

    public DumpedEntity nextEntity() {
        String name = this.token();
        int refChainLength = Integer.parseInt(this.token());
        String[] refChain = new String[refChainLength];
        int i = 0;
        while (i < refChainLength) {
            refChain[i] = this.token();
            ++i;
        }
        String value = this.token();
        int valueLength = Integer.parseInt(this.token());
        return new DumpedEntity(name, refChain, value, valueLength);
    }

    private String token() {
        int j = this.i;
        while (this.input.charAt(this.i) != '|') {
            ++this.i;
        }
        int tokenLength = Integer.parseInt(this.input.substring(j, this.i));
        j = this.i;
        this.i = j + tokenLength + 1;
        if (this.i < this.input.length() && (this.input.charAt(this.i) == '\n' || this.input.charAt(this.i) == '|')) {
            ++this.i;
        }
        return this.input.substring(j + 1, j + tokenLength + 1);
    }
}

