/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.db;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IVariable;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.db.ArrayElement;
import org.epic.debug.db.ArraySlice;
import org.epic.debug.db.DumpedEntityReader;
import org.epic.debug.db.PerlValue;
import org.epic.debug.db.PerlVariable;

class ArrayValue
extends PerlValue {
    private final IVariable[] vars = this.parseArrayContent(this.dumpEntity("dump_array_expr"));

    public ArrayValue(IDebugTarget target, PerlVariable holder) throws DebugException {
        super(target, holder);
    }

    public IVariable[] getVariables() throws DebugException {
        return this.vars;
    }

    public boolean hasVariables() throws DebugException {
        return this.vars.length > 0;
    }

    private IVariable[] parseArrayContent(String content) throws DebugException {
        DumpedEntityReader r = new DumpedEntityReader(content);
        ArrayList<ArraySlice> slices = null;
        ArrayList<ArrayElement> vars = new ArrayList<ArrayElement>();
        try {
            int i = 0;
            int sliceStartI = 0;
            while (r.hasMoreEntities()) {
                vars.add(new ArrayElement(this.getHolder().getDebuggerInterface(), this.getHolder(), r.nextEntity()));
                ++i;
                if (vars.size() != 1000) continue;
                if (slices == null) {
                    slices = new ArrayList<ArraySlice>();
                }
                slices.add(new ArraySlice(this.getHolder(), vars, sliceStartI));
                sliceStartI = i;
                vars = new ArrayList();
            }
            if (slices != null) {
                if (!vars.isEmpty()) {
                    slices.add(new ArraySlice(this.getHolder(), vars, sliceStartI));
                }
                return slices.toArray(new IVariable[slices.size()]);
            }
            return vars.toArray(new IVariable[vars.size()]);
        }
        catch (Exception e) {
            PerlDebugPlugin.log(e);
            throw new DebugException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "An error occurred while dumping array content; contents of the Variables view may become invalid", (Throwable)e));
        }
    }
}

