/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.db;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.db.ArraySliceValue;
import org.epic.debug.db.PerlVariable;

class ArraySlice
extends DebugElement
implements IVariable {
    private final ArraySliceValue value;

    protected ArraySlice(PerlVariable array, List elements, int startIndex) throws DebugException {
        super(array.getDebugTarget());
        this.value = new ArraySliceValue(array, elements, startIndex);
    }

    public String getName() throws DebugException {
        return "[" + this.value.getStartIndex() + ".." + this.value.getEndIndex() + "]";
    }

    public String getReferenceTypeName() throws DebugException {
        return null;
    }

    public IValue getValue() throws DebugException {
        return this.value;
    }

    public boolean hasValueChanged() throws DebugException {
        IVariable[] vars = this.value.getVariables();
        int i = 0;
        while (i < vars.length) {
            if (vars[i].hasValueChanged()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    public void setValue(String expression) throws DebugException {
        this.throwNotSupported();
    }

    public void setValue(IValue value) throws DebugException {
        this.throwNotSupported();
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String expression) throws DebugException {
        this.throwNotSupported();
        return false;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        this.throwNotSupported();
        return false;
    }

    private void throwNotSupported() throws DebugException {
        throw new DebugException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 5011, "Operation not supported", null));
    }
}

