/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.remote;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.epic.debug.DebugTarget;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.db.DebuggerInterface;
import org.epic.debug.util.DebuggerProxy;
import org.epic.debug.util.IPathMapper;
import org.epic.debug.util.RemotePort;

class RemoteDebugTarget
extends DebugTarget {
    private final IDebugEventSetListener listener = new IDebugEventSetListener(){

        public void handleDebugEvents(DebugEvent[] events) {
            int i = 0;
            while (i < events.length) {
                try {
                    if (events[i].getKind() == 8 && RemoteDebugTarget.this.getThreads()[0].equals(events[i].getSource())) {
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        RemoteDebugTarget.this.shutdown();
                        return;
                    }
                }
                catch (DebugException e) {
                    PerlDebugPlugin.log(e);
                }
                ++i;
            }
        }
    };

    public RemoteDebugTarget(ILaunch launch, DebuggerProxy process, RemotePort debugPort, IPathMapper pathMapper) throws CoreException {
        super(launch, process, debugPort, pathMapper);
        DebugPlugin.getDefault().addDebugEventListener(this.listener);
    }

    protected DebuggerInterface initDebuggerInterface(DebuggerInterface db) throws DebugException {
        boolean shouldRedirectIO = true;
        try {
            shouldRedirectIO = this.getLaunch().getLaunchConfiguration().getAttribute("ATTR_REMOTE_CAPTURE_OUTPUT", true);
        }
        catch (CoreException coreException) {}
        if (this.getProxy().getIOHost() != null && shouldRedirectIO) {
            try {
                db.redirectIO(this.getProxy().getIOHost(), this.getProxy().getIOPort());
                db.redirectError(this.getProxy().getIOHost(), this.getProxy().getErrorPort());
            }
            catch (IOException e) {
                this.throwDebugException(e);
            }
        }
        return super.initDebuggerInterface(db);
    }

    private DebuggerProxy getProxy() {
        return (DebuggerProxy)this.getProcess();
    }
}

