/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.local;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.epic.core.PerlCore;
import org.epic.core.PerlProject;
import org.epic.core.util.PerlExecutableUtilities;
import org.epic.debug.DebugTarget;
import org.epic.debug.LaunchConfigurationDelegate;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.PerlTarget;
import org.epic.debug.local.RunLocalTarget;
import org.epic.debug.util.ExecutionArguments;
import org.epic.debug.util.RemotePort;
import org.epic.perleditor.PerlEditorPlugin;

public class LocalLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    protected void doLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block2: {
            try {
                PerlTarget target = this.isDebugMode(launch) ? this.startDebugTarget(configuration, launch, monitor) : this.startRunTarget(configuration, launch, monitor);
                launch.addDebugTarget((IDebugTarget)target);
            }
            catch (CoreException e) {
                launch.terminate();
                if (e.getStatus().getCode() == 10000) break block2;
                throw e;
            }
        }
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (!PerlEditorPlugin.getDefault().requirePerlInterpreter(true)) {
            return false;
        }
        return super.preLaunchCheck(configuration, mode, monitor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String[] createCommandLine(ILaunch launch) throws CoreException {
        ExecutionArguments exArgs;
        ILaunchConfiguration configuration = launch.getLaunchConfiguration();
        String perlParams = configuration.getAttribute("ATTR_PERL_PARAMETERS", "");
        perlParams = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(perlParams);
        String progParams = configuration.getAttribute("ATTR_PROGRAM_PARAMETERS", "");
        progParams = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(progParams);
        boolean consoleOutput = configuration.getAttribute(IDebugUIConstants.ATTR_CAPTURE_IN_CONSOLE, true);
        List fCmdList = PerlExecutableUtilities.getPerlCommandLine((PerlProject)PerlCore.create((IProject)this.getProject(launch)));
        fCmdList.add("-I" + PerlDebugPlugin.getDefault().getInternalDebugInc());
        fCmdList.add("-I" + PerlExecutableUtilities.resolveIncPath((String)this.getLocalWorkingDir(launch).toFile().getAbsolutePath()));
        if (launch.getLaunchMode().equals("debug")) {
            fCmdList.add("-d");
        }
        if (PerlEditorPlugin.getDefault().getWarningsPreference()) {
            fCmdList.add("-w");
        }
        if (PerlEditorPlugin.getDefault().getTaintPreference()) {
            fCmdList.add("-T");
        }
        if (consoleOutput) {
            fCmdList.add("-Mautoflush_epic");
        }
        if (perlParams != null && perlParams.length() > 0) {
            exArgs = new ExecutionArguments(perlParams);
            fCmdList.addAll(exArgs.getProgramArgumentsL());
        }
        if (this.isCygwin()) {
            IPath cygwinPath = this.getPathMapper(launch).getDebuggerPath(this.getScriptPath(launch), null);
            if (cygwinPath == null) throw new CoreException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, MessageFormat.format("Could not translate path {0} into a Cygwin path.\nMake sure your Cygwin mounts are configured properly.", this.getScriptPath(launch).toOSString()), null));
            fCmdList.add(cygwinPath.toString());
        } else {
            fCmdList.add(this.getScriptPath(launch).toString());
        }
        if (progParams == null || progParams.length() <= 0) return fCmdList.toArray(new String[fCmdList.size()]);
        exArgs = new ExecutionArguments(progParams);
        fCmdList.addAll(exArgs.getProgramArgumentsL());
        return fCmdList.toArray(new String[fCmdList.size()]);
    }

    private void dumpLaunchDetails(String[] cmdParams, String[] env, IPath workingDir) {
        if (!PerlEditorPlugin.getDefault().getDebugConsolePreference()) {
            return;
        }
        StringBuffer buf = new StringBuffer("Starting Perl debugger:\n");
        buf.append("Command line:\n");
        int i = 0;
        while (i < cmdParams.length) {
            buf.append(cmdParams[i]);
            buf.append('\n');
            ++i;
        }
        buf.append("Working directory: ");
        buf.append(workingDir.toFile().getAbsolutePath());
        buf.append("\nEnvironment:\n");
        i = 0;
        while (i < env.length) {
            buf.append(env[i]);
            buf.append('\n');
            ++i;
        }
        ILog log = PerlDebugPlugin.getDefault().getLog();
        log.log((IStatus)new Status(1, PerlDebugPlugin.getUniqueIdentifier(), 0, buf.toString(), null));
    }

    private File getDefaultWorkingDir(ILaunch launch) throws CoreException {
        return this.getScriptPath(launch).removeLastSegments(1).toFile();
    }

    private IPath getLocalWorkingDir(ILaunch launch) throws CoreException {
        try {
            File workingDir = this.verifyWorkingDirectory(launch.getLaunchConfiguration());
            if (workingDir == null) {
                workingDir = this.getDefaultWorkingDir(launch);
            }
            return Path.fromOSString((String)workingDir.getAbsolutePath());
        }
        catch (CoreException e) {
            PerlDebugPlugin.getDefault().logError("Could not start Perl interpreter: invalid working directory", (Exception)((Object)e));
            throw e;
        }
    }

    private IPath getScriptPath(ILaunch launch) throws CoreException {
        String scriptFile = launch.getLaunchConfiguration().getAttribute("ATTR_STARTUP_FILE", "");
        return this.getProject(launch).getFile((IPath)new Path(scriptFile)).getLocation();
    }

    private IPath getWorkingDirectoryPath(ILaunchConfiguration configuration) throws CoreException {
        String path = configuration.getAttribute("ATTR_WORKING_DIRECTORY", null);
        if (path == null) {
            return null;
        }
        path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(path);
        return new Path(path);
    }

    private Process startPerlInterpreter(String[] cmdParams, String[] env, IPath workingDir) throws CoreException {
        try {
            Process perlProcess = Runtime.getRuntime().exec(cmdParams, env, workingDir.toFile());
            return perlProcess;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "Failed to launch Perl interpreter process; inspect log for details", (Throwable)e));
        }
    }

    private PerlTarget startDebugTarget(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        RemotePort debugPort = new RemotePort("DebugTarget.mDebugPort");
        debugPort.startConnect();
        IProcess process = this.startPerlProcess(launch, "Perl Debugger", debugPort.getServerPort());
        if (debugPort.waitForConnect(true) != 1) {
            PerlDebugPlugin.errorDialog("Timed out while waiting for Perl debugger connection");
            launch.terminate();
            return null;
        }
        return new DebugTarget(launch, process, debugPort, this.getPathMapper(launch));
    }

    private IProcess startPerlProcess(ILaunch launch, String processName, int debugPort) throws CoreException {
        String[] cmdParams = this.createCommandLine(launch);
        String[] env = PerlDebugPlugin.getDebugEnv(launch, debugPort);
        IPath workingDir = this.getLocalWorkingDir(launch);
        this.dumpLaunchDetails(cmdParams, env, workingDir);
        Process perlProcess = this.startPerlInterpreter(cmdParams, env, workingDir);
        HashMap<String, String> attr = new HashMap<String, String>(1);
        attr.put(IProcess.ATTR_PROCESS_TYPE, "perl");
        return DebugPlugin.newProcess((ILaunch)launch, (Process)perlProcess, (String)processName, attr);
    }

    private PerlTarget startRunTarget(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IProcess process = this.startPerlProcess(launch, "Perl Interpreter", -1);
        return new RunLocalTarget(launch, process);
    }

    private File verifyWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        File dir;
        IPath path = this.getWorkingDirectoryPath(configuration);
        if (path == null) {
            return null;
        }
        if (path.isAbsolute() && (dir = new File(path.toOSString())).isDirectory()) {
            return dir;
        }
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (res instanceof IContainer && res.exists()) {
            return res.getLocation().toFile();
        }
        throw new CoreException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, MessageFormat.format("Working directory does not exist: {0}", path.toString()), null));
    }
}

