/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.db;

import org.eclipse.debug.core.DebugException;
import org.epic.debug.db.DebuggerInterface;
import org.epic.debug.db.DumpedEntity;
import org.epic.debug.db.PerlVariable;
import org.epic.debug.db.StackFrame;

class PackageVariable
extends PerlVariable {
    protected PackageVariable(DebuggerInterface db, StackFrame frame, DumpedEntity entity) throws DebugException {
        super(db, frame, entity);
    }

    public String getExpression() throws DebugException {
        String name = this.getName();
        StringBuffer buf = new StringBuffer();
        int refCount = this.getDumpedEntity().getReferenceCount();
        if (refCount == 0) {
            if (this.isHash()) {
                buf.append("+{");
                buf.append(name.substring(0, 1));
                buf.append("main::");
                buf.append(name.substring(1));
                buf.append('}');
            } else {
                buf.append('\\');
                buf.append(name.substring(0, 1));
                buf.append("main::");
                buf.append(name.substring(1));
            }
        } else {
            int i = 0;
            while (i < refCount - 1) {
                buf.append("${");
                ++i;
            }
            buf.append("$main::");
            buf.append(name.substring(1));
            i = 0;
            while (i < refCount - 1) {
                buf.append("}");
                ++i;
            }
        }
        return buf.toString();
    }

    public boolean isPackageScope() {
        return true;
    }
}

