/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.db;

import gnu.regexp.REMatch;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.epic.debug.db.IPPosition;
import org.epic.debug.db.RE;

public class DebuggerInterface {
    private final RE re = new RE();
    private final char[] buf = new char[1024];
    private BufferedReader in;
    private PrintWriter out;
    private final String perlVersion;
    private Boolean hasPadWalker;
    public static final int CMD_NONE = 0;
    public static final int CMD_STEP_INTO = 1;
    public static final int CMD_STEP_OVER = 2;
    public static final int CMD_STEP_RETURN = 4;
    public static final int CMD_RESUME = 8;
    public static final int CMD_SUSPEND = 16;
    public static final int CMD_TERMINATE = 32;
    public static final int CMD_CLEAR_OUTPUT = 64;
    public static final int CMD_EXEC = 128;
    public static final int CMD_EVAL = 256;
    public static final int CMD_MODIFIER_RANGE_START = 1024;
    public static final int CMD_MODIFIER_SKIP_EVAL_CMD_RESULT = 1024;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.epic.debug.db.DebuggerInterface");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public DebuggerInterface(BufferedReader in, PrintWriter out) throws IOException {
        if (!$assertionsDisabled && in == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && out == null) {
            throw new AssertionError();
        }
        this.in = in;
        this.out = out;
        this.runSyncCommand(64, null);
        this.perlVersion = this.getPerlVersion();
    }

    public synchronized void dispose() {
        if (this.in != null) {
            try {
                this.quit();
            }
            catch (IOException iOException) {}
            try {
                this.in.close();
            }
            catch (IOException iOException) {}
            this.out.close();
            this.in = null;
            this.out = null;
        }
    }

    public synchronized String eval(String code) throws IOException {
        return this.runSyncCommand(128, code);
    }

    public synchronized boolean fileExists(IPath path) throws IOException {
        String osPath = this.getOSPath(path).replaceAll("\\\\", "\\\\\\\\");
        return "1".equals(this.eval("print $DB::OUT -f '" + osPath + "'"));
    }

    public synchronized IPPosition getCurrentIP() throws IOException {
        String output = this.runSyncCommand(128, ".");
        REMatch result = this.re.IP_POS_CODE.getMatch((Object)output);
        if (result == null) {
            result = this.re.IP_POS.getMatch((Object)output);
            if (result == null) {
                throw new IOException("could not match re.IP_POS in {" + output + "}");
            }
            String filename = result.toString(1);
            REMatch temp = this.re.IP_POS_EVAL.getMatch((Object)filename);
            if (temp != null) {
                result = temp;
            }
        }
        return new IPPosition((IPath)new Path(result.toString(1)), Integer.parseInt(result.toString(2)));
    }

    public synchronized String getOS() throws IOException {
        return this.runSyncCommand(128, "print $DB::OUT $^O;").trim();
    }

    public synchronized String getPerlVersion() throws IOException {
        return this.runSyncCommand(128, "printf $DB::OUT \"%vd\", $^V;").trim();
    }

    public synchronized String getStackTrace() throws IOException {
        return this.runSyncCommand(128, "T");
    }

    public synchronized boolean hasPadWalker() throws IOException {
        if (this.hasPadWalker == null) {
            String result = this.runSyncCommand(128, "print $DB::OUT eval { require PadWalker; PadWalker->VERSION(0.08) }");
            this.hasPadWalker = new Boolean(result.length() > 0);
        }
        return this.hasPadWalker;
    }

    public synchronized String quit() throws IOException {
        return this.runSyncCommand(32, null);
    }

    public synchronized String redirectError(String host, int port) throws IOException {
        String command = "require IO::Socket; {my $OUT;$OUT = new IO::Socket::INET(Timeout  => '10',PeerAddr => '" + host + ":" + port + "'," + "Proto    => 'tcp',);" + "STDERR->fdopen($OUT,\"w\");}";
        return this.runSyncCommand(128, command);
    }

    public synchronized String redirectIO(String host, int port) throws IOException {
        String command = "require IO::Socket; {my $OUT;$OUT = new IO::Socket::INET(Timeout  => '10',PeerAddr => '" + host + ":" + port + "'," + "Proto    => 'tcp',);" + "STDOUT->fdopen($OUT,\"w\");" + "STDIN->fdopen($OUT,\"r\");}";
        return this.runSyncCommand(128, command);
    }

    public synchronized String resume() throws IOException {
        return this.runSyncCommand(8, null);
    }

    public synchronized String setFrame(int count) throws IOException {
        String cmd = this.perlVersion.startsWith("5.6") ? "O frame=" + count : "o frame=" + count;
        return this.runSyncCommand(128, cmd);
    }

    public synchronized String removeLineBreakpoint(int line) throws IOException {
        String command = this.perlVersion.startsWith("5.6") ? "d " + line : "B " + line;
        return this.runSyncCommand(128, command);
    }

    public synchronized boolean setLineBreakpoint(int line, String condition) throws IOException {
        String output = this.runSyncCommand(128, "b " + line + (condition != null ? " " + condition : ""));
        return this.re.SET_LINE_BREAKPOINT.getAllMatches((Object)output).length == 0;
    }

    public synchronized String setLoadBreakpoint(IPath path) throws IOException {
        return this.runSyncCommand(128, "b load " + this.getOSPath(path));
    }

    public synchronized String stepInto() throws IOException {
        return this.runSyncCommand(1, null);
    }

    public synchronized String stepOver() throws IOException {
        return this.runSyncCommand(2, null);
    }

    public synchronized String stepReturn() throws IOException {
        return this.runSyncCommand(4, null);
    }

    public synchronized boolean switchToFile(IPath path) throws IOException {
        String output = this.runSyncCommand(128, "f " + this.getOSPath(path));
        return this.re.SWITCH_FILE_FAIL.getAllMatches((Object)output).length == 0;
    }

    private String getOSPath(IPath path) throws IOException {
        return path.toString();
    }

    private String runSyncCommand(int command, String code) throws IOException {
        if (!$assertionsDisabled && Thread.currentThread().getName().indexOf("Main") != -1) {
            throw new AssertionError((Object)"forbidden DebuggerInterface use from display thread");
        }
        Command cmd = new Command(command, code);
        return cmd.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String runCommand(int command, String code) throws IOException {
        command = this.maskCommandModifiers(command);
        switch (command) {
            case 1: {
                this.outputLine("s");
                break;
            }
            case 2: {
                this.outputLine("n");
                break;
            }
            case 4: {
                this.outputLine("r");
                break;
            }
            case 8: {
                this.outputLine("c");
                break;
            }
            case 32: {
                this.outputLine("q");
                break;
            }
            case 16: 
            case 64: {
                break;
            }
            case 128: 
            case 256: {
                this.outputLine(code);
                break;
            }
            default: {
                throw new RuntimeException("unrecognized command " + command);
            }
        }
        DebuggerInterface debuggerInterface = this;
        synchronized (debuggerInterface) {
            if (this.out == null) {
                throw new SessionTerminatedException("disposed");
            }
        }
        return this.readCommandOutput();
    }

    private int maskCommandModifiers(int command) {
        return command & 0x3FF;
    }

    private int hasCommandTerminated(String output) {
        REMatch[] matches = this.re.CMD_FINISHED1.getAllMatches((Object)output);
        if (matches != null && matches.length > 0) {
            return matches[matches.length - 1].getStartIndex();
        }
        matches = this.re.CMD_FINISHED2.getAllMatches((Object)output);
        if (matches != null && matches.length > 0) {
            return matches[matches.length - 1].getStartIndex();
        }
        return -1;
    }

    private boolean hasSessionTerminated(String fOutput) {
        boolean erg = this.re.SESSION_FINISHED1.isMatch((Object)fOutput);
        int count = this.re.SESSION_FINISHED1.getAllMatches((Object)fOutput).length;
        if (erg || count > 0) {
            return true;
        }
        erg = this.re.SESSION_FINISHED2.isMatch((Object)fOutput);
        count = this.re.SESSION_FINISHED2.getAllMatches((Object)fOutput).length;
        return erg || count > 0;
    }

    private synchronized void outputLine(String line) {
        if (this.out != null) {
            this.out.println(line);
            this.out.flush();
        }
    }

    /*
     * Unable to fully structure code
     */
    private String readCommandOutput() throws IOException, SessionTerminatedException {
        output = new StringBuffer();
        do {
            block9: {
                try {
                    while (true) lbl-1000:
                    // 2 sources

                    {
                        if ((count = this.in.read(this.buf)) > 0) {
                            output.append(this.buf, 0, count);
                        }
                        try {
                            if (this.in.ready()) {
                                continue;
                            }
                            break block9;
                        }
                        catch (IOException v0) {
                        }
                        break;
                    }
                }
                catch (IOException v1) {
                    throw new SessionTerminatedException("IOException while reading debugger's response");
                }
                {
                    ** while (true)
                }
            }
            inspectLen = Math.min(output.length(), 350);
            currentOutput = output.substring(output.length() - inspectLen, output.length());
            endIndex = this.hasCommandTerminated(currentOutput);
            if (count < 0) {
                throw new SessionTerminatedException("EOF from debugger");
            }
            if (!this.hasSessionTerminated(currentOutput)) continue;
            throw new SessionTerminatedException("Debugger session terminated normally");
        } while (endIndex == -1);
        ret = output.substring(0, output.length() - inspectLen + endIndex);
        return ret;
    }

    public class Command {
        private final int type;
        private final String code;

        public Command(int type, String code) {
            this.type = type;
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public boolean isStepCommand() {
            return this.type == 1 || this.type == 2 || this.type == 4;
        }

        public int getType() {
            return this.type;
        }

        public String run() throws IOException, SessionTerminatedException {
            return DebuggerInterface.this.runCommand(this.type, this.code);
        }

        public String toString() {
            return "Command #" + this.type + " {" + this.code + "}";
        }
    }

    public static class SessionTerminatedException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public SessionTerminatedException(String msg) {
            super(msg);
        }
    }
}

