/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.db;

import java.io.IOException;
import org.epic.debug.db.DebuggerInterface;
import org.epic.debug.db.IPPosition;
import org.epic.debug.db.PerlDebugThread;

abstract class DebugCommand {
    public static final int STEP_END = 8;
    public static final int BREAKPOINT = 16;
    public static final int TERMINATED = 25;
    private final PerlDebugThread thread;
    private int completionStatus;

    protected DebugCommand(PerlDebugThread thread) {
        this.thread = thread;
    }

    public int getCompletionStatus() {
        return this.completionStatus;
    }

    public boolean hasSuspended() {
        return this.completionStatus == 8 || this.completionStatus == 16;
    }

    public void run() throws IOException {
        this.completionStatus = this.runImpl();
        this.getThread().debugCommandFinished(this);
    }

    protected DebuggerInterface getDB() {
        return this.thread.getDB();
    }

    protected PerlDebugThread getThread() {
        return this.thread;
    }

    protected final IPPosition maybeSkipStringEval(IPPosition startIP) throws IOException {
        IPPosition endIP = this.getDB().getCurrentIP();
        while (endIP != null && endIP.equals(startIP)) {
            this.getDB().stepInto();
            endIP = this.getDB().getCurrentIP();
        }
        return endIP;
    }

    protected abstract int runImpl() throws IOException;
}

