/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.cgi;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.epic.debug.DebugTarget;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.util.IPathMapper;
import org.epic.debug.util.RemotePort;

public class CGIDebugTarget
extends DebugTarget {
    private final IDebugEventSetListener listener = new IDebugEventSetListener(){

        public void handleDebugEvents(DebugEvent[] events) {
            int i = 0;
            while (i < events.length) {
                try {
                    if (events[i].getKind() == 8 && CGIDebugTarget.this.getThreads()[0].equals(events[i].getSource())) {
                        CGIDebugTarget.this.debugSessionTerminated();
                        return;
                    }
                }
                catch (DebugException e) {
                    PerlDebugPlugin.log(e);
                }
                ++i;
            }
        }
    };

    private CGIDebugTarget(CGIDebugTarget previous) throws CoreException {
        super(previous.getLaunch(), previous.getProcess(), previous.getRemotePort(), previous.getPathMapper());
        DebugPlugin.getDefault().addDebugEventListener(this.listener);
    }

    public CGIDebugTarget(ILaunch launch, IProcess process, RemotePort debugPort, IPathMapper pathMapper) throws CoreException {
        super(launch, process, debugPort, pathMapper);
        DebugPlugin.getDefault().addDebugEventListener(this.listener);
    }

    public String getName() throws DebugException {
        return "CGI Perl Debugger";
    }

    public void debugSessionTerminated() {
        this.fireTerminateEvent();
        this.getLaunch().removeDebugTarget((IDebugTarget)this);
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (CGIDebugTarget.this.acceptNewDebugger()) {
                    CGIDebugTarget.this.respawn();
                }
            }
        });
    }

    private boolean acceptNewDebugger() {
        this.getRemotePort().startReconnect();
        if (this.getRemotePort().waitForConnect(false) != 1) {
            if (this.getProcess().isTerminated()) {
                return false;
            }
            PerlDebugPlugin.errorDialog("Could not connect to debug port!");
            try {
                this.terminate();
            }
            catch (DebugException e) {
                PerlDebugPlugin.log(e);
            }
            return false;
        }
        return true;
    }

    private void respawn() {
        try {
            DebugPlugin.getDefault().removeDebugEventListener(this.listener);
            this.getLaunch().addDebugTarget((IDebugTarget)new CGIDebugTarget(this));
        }
        catch (CoreException e) {
            PerlDebugPlugin.log(e);
            try {
                this.terminate();
            }
            catch (DebugException _e) {
                PerlDebugPlugin.log(_e);
            }
        }
    }
}

