/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.actions;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.epic.perleditor.actions.PerlEditorAction;
import org.epic.perleditor.editors.PerlEditor;
import org.epic.perleditor.editors.util.SourceFormatter;

public class FormatSourceAction
extends PerlEditorAction {
    public FormatSourceAction(PerlEditor editor) {
        super(editor);
    }

    protected void doRun() {
        PerlEditor editor = this.getEditor();
        IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        StringBuffer text = new StringBuffer();
        text.append(document.get());
        if (text.length() == 0) {
            return;
        }
        String myLineSep = "";
        try {
            myLineSep = document.getLineDelimiter(0);
        }
        catch (BadLocationException badLocationException) {}
        String posAnchor = "\u00f6\u00df\u00a7\u00b2";
        String insertAnchor = "#" + posAnchor;
        while (text.indexOf(insertAnchor) >= 0) {
            insertAnchor = String.valueOf(insertAnchor) + posAnchor;
        }
        ISourceViewer viewer = editor.getViewer();
        StyledText myTextWidget = viewer.getTextWidget();
        int lineOfScreen = myTextWidget.getLineAtOffset(myTextWidget.getCaretOffset());
        int insPos = 0;
        if (lineOfScreen > 0) {
            insPos = lineOfScreen == myTextWidget.getLineCount() - 1 ? text.length() : myTextWidget.getOffsetAtLine(lineOfScreen + 1) - myLineSep.length();
            text.insert(insPos, insertAnchor);
            lineOfScreen -= myTextWidget.getTopIndex();
        }
        StringBuffer newText = new StringBuffer();
        String formatText = SourceFormatter.format("" + text, this.getLog());
        newText.append(formatText);
        if (formatText == null || formatText.length() == 0 || newText.equals(text) || formatText.equals(insertAnchor)) {
            return;
        }
        int newPosAnchor = 0;
        if (insPos > 0) {
            newPosAnchor = newText.indexOf(insertAnchor);
            if (newPosAnchor < 0) {
                newText.delete(0, newText.length());
                newText.append(SourceFormatter.format(document.get(), this.getLog()));
                newPosAnchor = 0;
            } else {
                newText.delete(newPosAnchor, newPosAnchor + insertAnchor.length());
            }
        }
        document.set(newText.toString());
        myTextWidget.setCaretOffset(myTextWidget.getOffsetAtLine(myTextWidget.getLineAtOffset(newPosAnchor)));
        myTextWidget.setTopIndex(myTextWidget.getLineAtOffset(newPosAnchor) - lineOfScreen);
    }

    protected String getPerlEditorActionId() {
        return "org.epic.perleditor.actions.FormatSourceAction";
    }
}

