package optitools;
require Exporter;

our @ISA		= qw(Exporter);
our @EXPORT		= qw(core_fight check_optimars);
our $VERSION	= 1.00;

sub core_fight
{
	# execution of the optimars under different os's. mars-spec are given, mars is
    # default by 'optimars'

    my @resultlines = (); # store the optimars output.

    my $params = join ' ', 'optimars', @_, '>output.lst';

	my $retcode = system($params);

    open(OP, 'output.lst');
	@resultlines=<OP>;
	close(OP);
	unlink('output.lst');
	if ( $retcode )
    {
    	foreach ( @resultlines )
    	{
    		print;
    	}
    	die "Returncode : $retcode\n";
    	
    }
    return @resultlines;
}


sub check_optimars

{
    my @checklines = core_fight();

    my $version_need = 1; # For optimars v0.1 or higher.

    my @version_found = $checklines[0] =~ m/(\d+)/g;
    if ( $version_found[0]*10+$version_found[1] < $version_need )
    {
    	die "Sorry, this optimax requires optimars v0.1 or higher.\n";
    }
}

1;
