/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2000-2009 Sun Microsystems, Inc. All rights reserved. 
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License ("CDDL") (collectively, the "License").  You may
 * not use this file except in compliance with the License.  You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or mq/legal/LICENSE.txt.  See the License for the specific language
 * governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at mq/legal/LICENSE.txt.  Sun designates
 * this particular file as subject to the "Classpath" exception as provided by
 * Sun in the GPL Version 2 section of the License file that accompanied this
 * code.  If applicable, add the following below the License Header, with the
 * fields enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or  to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright holder. 
 */

/*
 * @(#)VersionDAO.java	1.8 06/29/07
 */ 

package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.util.BrokerException;

import java.sql.Connection;

/**
 * This class is an interface for the Version table which will be implemented
 * by database specific code.
 */
public interface VersionDAO extends BaseDAO {

    /**
     * Version table:
     * Version information about the current store.
     *
     * CREATE TABLE MQVER<schemaVersion>[C<clusterID>|S<brokerID>] (
     *      STORE_VERSION   INTEGER NOT NULL,
     *      LOCK_ID         VARCHAR(100),
     *      REAP_TIME       BIGINT
     * );
     *
     * STORE_VERSION - Version of this store
     * LOCK_ID - Identifier of the broker or imqdbmgr that is currently using the store
     * REAP_TIME - Minimum time that a broker will maintain resources from a
     * 	failed broker to allow for clients to reconnect. After this time has
     * 	expired, temporary destinations and other information may be reaped
     * 	from the system.
     */
    public static final String TABLE = "MQVER";
    public static final String TABLE_NAME_PREFIX = TABLE + DBConstants.SCHEMA_VERSION;
    public static final String STORE_VERSION_COLUMN = "STORE_VERSION";
    public static final String LOCK_ID_COLUMN = "LOCK_ID";

    void insert( Connection conn, int storeVersion )
        throws BrokerException;

    boolean updateLock( Connection conn, int storeVersion, String newLockID,
        String oldLockID ) throws BrokerException;

    int getStoreVersion( Connection conn ) throws BrokerException;

    String getLock( Connection conn, int storeVersion ) throws BrokerException;
}
