package com.sun.messaging.jmq.jmsserver.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;

public class TransactionWorkMessageAck {

	DestinationUID destUID;
	SysMessageID sysMessageID;
	ConsumerUID consumerID;

	public TransactionWorkMessageAck() {

	}

	public TransactionWorkMessageAck(DestinationUID dest, SysMessageID sysMessageID,
			ConsumerUID consumerID) {
		this.destUID = dest;
		this.sysMessageID = sysMessageID;
		this.consumerID = consumerID;
	}

	public DestinationUID getDestUID() {
		return destUID;
	}

	public void setDest(DestinationUID dest) {
		this.destUID = dest;
	}

	public SysMessageID getSysMessageID() {
		return sysMessageID;
	}

	public void setSysMessageID(SysMessageID sysMessageID) {
		this.sysMessageID = sysMessageID;
	}

	public ConsumerUID getConsumerID() {
		return consumerID;
	}

	public void setConsumerID(ConsumerUID consumerID) {
		this.consumerID = consumerID;
	}
	
	public String toString()
	{
		StringBuffer result = new StringBuffer("dest=").append(destUID);
		result.append(" sysMessageID=").append(sysMessageID);
		result.append(" consumerID=").append(consumerID);		
		return result.toString();
	}
	
	public void writeWork(DataOutputStream dos) throws IOException {
		dos.writeUTF(destUID.toString()); 
		sysMessageID.writeID(dos);
		dos.writeLong(consumerID.longValue()); 
	}
	
	public void readWork(DataInputStream dis) throws IOException,
			BrokerException {
		String dest = dis.readUTF();
		destUID = new DestinationUID(dest);
		sysMessageID = new SysMessageID();
		sysMessageID.readID(dis);
		long cid = dis.readLong();
		consumerID = new ConsumerUID(cid);
	}
	
}
