/*
 * Decompiled with CFR 0.152.
 */
package com.ermapper.ecw;

import com.ermapper.ecw.JNCSException;
import com.ermapper.ecw.JNCSFileNotOpenException;
import com.ermapper.ecw.JNCSFileOpenFailedException;
import com.ermapper.ecw.JNCSInvalidSetViewException;
import com.ermapper.ecw.JNCSNativeLibraryException;
import com.ermapper.ecw.JNCSProgressiveUpdate;
import com.ermapper.util.JNCSDatasetPoint;
import com.ermapper.util.JNCSWorldPoint;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;

public class JNCSFile
implements JNCSProgressiveUpdate {
    private static boolean bUseNativeMethods = false;
    private static boolean bSecurityError = false;
    private static boolean bUnsatisfiedLink = false;
    static boolean bHaveClassInit = false;
    static boolean debug = false;
    public static final int ECW_CELL_UNITS_INVALID = 0;
    public static final int ECW_CELL_UNITS_METERS = 1;
    public static final int ECW_CELL_UNITS_DEGREES = 2;
    public static final int ECW_CELL_UNITS_FEET = 3;
    public int numBands;
    public int width;
    public int height;
    public double originX;
    public double originY;
    public double cellIncrementX;
    public double cellIncrementY;
    public int cellSizeUnits;
    public double compressionRate;
    public boolean progressive;
    public String fileName;
    public String datum;
    public String projection;
    public boolean bIsOpen;
    private long nativeDataPointer;
    private static final boolean doGarbageCollectionOnClose = false;
    private static final int ECW_OK = 0;
    private int nFileSetViewDatasetTLX;
    private int nFileSetViewDatasetTLY;
    private int nFileSetViewDatasetBRX;
    private int nFileSetViewDatasetBRY;
    private int nFileSetViewWidth;
    private int nFileSetViewHeight;
    private double dFileSetViewWorldTLX;
    private double dFileSetViewWorldTLY;
    private double dFileSetViewWorldBRX;
    private double dFileSetViewWorldBRY;
    private boolean bSetViewIsWorld = false;
    protected JNCSProgressiveUpdate progImageClient = null;
    static Class class$java$lang$String;

    private native int ECWOpen(String var1, boolean var2);

    private native void ECWClose(boolean var1);

    private native int ECWSetView(int var1, int[] var2, int var3, int var4, int var5, int var6, double var7, double var9, double var11, double var13, int var15, int var16);

    private native int ECWReadLineRGBA(int[] var1);

    private native int ECWReadImageRGBA(int[] var1, int var2, int var3);

    private native short ECWGetPercentComplete();

    private static native String ECWGetErrorString(int var0);

    private static native int NCSJNIInit();

    private static native String ECWGetLibVersion();

    static void initClass() throws JNCSNativeLibraryException {
        Object object;
        Object object2;
        Object object3;
        String string;
        Object object4;
        int n = 0;
        boolean bl = false;
        if (bHaveClassInit) {
            return;
        }
        if (System.getSecurityManager() != null) {
            object4 = null;
            string = System.getProperty("java.vendor");
            if (string.startsWith("Netscape Communications Corporation")) {
                try {
                    object3 = Class.forName("netscape.security.PrivilegeManager");
                    object2 = new Class[]{class$java$lang$String == null ? (class$java$lang$String = JNCSFile.class$("java.lang.String")) : class$java$lang$String};
                    object4 = ((Class)object3).getMethod("enablePrivilege", (Class<?>)object2);
                    object = ((Class)object3).newInstance();
                    Object[] objectArray = new Object[]{new String("UniversalLinkAccess")};
                    Object[] objectArray2 = new Object[]{new String("UniversalPropertyRead")};
                    ((Method)object4).invoke(object, objectArray);
                    ((Method)object4).invoke(object, objectArray2);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    System.out.println("GetMethod : ".concat(String.valueOf(String.valueOf(noSuchMethodException.getMessage()))));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.out.println("ClassNotFoundException : ".concat(String.valueOf(String.valueOf(classNotFoundException.getMessage()))));
                }
                catch (Exception exception) {
                    System.out.println("Netscape Privilige Manager Access Exception : ".concat(String.valueOf(String.valueOf(exception.getMessage()))));
                }
            } else if (string.startsWith("Microsoft Corp.")) {
                try {
                    object3 = Class.forName("com.ms.security.PolicyEngine");
                    object2 = Class.forName("com.ms.security.PermissionID");
                    object = object2.getField("SYSTEM");
                    Field field = object2.getField("FILEIO");
                    Class[] classArray = new Class[]{object2};
                    object4 = ((Class)object3).getMethod("assertPermission", classArray);
                    Object[] objectArray = new Object[]{((Field)object).get(null)};
                    Object[] objectArray3 = new Object[]{field.get(null)};
                    ((Method)object4).invoke(null, objectArray);
                    ((Method)object4).invoke(null, objectArray3);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    System.out.println("Microsoft Policy Engine NoSuchMethodException : ".concat(String.valueOf(String.valueOf(noSuchMethodException.getMessage()))));
                }
                catch (SecurityException securityException) {
                    System.out.println("Microsoft Policy Engine SecurityException : ".concat(String.valueOf(String.valueOf(securityException.getMessage()))));
                }
                catch (Exception exception) {
                    System.out.println("Microsoft Policy Engine Exception : ".concat(String.valueOf(String.valueOf(exception.getMessage()))));
                }
            }
        } else {
            bl = true;
        }
        try {
            System.loadLibrary("NCSUtil");
            System.loadLibrary("NCScnet");
            System.loadLibrary("NCSEcw");
            bUseNativeMethods = true;
            bUnsatisfiedLink = false;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            bUseNativeMethods = false;
            bUnsatisfiedLink = true;
            bUseNativeMethods = false;
            JNCSFile.debug("Got UnsatisfiedLinkError looking on PATH");
        }
        catch (SecurityException securityException) {
            bSecurityError = true;
            bUseNativeMethods = false;
            bUnsatisfiedLink = false;
            JNCSFile.debug("Got SecurityException looking on PATH");
        }
        catch (Exception exception) {
            System.err.println("Unknown error loading ECW native libraries : ".concat(String.valueOf(String.valueOf(exception.getMessage()))));
            bUseNativeMethods = false;
            JNCSFile.debug("Got Exception looking on PATH");
        }
        if (bUseNativeMethods) {
            try {
                n = JNCSFile.NCSJNIInit();
                if (n == 0) {
                    bHaveClassInit = true;
                    return;
                }
                System.err.println("JNCSFile classes found on PATH failed to initialize correctly. Attempting to locate other NCS dlls....");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                JNCSFile.debug("Native ECW libraries have been found on the PATH, but could not be loaded. This may be because the version is insufficient to support the Java classes.\nAt least version 1,5,2,0 is required. Attempting to locate other NCS dlls....");
            }
            catch (Exception exception) {
                JNCSFile.debug("Unknown exception occured initialising ECW native libraries found on the PATH.".concat(String.valueOf(String.valueOf(exception.getMessage()))));
            }
        }
        if (bl && !bUseNativeMethods && !bSecurityError && System.getSecurityManager() != null) {
            object4 = new Properties();
            string = null;
            object3 = null;
            try {
                object2 = System.getProperty("user.home");
                object3 = System.getProperty("file.separator");
                object = new FileInputStream(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(object2))).append((String)object3).append("jncsclasses.properties"))));
                ((Properties)object4).load((InputStream)object);
                string = ((Properties)object4).getProperty("clientDLLPath");
            }
            catch (Exception exception) {
                string = null;
            }
            try {
                if (string != null) {
                    System.load(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append((String)object3).append("NCSUtil.dll"))));
                    System.load(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append((String)object3).append("NCScnet.dll"))));
                    System.load(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append((String)object3).append("NCSEcw.dll"))));
                    bUseNativeMethods = true;
                    bUnsatisfiedLink = false;
                    bSecurityError = false;
                }
            }
            catch (SecurityException securityException) {
                bSecurityError = true;
                bUseNativeMethods = false;
                bUnsatisfiedLink = false;
                JNCSFile.debug("Got security exception looking on clientDLLPath");
            }
            catch (RuntimeException runtimeException) {
                System.out.println(runtimeException.getMessage());
                bUseNativeMethods = false;
                bUnsatisfiedLink = true;
                JNCSFile.debug("Got RuntimeException looking on clientDLLPath");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                bUseNativeMethods = false;
                bUnsatisfiedLink = true;
                JNCSFile.debug("Got UnsatisfiedLinkError looking on clientDLLPath");
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                bUseNativeMethods = false;
                bUnsatisfiedLink = true;
                JNCSFile.debug("Got Exception looking on clientDLLPath");
            }
        }
        if (!bUseNativeMethods && !bSecurityError) {
            try {
                System.load("C:\\Program Files\\Earth Resource Mapping\\Image Web Server\\Client\\NCSUtil.dll");
                System.load("C:\\Program Files\\Earth Resource Mapping\\Image Web Server\\Client\\NCScnet.dll");
                System.load("C:\\Program Files\\Earth Resource Mapping\\Image Web Server\\Client\\NCSEcw.dll");
                bUseNativeMethods = true;
                bUnsatisfiedLink = false;
                bSecurityError = false;
                JNCSFile.debug("Loaded ECW libraries in C:\\Program Files\\...");
            }
            catch (SecurityException securityException) {
                bSecurityError = true;
                bUseNativeMethods = false;
                bUnsatisfiedLink = false;
                JNCSFile.debug("Got security exception looking on C:\\Program Files\\");
            }
            catch (RuntimeException runtimeException) {
                System.out.println(runtimeException.getMessage());
                bUseNativeMethods = false;
                bUnsatisfiedLink = true;
                JNCSFile.debug("Got RuntimeException looking on C:\\Program Files\\");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                bUseNativeMethods = false;
                bUnsatisfiedLink = true;
                JNCSFile.debug("Got UnsatisfiedLinkError looking on C:\\Program Files\\");
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                bUseNativeMethods = false;
                bUnsatisfiedLink = true;
                JNCSFile.debug("Got Exception looking on C:\\Program Files\\");
            }
        }
        if (bUseNativeMethods) {
            try {
                n = JNCSFile.NCSJNIInit();
                if (n != 0) {
                    System.err.println("JNCSFile classes failed to initialize correctly. Unrecoverable error.");
                    object4 = JNCSFile.ECWGetErrorString(n);
                    throw new JNCSNativeLibraryException((String)object4);
                }
                bHaveClassInit = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                JNCSFile.debug("UnsatisfiedLinkError: ".concat(String.valueOf(String.valueOf(unsatisfiedLinkError.getMessage()))));
                throw new JNCSNativeLibraryException("Native ECW libraries have been found, but could not be loaded. This may be because the version is insufficient to support the Java classes.\nAt least version 1,5,2,0 is required.");
            }
            catch (Exception exception) {
                JNCSFile.debug("Exception: ".concat(String.valueOf(String.valueOf(exception.getMessage()))));
                throw new JNCSNativeLibraryException("Unknown exception occured initialising ECW native libraries.".concat(String.valueOf(String.valueOf(exception.getMessage()))));
            }
        }
        if (bSecurityError) {
            object4 = "The security manager has denied loading of native libraries. Only trusted classes and signed JAR files can access native libraries.";
            System.out.println((String)object4);
            throw new JNCSNativeLibraryException((String)object4);
        }
        if (bUnsatisfiedLink) {
            object4 = "JNCSFile class failed to resolve some or all of the native ECW libraries.\nCheck that the NCSUtil, NCSCnet, and NCSUtil shared libraries are on the PATH environment variable (Win32),\nor the LD_LIBRARY_PATH (Unix), or that the parameters to the virtual machine specify their location,\nby setting the property : -Djava.library.path=<path_to_ncs_libraries>\nAlternatively, the file jncsclasses.properties in the user's home directory can specify the location.\n\nRefer to the ECW Java SDK documentation for more information on native library search paths.";
            throw new JNCSNativeLibraryException((String)object4);
        }
    }

    public JNCSFile() throws JNCSException {
        JNCSFile.initClass();
        this.cellSizeUnits = 0;
        this.bIsOpen = false;
    }

    public JNCSFile(String string, boolean bl) throws JNCSException {
        JNCSFile.initClass();
        this.open(string, bl);
    }

    protected void finalize() throws Throwable {
        if (this.bIsOpen) {
            this.ECWClose(false);
        }
        super.finalize();
    }

    public int open(String string, boolean bl) throws JNCSFileOpenFailedException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        int n = this.ECWOpen(string, bl);
        if (n != 0) {
            this.bIsOpen = false;
            String string2 = JNCSFile.ECWGetErrorString(n);
            throw new JNCSFileOpenFailedException(string2);
        }
        this.bIsOpen = true;
        this.progressive = bl;
        return 0;
    }

    public void close(boolean bl) {
        this.ECWClose(bl);
        if (bl) {
            // empty if block
        }
    }

    public void addProgressiveUpdateListener(JNCSProgressiveUpdate jNCSProgressiveUpdate) {
        this.progImageClient = jNCSProgressiveUpdate;
    }

    public void refreshUpdate(int n, int n2, double d, double d2, double d3, double d4) {
        if (this.progImageClient != null) {
            this.progImageClient.refreshUpdate(n, n2, d, d2, d3, d4);
        }
    }

    public void refreshUpdate(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.progImageClient != null) {
            this.progImageClient.refreshUpdate(n, n2, n3, n4, n5, n6);
        }
    }

    public int setView(int n, int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7) throws JNCSFileNotOpenException, JNCSInvalidSetViewException {
        int n8 = this.ECWSetView(n, nArray, n2, n3, n4, n5, 0.0, 0.0, 0.0, 0.0, n6, n7);
        if (n8 != 0) {
            String string = JNCSFile.ECWGetErrorString(n8);
            throw new JNCSInvalidSetViewException(string);
        }
        this.bSetViewIsWorld = false;
        return 0;
    }

    public int setView(int n, int[] nArray, double d, double d2, double d3, double d4, int n2, int n3) throws JNCSFileNotOpenException, JNCSInvalidSetViewException {
        JNCSDatasetPoint jNCSDatasetPoint = this.convertWorldToDataset(d, d2);
        JNCSDatasetPoint jNCSDatasetPoint2 = this.convertWorldToDataset(d3, d4);
        int n4 = this.ECWSetView(n, nArray, jNCSDatasetPoint.x, jNCSDatasetPoint.y, jNCSDatasetPoint2.x, jNCSDatasetPoint2.y, d, d2, d3, d4, n2, n3);
        if (n4 != 0) {
            String string = JNCSFile.ECWGetErrorString(n4);
            throw new JNCSInvalidSetViewException(string);
        }
        this.bSetViewIsWorld = true;
        return 0;
    }

    public int readLineRGBA(int[] nArray) throws JNCSException {
        int n = this.ECWReadLineRGBA(nArray);
        if (n != 0) {
            String string = JNCSFile.ECWGetErrorString(n);
            throw new JNCSException(string);
        }
        return 0;
    }

    public int readLineBGRA(int[] nArray) throws JNCSException {
        throw new JNCSException("Not Yet Implemented!");
    }

    public int readLineBIL(int[] nArray) throws JNCSException {
        throw new JNCSException("Not Yet Implemented!");
    }

    public int readLineBIL(double[] dArray) throws JNCSException {
        throw new JNCSException("Not Yet Implemented!");
    }

    public int readImageRGBA(int[] nArray, int n, int n2) throws JNCSException {
        int n3 = this.ECWReadImageRGBA(nArray, n, n2);
        if (n3 != 0) {
            String string = JNCSFile.ECWGetErrorString(n3);
            throw new JNCSException(string);
        }
        return 0;
    }

    public String getLastErrorText(int n) {
        return JNCSFile.ECWGetErrorString(n);
    }

    public JNCSDatasetPoint convertWorldToDataset(double d, double d2) throws JNCSFileNotOpenException {
        if (!this.bIsOpen) {
            throw new JNCSFileNotOpenException();
        }
        int n = (int)Math.round((d - this.originX) / this.cellIncrementX);
        int n2 = (int)Math.round((d2 - this.originY) / this.cellIncrementY);
        return new JNCSDatasetPoint(n, n2);
    }

    public JNCSWorldPoint convertDatasetToWorld(int n, int n2) throws JNCSFileNotOpenException {
        if (!this.bIsOpen) {
            throw new JNCSFileNotOpenException();
        }
        double d = this.originX + (double)n * this.cellIncrementX;
        double d2 = this.originY + (double)n2 * this.cellIncrementY;
        return new JNCSWorldPoint(d, d2);
    }

    public short getPercentComplete() {
        return this.ECWGetPercentComplete();
    }

    public static String getLibVersion() {
        return JNCSFile.ECWGetLibVersion();
    }

    private static void debug(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

