/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.image;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.gvt.renderer.ConcreteImageRendererFactory;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.keys.BooleanKey;
import org.apache.batik.transcoder.keys.PaintKey;
import org.w3c.dom.Document;

public abstract class ImageTranscoder
extends SVGAbstractTranscoder {
    public static final TranscodingHints.Key KEY_BACKGROUND_COLOR = new PaintKey();
    public static final TranscodingHints.Key KEY_FORCE_TRANSPARENT_WHITE = new BooleanKey();

    protected ImageTranscoder() {
    }

    protected void transcode(Document document, String string, TranscoderOutput transcoderOutput) throws TranscoderException {
        super.transcode(document, string, transcoderOutput);
        int n = (int)((double)this.width + 0.5);
        int n2 = (int)((double)this.height + 0.5);
        ConcreteImageRendererFactory concreteImageRendererFactory = new ConcreteImageRendererFactory();
        ImageRenderer imageRenderer = concreteImageRendererFactory.createStaticImageRenderer();
        imageRenderer.updateOffScreen(n, n2);
        imageRenderer.setTransform(this.curTxf);
        imageRenderer.setTree(this.root);
        this.root = null;
        try {
            Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height);
            imageRenderer.repaint(this.curTxf.createInverse().createTransformedShape(float_));
            BufferedImage bufferedImage = imageRenderer.getOffScreen();
            imageRenderer = null;
            BufferedImage bufferedImage2 = this.createImage(n, n2);
            Graphics2D graphics2D = GraphicsUtil.createGraphics(bufferedImage2);
            if (this.hints.containsKey(KEY_BACKGROUND_COLOR)) {
                Paint paint = (Paint)this.hints.get(KEY_BACKGROUND_COLOR);
                graphics2D.setComposite(AlphaComposite.SrcOver);
                graphics2D.setPaint(paint);
                graphics2D.fillRect(0, 0, n, n2);
            }
            if (bufferedImage != null) {
                graphics2D.drawRenderedImage(bufferedImage, new AffineTransform());
            }
            graphics2D.dispose();
            bufferedImage = null;
            this.writeImage(bufferedImage2, transcoderOutput);
        }
        catch (Exception exception) {
            throw new TranscoderException(exception);
        }
    }

    protected void forceTransparentWhite(BufferedImage bufferedImage, SinglePixelPackedSampleModel singlePixelPackedSampleModel) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        DataBufferInt dataBufferInt = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
        int n3 = singlePixelPackedSampleModel.getScanlineStride();
        int n4 = dataBufferInt.getOffset();
        int[] nArray = dataBufferInt.getBankData()[0];
        int n5 = n4;
        int n6 = n3 - n;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                n11 = nArray[n5];
                n7 = n11 >> 24 & 0xFF;
                n8 = n11 >> 16 & 0xFF;
                n9 = n11 >> 8 & 0xFF;
                n10 = n11 & 0xFF;
                n8 = (255 * (255 - n7) + n7 * n8) / 255;
                n9 = (255 * (255 - n7) + n7 * n9) / 255;
                n10 = (255 * (255 - n7) + n7 * n10) / 255;
                nArray[n5++] = n7 << 24 & 0xFF000000 | n8 << 16 & 0xFF0000 | n9 << 8 & 0xFF00 | n10 & 0xFF;
            }
            n5 += n6;
        }
    }

    public abstract BufferedImage createImage(int var1, int var2);

    public abstract void writeImage(BufferedImage var1, TranscoderOutput var2) throws TranscoderException;
}

