/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.svg;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.AbstractValueManager;
import org.apache.batik.css.engine.value.URIValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.svg.SVGValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class FilterManager
extends AbstractValueManager {
    public boolean isInheritedProperty() {
        return false;
    }

    public String getPropertyName() {
        return "filter";
    }

    public boolean isAnimatableProperty() {
        return true;
    }

    public boolean isAdditiveProperty() {
        return false;
    }

    public int getPropertyType() {
        return 20;
    }

    public Value getDefaultValue() {
        return SVGValueConstants.NONE_VALUE;
    }

    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 12: {
                return SVGValueConstants.INHERIT_VALUE;
            }
            case 24: {
                return new URIValue(lexicalUnit.getStringValue(), FilterManager.resolveURI(cSSEngine.getCSSBaseURI(), lexicalUnit.getStringValue()));
            }
            case 35: {
                if (lexicalUnit.getStringValue().equalsIgnoreCase("none")) {
                    return SVGValueConstants.NONE_VALUE;
                }
                throw this.createInvalidIdentifierDOMException(lexicalUnit.getStringValue());
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
    }

    public Value createStringValue(short s, String string, CSSEngine cSSEngine) throws DOMException {
        if (s == 21) {
            if (string.equalsIgnoreCase("none")) {
                return SVGValueConstants.NONE_VALUE;
            }
            throw this.createInvalidIdentifierDOMException(string);
        }
        if (s == 20) {
            return new URIValue(string, FilterManager.resolveURI(cSSEngine.getCSSBaseURI(), string));
        }
        throw this.createInvalidStringTypeDOMException(s);
    }
}

