/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.util.metaData;

import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.workbench.model.Layer;
import de.fho.jump.pirol.utilities.debugOutput.DebugUserIds;
import de.fho.jump.pirol.utilities.debugOutput.PersonalLogger;
import java.util.HashMap;
import java.util.Set;
import org.openjump.core.apitools.HandlerToMakeYourLifeEasier;
import org.openjump.core.apitools.objecttyperoles.FeatureCollectionRole;
import org.openjump.core.apitools.objecttyperoles.FeatureCollectionRoleTypes;
import org.openjump.core.apitools.objecttyperoles.PirolFeatureCollection;
import org.openjump.core.apitools.objecttyperoles.RoleStandardFeatureCollection;
import org.openjump.util.metaData.Attribute2UnitMap;
import org.openjump.util.metaData.MetaDataMap;
import org.openjump.util.metaData.ObjectContainingMetaInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaInformationHandler
implements HandlerToMakeYourLifeEasier {
    protected ObjectContainingMetaInformation objectWithMetaInformation = null;
    protected PersonalLogger logger = new PersonalLogger(DebugUserIds.ALL);

    public MetaInformationHandler(Layer layerWithMetaInformation) {
        FeatureCollection fc;
        if (layerWithMetaInformation != null) {
            fc = layerWithMetaInformation.getFeatureCollectionWrapper().getUltimateWrappee();
            if (!PirolFeatureCollection.class.isInstance(fc)) {
                fc = MetaInformationHandler.createPirolFeatureCollection(fc);
                layerWithMetaInformation.setFeatureCollection(fc);
            }
        } else {
            throw new RuntimeException("given layer is null.");
        }
        this.objectWithMetaInformation = (PirolFeatureCollection)fc;
    }

    public MetaInformationHandler(ObjectContainingMetaInformation objectWithMetaInformation) {
        if (objectWithMetaInformation == null) {
            throw new RuntimeException("given layer is null.");
        }
        this.objectWithMetaInformation = objectWithMetaInformation;
    }

    public static final PirolFeatureCollection createPirolFeatureCollection(FeatureCollection fc) {
        return MetaInformationHandler.createPirolFeatureCollection(fc, new RoleStandardFeatureCollection());
    }

    public static final PirolFeatureCollection createPirolFeatureCollection(FeatureCollection fc, FeatureCollectionRole role) {
        PirolFeatureCollection pfc = null;
        if (!PirolFeatureCollection.class.isInstance(fc)) {
            pfc = new PirolFeatureCollection(fc, role);
        } else {
            pfc = (PirolFeatureCollection)fc;
            if (!role.equalsRole(FeatureCollectionRoleTypes.STANDARD)) {
                pfc.addRole(role);
            }
        }
        return pfc;
    }

    public MetaDataMap getExistentMetaInformationMap() {
        if (this.containsMetaInformation()) {
            return this.getMetaInformationMap();
        }
        return null;
    }

    public MetaDataMap getMetaInformationMap() {
        if (!this.containsMetaInformation()) {
            MetaDataMap newMap = new MetaDataMap();
            if (this.objectWithMetaInformation == null) {
                return null;
            }
            this.logger.printDebug("creating new meta map for " + this.objectWithMetaInformation);
            this.objectWithMetaInformation.setMetaInformation(newMap);
            return newMap;
        }
        if (this.objectWithMetaInformation != null) {
            return this.objectWithMetaInformation.getMetaInformation();
        }
        return null;
    }

    public boolean containsMetaInformation() {
        return this.objectWithMetaInformation != null && this.objectWithMetaInformation.getMetaInformation() != null;
    }

    public void addMetaInformation(String key, Object value) {
        MetaDataMap metaMap = this.getMetaInformationMap();
        if (metaMap.containsKey(key)) {
            metaMap.remove(key);
        }
        metaMap.addMetaInformation(key, value);
    }

    public HashMap getMetaData() {
        MetaDataMap metaMap = this.getMetaInformationMap();
        return metaMap.getMetaData();
    }

    public void setMetaData(HashMap<Object, Object> metaData) {
        MetaDataMap metaMap = this.getMetaInformationMap();
        metaMap.setMetaData(metaData);
    }

    public void clear() {
        MetaDataMap metaMap = this.getMetaInformationMap();
        metaMap.clear();
    }

    public boolean containsKey(String key) {
        MetaDataMap metaMap = this.getMetaInformationMap();
        return metaMap.containsKey(key);
    }

    public Object getMetaInformation(String key) {
        MetaDataMap metaMap = this.getMetaInformationMap();
        return metaMap.get(key);
    }

    public boolean containsValue(Object value) {
        MetaDataMap metaMap = this.getMetaInformationMap();
        return metaMap.containsValue(value);
    }

    public Set keySet() {
        MetaDataMap metaMap = this.getMetaInformationMap();
        return metaMap.keySet();
    }

    public Object remove(String key) {
        MetaDataMap metaMap = this.getMetaInformationMap();
        return metaMap.remove(key);
    }

    public Attribute2UnitMap getAttribute2UnitMap() {
        if (this.containsAttribute2UnitMap()) {
            return (Attribute2UnitMap)this.getMetaInformation("attribute2unit");
        }
        return null;
    }

    public void putAttribute2UnitMap(Attribute2UnitMap attribute2UnitMap) {
        this.addMetaInformation("attribute2unit", attribute2UnitMap);
    }

    public boolean containsAttribute2UnitMap() {
        return this.containsKey("attribute2unit");
    }
}

