/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.util;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.HTMLFrame;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import java.util.ArrayList;
import java.util.Arrays;

public class ExceptionUtil {
    public static void reportExceptions(ArrayList exceptions, DataSourceQuery dataSourceQuery, WorkbenchFrame workbenchFrame, HTMLFrame outputFrame) {
        outputFrame.addHeader(1, exceptions.size() + " " + I18N.get("datasource.LoadDatasetPlugIn.problem") + StringUtil.s(exceptions.size()) + " " + I18N.get("datasource.LoadDatasetPlugIn.loading") + " " + dataSourceQuery.toString() + "." + (exceptions.size() > 10 ? I18N.get("datasource.LoadDatasetPlugIn.first-and-last-five") : ""));
        outputFrame.addText(I18N.get("datasource.LoadDatasetPlugIn.see-view-log"));
        outputFrame.append("<ul>");
        ArrayList exceptionsToReport = exceptions.size() <= 10 ? exceptions : CollectionUtil.concatenate(Arrays.asList(exceptions.subList(0, 5), exceptions.subList(exceptions.size() - 5, exceptions.size())));
        for (Exception exception : exceptionsToReport) {
            workbenchFrame.log(StringUtil.stackTrace(exception));
            outputFrame.append("<li>");
            outputFrame.append(GUIUtil.escapeHTML(WorkbenchFrame.toMessage(exception), true, true));
            outputFrame.append("</li>");
            exception.printStackTrace();
        }
        outputFrame.append("</ul>");
    }
}

