/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.view;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.Viewport;
import java.awt.geom.NoninvertibleTransformException;
import javax.swing.JInternalFrame;

public class InstallKeyPanPlugIn
extends AbstractPlugIn {
    private static final int NORTH = 0;
    private static final int EAST = 1;
    private static final int SOUTH = 2;
    private static final int WEST = 3;
    private static final int ZOOM_IN = 4;
    private static final int ZOOM_OUT = 5;
    private static final int[][] DIRECTIONS = new int[][]{{0, -1, 0, -1}, {-1, 0, -1, 0}, {0, 1, 0, 1}, {1, 0, 1, 0}, {1, 1, -1, -1}, {-1, -1, 1, 1}};
    private static double panPercentage;

    public InstallKeyPanPlugIn() {
        this(0.2);
    }

    public InstallKeyPanPlugIn(double panPercentag) {
        InstallKeyPanPlugIn.setPanPercentage(panPercentag);
    }

    public boolean execute(PlugInContext context) throws Exception {
        context.getLayerViewPanel().getViewport().zoomToFullExtent();
        return true;
    }

    private static Envelope createEnvelopeFromDirection(Envelope oldEnvelope, int direction) {
        double oldWidth = panPercentage * oldEnvelope.getWidth();
        double oldHeight = panPercentage * oldEnvelope.getHeight();
        double dxPlus = (double)DIRECTIONS[direction][0] * oldWidth;
        double dyPlus = (double)DIRECTIONS[direction][1] * oldHeight;
        double dxMinus = (double)DIRECTIONS[direction][2] * oldWidth;
        double dyMinus = (double)DIRECTIONS[direction][3] * oldHeight;
        return new Envelope(oldEnvelope.getMinX() - dxMinus, oldEnvelope.getMaxX() - dxPlus, oldEnvelope.getMinY() - dyMinus, oldEnvelope.getMaxY() - dyPlus);
    }

    public boolean pan(JInternalFrame jif, int direction) {
        if (jif instanceof TaskFrame) {
            TaskFrame taskFrame = (TaskFrame)jif;
            LayerViewPanel lvp = taskFrame.getLayerViewPanel();
            Viewport vp = lvp.getViewport();
            Envelope oldEnvelope = vp.getEnvelopeInModelCoordinates();
            try {
                vp.zoom(InstallKeyPanPlugIn.createEnvelopeFromDirection(oldEnvelope, direction));
            }
            catch (NoninvertibleTransformException e1) {
                e1.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        AbstractPlugIn[] plugIns = new AbstractPlugIn[]{this, new PanHelper(0), new PanHelper(1), new PanHelper(2), new PanHelper(3), new PanHelper(4), new PanHelper(5)};
        int[] keys = new int[]{36, 38, 39, 40, 37, 34, 33};
        for (int i = 0; i < keys.length; ++i) {
            context.getWorkbenchContext().getWorkbench().getFrame().addKeyboardShortcut(keys[i], 0, plugIns[i], null);
        }
    }

    public String getName() {
        return "";
    }

    public static double getPanPercentage() {
        return 2.0 * panPercentage;
    }

    public static void setPanPercentage(double panPercent) {
        if (panPercent <= 0.0 || panPercent > 1.0) {
            throw new IllegalArgumentException("Accepted values are in the  range 0 < percentage <= 1");
        }
        panPercentage = panPercent / 2.0;
    }

    private class PanHelper
    extends AbstractPlugIn {
        private final int direction;

        public PanHelper(int direction) {
            this.direction = direction;
        }

        public boolean execute(PlugInContext context) throws Exception {
            return InstallKeyPanPlugIn.this.pan(context.getWorkbenchFrame().getActiveInternalFrame(), this.direction);
        }
    }
}

