/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools.statistics;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import org.openjump.core.apitools.FeatureSchemaTools;
import org.openjump.core.attributeoperations.Classifier1D;
import org.openjump.core.ui.plot.Plot2DPanelOJ;

public class ClassifyAttributesPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private static String pluginname = "classifyplot";
    private MultiInputDialog dialog;
    private String sideBarText = "Classifies attribute data with the chosen method.\nThe result is added as new field to the attribute table.";
    private String CLASSIFIER = "select classification method";
    private String T2 = "number of classes";
    private String CLAYER = "select layer";
    private String ATTRIBUTE = "select attribute";
    private String OPTIMIZEWITHKMEANS = "optimize with k-means";
    private String PROCESSNULLASZERO = "process null as zero";
    private String sClassbreaks = "class breaks";
    private String sDatapoints = "data points";
    private String sCount = "count";
    private String sHistogram = "Histogram";
    private String sCalculateBreaks = "Calculate breaks";
    private String sDisplayBreaks = "Display Breaks";
    private String sClassifying = "classifying";
    private String sAddingField = "adding field";
    private Layer selLayer = null;
    private int ranges = 7;
    private FeatureCollection fc = null;
    private String selAttribute = null;
    private String selClassifier = null;
    private Boolean useKmeans = false;
    private boolean nullAsZero = false;
    public LayerManager currentLM = null;
    private String sName = "Classify Attributes";
    private String sWarning = "problems appeared";
    private String sNotEnoughValuesWarning = "valid values is not enough";
    private String sWrongDataType = "Wrong datatype of chosen attribute";
    private String sNoAttributeChoosen = "No attribute choosen";

    public void initialize(PlugInContext context) throws Exception {
        this.sideBarText = I18N.get("org.openjump.core.ui.plugin.tools.statistics.ClassifyAttributesPlugin.descriptiontext");
        this.CLASSIFIER = I18N.get("org.openjump.core.ui.plugin.tools.statistics.ClassifyAttributesPlugin.Select-classification-method");
        this.T2 = I18N.get("org.openjump.core.ui.plugin.tools.statistics.ClassifyAttributesPlugin.Number-of-classes");
        this.CLAYER = GenericNames.SELECT_LAYER;
        this.ATTRIBUTE = GenericNames.SELECT_ATTRIBUTE;
        this.OPTIMIZEWITHKMEANS = I18N.get("org.openjump.core.ui.plugin.tools.statistics.ClassifyAttributesPlugin.Optimize-with-k-means");
        this.PROCESSNULLASZERO = I18N.get("org.openjump.core.ui.plugin.tools.statistics.ClassifyAttributesPlugin.Process-null-as-zero");
        this.sClassbreaks = I18N.get("org.openjump.core.ui.plugin.tools.statistics.ClassifyAttributesPlugin.class-breaks");
        this.sDatapoints = I18N.get("org.openjump.core.ui.plugin.tools.statistics.ClassifyAttributesPlugin.data-points");
        this.sCount = I18N.get("org.openjump.core.ui.plugin.tools.statistics.CreateHistogramPlugIn.count");
        this.sHistogram = I18N.get("org.openjump.core.ui.plugin.tools.statistics.CreateHistogramPlugIn.Histogram-Plot");
        this.sCalculateBreaks = I18N.get("org.openjump.core.ui.plugin.tools.statistics.ClassifyAttributesPlugin.Calculating-Breaks");
        this.sDisplayBreaks = I18N.get("org.openjump.core.ui.plugin.tools.statistics.ClassifyAttributesPlugin.Displaying-Breaks");
        this.sClassifying = I18N.get("org.openjump.core.ui.plugin.tools.statistics.ClassifyAttributesPlugin.classifying");
        this.sAddingField = I18N.get("org.openjump.core.ui.plugin.tools.statistics.ClassifyAttributesPlugin.create-output-field");
        this.sName = I18N.get("org.openjump.core.ui.plugin.tools.statistics.ClassifyAttributesPlugin.Classify-Attribute");
        this.sWarning = I18N.get("org.openjump.core.ui.plugin.tools.statistics.ClassifyAttributesPlugin.Error-during-classification");
        this.sNotEnoughValuesWarning = I18N.get("org.openjump.core.ui.plugin.tools.statistics.ClassifyAttributesPlugin.Not-enough-values");
        this.sWrongDataType = I18N.get("org.openjump.core.ui.plugin.tools.statistics.CreateBarPlotPlugIn.Wrong-datatype-of-chosen-attribute");
        this.sNoAttributeChoosen = I18N.get("org.openjump.core.ui.plugin.tools.statistics.ClassifyAttributesPlugin.No-attribute-choosen");
        FeatureInstaller featureInstaller = new FeatureInstaller(context.getWorkbenchContext());
        featureInstaller.addMainMenuItem(this, new String[]{MenuNames.TOOLS, MenuNames.STATISTICS}, this.sName + "...", false, null, ClassifyAttributesPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustExistCheck(1)).add(checkFactory.createTaskWindowMustBeActiveCheck());
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.sName, true);
        this.setDialogValues(this.dialog, context);
        GUIUtil.centreOnWindow(this.dialog);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        this.currentLM = context.getLayerManager();
        monitor.allowCancellationRequests();
        if (this.selAttribute == null) {
            context.getWorkbenchFrame().warnUser(I18N.get(this.sNoAttributeChoosen));
            return;
        }
        FeatureDataset result = this.classifyAndCreatePlot(monitor, context);
        if (result == null) {
            context.getWorkbenchFrame().warnUser(I18N.get(this.sNotEnoughValuesWarning));
        } else if (result.size() > 0) {
            String name = this.selAttribute + "_" + this.selClassifier;
            this.currentLM.addLayer(StandardCategoryNames.WORKING, name, result);
        } else {
            context.getWorkbenchFrame().warnUser(this.sWarning);
        }
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(this.sideBarText);
        dialog.addLayerComboBox(this.CLAYER, context.getCandidateLayer(0), context.getLayerManager());
        List listNumAttributes = FeatureSchemaTools.getFieldsFromLayerWithoutGeometryAndString(context.getCandidateLayer(0));
        Object valAttribute = listNumAttributes.size() > 0 ? listNumAttributes.iterator().next() : null;
        final JComboBox jcb_attribute = dialog.addComboBox(this.ATTRIBUTE, valAttribute, listNumAttributes, this.ATTRIBUTE);
        if (listNumAttributes.size() == 0) {
            jcb_attribute.setEnabled(false);
        }
        List listClassifiers = Classifier1D.getAvailableClassificationMethods();
        Object valClassifier = listNumAttributes.size() > 0 ? listNumAttributes.iterator().next() : null;
        JComboBox jcb_classifier = dialog.addComboBox(this.CLASSIFIER, valClassifier, listClassifiers, this.CLASSIFIER);
        dialog.addIntegerField(this.T2, this.ranges, 6, this.T2);
        dialog.addCheckBox(this.OPTIMIZEWITHKMEANS, false);
        dialog.addCheckBox(this.PROCESSNULLASZERO, false);
        dialog.getComboBox(this.CLAYER).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                List list = ClassifyAttributesPlugIn.this.getFieldsFromLayerWithoutGeometryAndString();
                if (list.size() == 0) {
                    jcb_attribute.setModel(new DefaultComboBoxModel<String>(new String[0]));
                    jcb_attribute.setEnabled(false);
                } else {
                    jcb_attribute.setModel(new DefaultComboBoxModel<String>(list.toArray(new String[0])));
                    jcb_attribute.setEnabled(true);
                }
            }
        });
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.ranges = dialog.getInteger(this.T2);
        this.selLayer = dialog.getLayer(this.CLAYER);
        this.fc = this.selLayer.getFeatureCollectionWrapper();
        this.selAttribute = dialog.getText(this.ATTRIBUTE);
        this.selClassifier = dialog.getText(this.CLASSIFIER);
        this.useKmeans = dialog.getBoolean(this.OPTIMIZEWITHKMEANS);
        this.nullAsZero = dialog.getBoolean(this.PROCESSNULLASZERO);
    }

    private FeatureDataset classifyAndCreatePlot(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.report(this.sCalculateBreaks);
        FeatureSchema fs = this.fc.getFeatureSchema();
        AttributeType type = null;
        if (fs.getAttributeType(this.selAttribute) != AttributeType.DOUBLE && fs.getAttributeType(this.selAttribute) != AttributeType.INTEGER) {
            context.getWorkbenchFrame().warnUser(this.sWrongDataType);
            return null;
        }
        type = fs.getAttributeType(this.selAttribute);
        int size = this.getFeatureCollectionSize(this.fc, this.selAttribute, this.nullAsZero);
        if (size < 3) {
            return null;
        }
        this.ranges = Math.min(this.ranges, size);
        double[] data = new double[size];
        double[][] plotdata = new double[2][size];
        int[] fID = new int[size];
        int i = 0;
        Iterator iter = this.fc.iterator();
        while (iter.hasNext()) {
            Feature f = (Feature)iter.next();
            if (f.getAttribute(this.selAttribute) == null && !this.nullAsZero) continue;
            fID[i] = f.getID();
            plotdata[1][i] = 1.0;
            Object val = f.getAttribute(this.selAttribute);
            if (type == AttributeType.DOUBLE) {
                data[i] = val == null ? 0.0 : (Double)val;
            } else if (type == AttributeType.INTEGER) {
                data[i] = val == null ? 0.0 : (double)((Integer)val).intValue();
            }
            plotdata[0][i] = data[i];
            ++i;
        }
        if (monitor.isCancelRequested()) {
            return null;
        }
        double[] limits = null;
        if (!this.useKmeans.booleanValue()) {
            if (this.selClassifier == Classifier1D.EQUAL_NUMBER) {
                limits = Classifier1D.classifyEqualNumber(data, this.ranges);
            } else if (this.selClassifier == Classifier1D.EQUAL_RANGE) {
                limits = Classifier1D.classifyEqualRange(data, this.ranges);
            } else if (this.selClassifier == Classifier1D.MEAN_STDEV) {
                limits = Classifier1D.classifyMeanStandardDeviation(data, this.ranges);
            } else if (this.selClassifier == Classifier1D.MAX_BREAKS) {
                limits = Classifier1D.classifyMaxBreaks(data, this.ranges);
            } else if (this.selClassifier == Classifier1D.JENKS_BREAKS) {
                limits = Classifier1D.classifyNaturalBreaks(data, this.ranges);
            }
        } else if (this.selClassifier == Classifier1D.EQUAL_NUMBER) {
            limits = Classifier1D.classifyKMeansOnExistingBreaks(data, this.ranges, 3);
        } else if (this.selClassifier == Classifier1D.EQUAL_RANGE) {
            limits = Classifier1D.classifyKMeansOnExistingBreaks(data, this.ranges, 2);
        } else if (this.selClassifier == Classifier1D.MEAN_STDEV) {
            limits = Classifier1D.classifyKMeansOnExistingBreaks(data, this.ranges, 4);
        } else if (this.selClassifier == Classifier1D.MAX_BREAKS) {
            limits = Classifier1D.classifyKMeansOnExistingBreaks(data, this.ranges, 1);
        } else if (this.selClassifier == Classifier1D.JENKS_BREAKS) {
            limits = Classifier1D.classifyKMeansOnExistingBreaks(data, this.ranges, 5);
        }
        if (monitor.isCancelRequested()) {
            return null;
        }
        monitor.report(this.sDisplayBreaks);
        double[][] limits2show = new double[2][limits.length];
        if (limits.length == 2) {
            limits2show = new double[2][limits.length * 2];
        }
        for (int j = 0; j < limits.length; ++j) {
            limits2show[0][j] = limits[j];
            limits2show[1][j] = Math.floor((double)i / (4.0 * (double)this.ranges));
            if (limits.length != 2) continue;
            limits2show[0][limits.length + j] = limits[j];
            limits2show[1][limits.length + j] = Math.floor((double)i / (4.0 * (double)this.ranges));
        }
        Plot2DPanelOJ plot = new Plot2DPanelOJ();
        plot.addHistogramPlotOJ(this.selAttribute, data, this.ranges * 3, context, this.selLayer, this.selAttribute);
        plot.addScatterPlotOJ(this.sDatapoints, plotdata, fID, context, this.selLayer);
        plot.addBarPlot(this.sClassbreaks, limits2show);
        plot.plotToolBar.setVisible(true);
        plot.setAxisLabel(0, this.selAttribute);
        plot.setAxisLabel(1, this.sCount);
        plot.addLegend("SOUTH");
        JInternalFrame frame = new JInternalFrame(this.sHistogram);
        frame.setLayout(new BorderLayout());
        frame.add((Component)((Object)plot), "Center");
        frame.setClosable(true);
        frame.setResizable(true);
        frame.setMaximizable(true);
        frame.setSize(450, 450);
        frame.setVisible(true);
        context.getWorkbenchFrame().addInternalFrame(frame);
        if (monitor.isCancelRequested()) {
            return null;
        }
        monitor.report(this.sClassifying);
        int[] classes = Classifier1D.classifyData(data, limits);
        if (monitor.isCancelRequested()) {
            return null;
        }
        monitor.report(this.sAddingField);
        FeatureDataset fd = null;
        ArrayList<Feature> outData = new ArrayList<Feature>();
        FeatureSchema targetFSnew = null;
        int count = 0;
        Iterator iterp = this.fc.iterator();
        String attname = this.selAttribute + "_" + this.selClassifier;
        while (iterp.hasNext()) {
            FeatureSchema targetFs;
            Feature p = (Feature)iterp.next();
            Object val = p.getAttribute(this.selAttribute);
            if (val == null && !this.nullAsZero) continue;
            if (++count == 1 && !(targetFSnew = FeatureSchemaTools.copyFeatureSchema(targetFs = p.getSchema())).hasAttribute(attname)) {
                targetFSnew.addAttribute(attname, AttributeType.INTEGER);
            }
            Feature fcopy = FeatureSchemaTools.copyFeature(p, targetFSnew);
            fcopy.setAttribute(attname, (Object)new Integer(classes[count - 1]));
            outData.add(fcopy);
        }
        fd = new FeatureDataset(targetFSnew);
        fd.addAll(outData);
        return fd;
    }

    private int getFeatureCollectionSize(FeatureCollection fc, String attribute, boolean nullAsZero) {
        int size = 0;
        Iterator it = fc.iterator();
        while (it.hasNext()) {
            Feature f = (Feature)it.next();
            if (!nullAsZero && f.getAttribute(attribute) == null) continue;
            ++size;
        }
        return size;
    }

    private List getFieldsFromLayerWithoutGeometryAndString() {
        return FeatureSchemaTools.getFieldsFromLayerWithoutGeometryAndString(this.dialog.getLayer(this.CLAYER));
    }
}

