/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.plugin.util.LayerNameGenerator;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import com.vividsolutions.jump.workbench.ui.plugin.analysis.GeometryFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JComponent;
import org.openjump.core.geomutils.GeoUtils;

public class SplitPolygonPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private static String UPDATE_SRC = I18N.get("org.openjump.core.ui.plugin.tools.SplitPolygonPlugIn.Update-the-polygon-with-result");
    private static String ADD_TO_SRC = I18N.get("org.openjump.core.ui.plugin.tools.SplitPolygonPlugIn.Add-result-to-the-polygon-layer");
    private static String CREATE_LYR = I18N.get("org.openjump.core.ui.plugin.tools.SplitPolygonPlugIn.Create-new-layer-for-result");
    private static String sCutPolygon = I18N.get("org.openjump.core.ui.plugin.tools.SplitPolygonPlugIn.Cut-Polygon");
    private static String sError = I18N.get("org.openjump.core.ui.plugin.tools.SplitPolygonPlugIn.Errors-found-while-executing-Cut-Polygon");
    private static String sExecuting = I18N.get("org.openjump.core.ui.plugin.tools.SplitPolygonPlugIn.Executing-Difference-function");
    private static String sMustSelect = I18N.get("org.openjump.core.ui.plugin.tools.SplitPolygonPlugIn.Must-select-one-polygon-and-one-linestring");
    private static String sDescription = I18N.get("org.openjump.core.ui.plugin.tools.SplitPolygonPlugIn.Uses-the-selected-linestring-to-cut-the-selected-polygon-into-separate-sections");
    private MultiInputDialog dialog;
    private Layer srcLayer;
    private GeometryFunction differenceFunction = GeometryFunction.getFunction("Difference (Source-Mask)");
    private GeometryFunction intersectionFunction = GeometryFunction.getFunction("Intersection");
    private boolean createLayer = true;
    private boolean updateSource = false;
    private boolean addToSource = false;

    public void initialize(PlugInContext context) throws Exception {
        UPDATE_SRC = I18N.get("org.openjump.core.ui.plugin.tools.SplitPolygonPlugIn.Update-the-polygon-with-result");
        ADD_TO_SRC = I18N.get("org.openjump.core.ui.plugin.tools.SplitPolygonPlugIn.Add-result-to-the-polygon-layer");
        CREATE_LYR = I18N.get("org.openjump.core.ui.plugin.tools.SplitPolygonPlugIn.Create-new-layer-for-result");
        sCutPolygon = I18N.get("org.openjump.core.ui.plugin.tools.SplitPolygonPlugIn.Cut-Polygon");
        sError = I18N.get("org.openjump.core.ui.plugin.tools.SplitPolygonPlugIn.Errors-found-while-executing-Cut-Polygon");
        sExecuting = I18N.get("org.openjump.core.ui.plugin.tools.SplitPolygonPlugIn.Executing-Difference-function");
        sMustSelect = I18N.get("org.openjump.core.ui.plugin.tools.SplitPolygonPlugIn.Must-select-one-polygon-and-one-linestring");
        sDescription = I18N.get("org.openjump.core.ui.plugin.tools.SplitPolygonPlugIn.Uses-the-selected-linestring-to-cut-the-selected-polygon-into-separate-sections");
        this.differenceFunction = GeometryFunction.getFunction(I18N.get("ui.plugin.analysis.GeometryFunction.difference-a-b"));
        this.intersectionFunction = GeometryFunction.getFunction(I18N.get("ui.plugin.analysis.GeometryFunction.intersection"));
        WorkbenchContext workbenchContext = context.getWorkbenchContext();
        context.getFeatureInstaller().addMainMenuItem(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_GEOMETRY}, this.getName() + "...", false, null, this.createEnableCheck(workbenchContext));
    }

    public String getName() {
        return sCutPolygon;
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(this.dialog, context);
        GUIUtil.centreOnWindow(this.dialog);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        Collection selectedFeatures = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
        Iterator i = selectedFeatures.iterator();
        Feature featureOne = (Feature)i.next();
        Feature featureTwo = (Feature)i.next();
        Feature polyFeature = featureOne;
        Geometry linestring = featureTwo.getGeometry();
        if (linestring instanceof Polygon) {
            polyFeature = featureTwo;
            linestring = featureOne.getGeometry();
        }
        double bufferWidth = 0.01;
        Geometry buffer = linestring.buffer(0.01);
        for (Layer layer : context.getWorkbenchContext().getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems()) {
            Iterator ftr = layer.getFeatureCollectionWrapper().getFeatures().iterator();
            while (ftr.hasNext()) {
                if (polyFeature != ftr.next()) continue;
                this.srcLayer = layer;
                break;
            }
            if (this.srcLayer != layer) continue;
            break;
        }
        monitor.report(sExecuting + "...");
        ArrayList<Feature> resultFeatures = new ArrayList<Feature>();
        Geometry result = null;
        Geometry intersection = null;
        try {
            Geometry[] geoms = new Geometry[]{polyFeature.getGeometry(), buffer};
            result = this.differenceFunction.execute(geoms, new double[2]);
            geoms[1] = linestring;
            intersection = this.intersectionFunction.execute(geoms, new double[2]);
        }
        catch (RuntimeException ex) {
            context.getWorkbenchFrame().warnUser(sError);
        }
        final Coordinate[] intersectionPts = intersection.getCoordinates();
        if (result == null || result.isEmpty()) {
            return;
        }
        final int lsNumPts = linestring.getNumPoints();
        final Coordinate[] lsCoords = linestring.getCoordinates();
        for (int j = 0; j < result.getNumGeometries(); ++j) {
            Feature fNew = polyFeature.clone(true);
            Geometry geo = (Geometry)result.getGeometryN(j).clone();
            geo.apply(new CoordinateFilter(){

                public void filter(Coordinate coordinate) {
                    for (int n = 0; n < lsNumPts - 1; ++n) {
                        Coordinate p0 = lsCoords[n];
                        Coordinate p1 = lsCoords[n + 1];
                        double distToLine = GeoUtils.getDistance(coordinate, p0, p1);
                        if (!(Math.abs(distToLine - 0.01) < 0.001)) continue;
                        Coordinate snapPt = SplitPolygonPlugIn.this.getNearestSnapPoint(coordinate, intersectionPts);
                        coordinate.x = snapPt.x;
                        coordinate.y = snapPt.y;
                    }
                }
            });
            fNew.setGeometry(geo);
            resultFeatures.add(fNew);
        }
        if (this.createLayer) {
            String outputLayerName = LayerNameGenerator.generateOperationOnLayerName(sCutPolygon, this.srcLayer.getName());
            FeatureDataset resultFC = new FeatureDataset(this.srcLayer.getFeatureCollectionWrapper().getFeatureSchema());
            resultFC.addAll(resultFeatures);
            String categoryName = StandardCategoryNames.RESULT;
            context.getLayerManager().addCategory(categoryName);
            Layer newLayer = context.addLayer(categoryName, outputLayerName, resultFC);
            newLayer.setFeatureCollectionModified(true);
        } else if (this.updateSource) {
            final ArrayList<Feature> undoableNewFeatures = resultFeatures;
            final Feature undoablePolyFeatures = polyFeature;
            UndoableCommand cmd = new UndoableCommand(this.getName()){

                public void execute() {
                    SplitPolygonPlugIn.this.srcLayer.getFeatureCollectionWrapper().remove(undoablePolyFeatures);
                    SplitPolygonPlugIn.this.srcLayer.getFeatureCollectionWrapper().addAll(undoableNewFeatures);
                }

                public void unexecute() {
                    SplitPolygonPlugIn.this.srcLayer.getFeatureCollectionWrapper().removeAll(undoableNewFeatures);
                    SplitPolygonPlugIn.this.srcLayer.getFeatureCollectionWrapper().add(undoablePolyFeatures);
                }
            };
            this.execute(cmd, context);
        } else if (this.addToSource) {
            final ArrayList<Feature> undoableFeatures = resultFeatures;
            UndoableCommand cmd = new UndoableCommand(this.getName()){

                public void execute() {
                    SplitPolygonPlugIn.this.srcLayer.getFeatureCollectionWrapper().addAll(undoableFeatures);
                }

                public void unexecute() {
                    SplitPolygonPlugIn.this.srcLayer.getFeatureCollectionWrapper().removeAll(undoableFeatures);
                }
            };
            this.execute(cmd, context);
        }
    }

    private Coordinate getNearestSnapPoint(Coordinate coord, Coordinate[] intersectionPts) {
        Coordinate closestPt = (Coordinate)intersectionPts[0].clone();
        double shortestDist = coord.distance(intersectionPts[0]);
        for (int i = 1; i < intersectionPts.length; ++i) {
            if (!(coord.distance(intersectionPts[i]) < shortestDist)) continue;
            closestPt = (Coordinate)intersectionPts[i].clone();
            shortestDist = coord.distance(intersectionPts[i]);
        }
        return closestPt;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(sDescription);
        String OUTPUT_GROUP = "Match Type";
        dialog.addRadioButton(CREATE_LYR, "Match Type", this.createLayer, CREATE_LYR);
        dialog.addRadioButton(UPDATE_SRC, "Match Type", this.updateSource, UPDATE_SRC);
        dialog.addRadioButton(ADD_TO_SRC, "Match Type", this.addToSource, ADD_TO_SRC);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.createLayer = dialog.getBoolean(CREATE_LYR);
        this.updateSource = dialog.getBoolean(UPDATE_SRC);
        this.addToSource = dialog.getBoolean(ADD_TO_SRC);
    }

    public EnableCheck onlyPolyAndLinestringMayBeSelected(final WorkbenchContext workbenchContext) {
        return new EnableCheck(){

            public String check(JComponent component) {
                Collection selectedItems = ((SelectionManagerProxy)((Object)workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getSelectedItems();
                int polyCount = 0;
                int lsCount = 0;
                for (Geometry geo : selectedItems) {
                    if (geo instanceof Polygon) {
                        ++polyCount;
                    }
                    if (!(geo instanceof LineString)) continue;
                    ++lsCount;
                }
                if (polyCount == 1 && lsCount == 1) {
                    return null;
                }
                return sMustSelect;
            }
        };
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createExactlyNFeaturesMustBeSelectedCheck(2)).add(this.onlyPolyAndLinestringMayBeSelected(workbenchContext));
    }
}

