/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.DefaultCoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.openjump.core.geomutils.GeoUtils;

public class ReducePointsISAPlugIn
extends AbstractPlugIn {
    private static final String sSimplifyISA = I18N.get("org.openjump.core.ui.plugin.tools.ReducePointsISAPlugIn.Simplify-ISA-algorithm");
    private static final String sPointsReducedFrom = I18N.get("org.openjump.core.ui.plugin.tools.ReducePointsISAPlugIn.Points-reduced-from");
    private static final String sTo = I18N.get("org.openjump.core.ui.plugin.tools.ReducePointsISAPlugIn.to");
    private static final String sReducePointsInSelectedFeatures = I18N.get("org.openjump.core.ui.plugin.tools.ReducePointsISAPlugIn.Reduce-points-in-selected-features");
    private static final String sTheReducePointsTolerance = I18N.get("org.openjump.core.ui.plugin.tools.ReducePointsISAPlugIn.The-reduce-points-tolerance");
    private WorkbenchContext workbenchContext;
    private static final String TOLERANCE = I18N.get("org.openjump.core.ui.plugin.tools.ReducePointsISAPlugIn.Tolerance");
    private double tolerance = 0.1;
    PlugInContext gContext;

    public void initialize(PlugInContext context) throws Exception {
        this.workbenchContext = context.getWorkbenchContext();
        context.getFeatureInstaller().addMainMenuItemWithJava14Fix(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_GENERALIZATION}, sSimplifyISA, false, null, this.createEnableCheck(this.workbenchContext));
    }

    public boolean execute(PlugInContext context) throws Exception {
        ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
        this.reportNothingToUndoYet(context);
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        Collection layers = context.getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
        Collection selectedFeatures = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
        int startNumPts = 0;
        Iterator i = selectedFeatures.iterator();
        while (i.hasNext()) {
            Geometry geo = ((Feature)i.next()).getGeometry();
            startNumPts += geo.getNumPoints();
        }
        Geometry geo = ((Feature)selectedFeatures.iterator().next()).getGeometry();
        for (Layer layer : layers) {
            transactions.add(this.createTransaction(layer, this.tolerance));
        }
        EditTransaction.commit(transactions);
        selectedFeatures = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
        int endNumPts = 0;
        Iterator i2 = selectedFeatures.iterator();
        while (i2.hasNext()) {
            geo = ((Feature)i2.next()).getGeometry();
            endNumPts += geo.getNumPoints();
        }
        context.getWorkbenchFrame().setStatusMessage(sPointsReducedFrom + " " + startNumPts + " " + sTo + " " + endNumPts);
        return true;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.addLabel(sReducePointsInSelectedFeatures);
        dialog.addDoubleField(TOLERANCE, this.tolerance, 6, sTheReducePointsTolerance);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.tolerance = dialog.getDouble(TOLERANCE);
    }

    private EditTransaction createTransaction(Layer layer, final double tolerance) {
        EditTransaction transaction = EditTransaction.createTransactionOnSelection(new EditTransaction.SelectionEditor(){

            public Geometry edit(Geometry geometryWithSelectedItems, Collection selectedItems) {
                Geometry geo = ReducePointsISAPlugIn.this.reducePoints(geometryWithSelectedItems, tolerance);
                return geo;
            }
        }, this.workbenchContext.getLayerViewPanel(), this.workbenchContext.getLayerViewPanel().getContext(), this.getName(), layer, false, false);
        return transaction;
    }

    private Geometry reducePoints(Geometry geometry, double tolerance) {
        if (geometry instanceof GeometryCollection) {
            GeometryFactory geoFac = geometry.getFactory();
            GeometryCollection gc = (GeometryCollection)geometry;
            Geometry[] geos = new Geometry[gc.getNumGeometries()];
            if (!gc.isEmpty()) {
                for (int i = 0; i < gc.getNumGeometries(); ++i) {
                    geos[i] = this.reduceGeo(gc.getGeometryN(i), tolerance);
                }
                return new GeometryCollection(geos, geoFac);
            }
            return geometry;
        }
        return this.reduceGeo(geometry, tolerance);
    }

    private Geometry reduceGeo(Geometry geometry, double tolerance) {
        if (geometry instanceof LineString) {
            return GeoUtils.reducePoints(geometry, tolerance);
        }
        if (geometry instanceof LinearRing) {
            return GeoUtils.reducePoints(geometry, tolerance);
        }
        if (geometry instanceof Polygon) {
            return GeoUtils.reducePoints(geometry, tolerance);
        }
        if (geometry instanceof MultiLineString) {
            MultiLineString mls = (MultiLineString)geometry;
            LineString[] lineStrings = new LineString[mls.getNumGeometries()];
            GeometryFactory geoFac = geometry.getFactory();
            if (!mls.isEmpty()) {
                for (int i = 0; i < mls.getNumGeometries(); ++i) {
                    lineStrings[i] = (LineString)GeoUtils.reducePoints(mls.getGeometryN(i), tolerance);
                }
                return new MultiLineString(lineStrings, geoFac);
            }
            return geometry;
        }
        if (geometry instanceof MultiPolygon) {
            MultiPolygon mp = (MultiPolygon)geometry;
            Polygon[] polys = new Polygon[mp.getNumGeometries()];
            GeometryFactory geoFac = geometry.getFactory();
            DefaultCoordinateSequenceFactory dcsf = DefaultCoordinateSequenceFactory.instance();
            if (!mp.isEmpty()) {
                for (int i = 0; i < mp.getNumGeometries(); ++i) {
                    Polygon poly = (Polygon)GeoUtils.reducePoints(mp.getGeometryN(i), tolerance);
                    CoordinateSequence cs = dcsf.create(poly.getCoordinates());
                    polys[i] = new Polygon(new LinearRing(cs, geoFac), null, geoFac);
                }
                return new MultiPolygon(polys, geoFac);
            }
            return geometry;
        }
        return geometry;
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createAtLeastNFeaturesMustHaveSelectedItemsCheck(1)).add(checkFactory.createSelectedItemsLayersMustBeEditableCheck());
    }
}

