/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.Collection;
import java.util.Iterator;

public class LineSimplifyJTS15AlgorithmPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private static final String sSimplifyJTSAlgorithm = I18N.get("org.openjump.core.ui.plugin.tools.LineSimplifyJTS15AlgorithmPlugIn.Simplify-JTS-algorithm");
    private static final String sGeometryNotLineOrPolygon = I18N.get("org.openjump.core.ui.plugin.tools.LineSimplifyJTS15AlgorithmPlugIn.geometry-not-line-or-polygon");
    private static final String sidebarText = I18N.get("org.openjump.core.ui.plugin.tools.LineSimplifyJTS15AlgorithmPlugIn.Line-simplification-for-a-selected-line-or-polygon");
    private static final String sItem = I18N.get("org.openjump.core.ui.plugin.tools.LineSimplifyJTS15AlgorithmPlugIn.Item");
    private static final String sSimplificationFinalized = I18N.get("org.openjump.core.ui.plugin.tools.LineSimplifyJTS15AlgorithmPlugIn.simplification-finalized");
    private static String T3 = I18N.get("org.openjump.core.ui.plugin.tools.LineSimplifyJTS15AlgorithmPlugIn.Maximum-point-displacement-in-model-units");
    double maxPDisp = 0.0;
    private int geomType = 0;

    public void initialize(PlugInContext context) throws Exception {
        FeatureInstaller featureInstaller = new FeatureInstaller(context.getWorkbenchContext());
        featureInstaller.addMainMenuItem(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_GENERALIZATION}, sSimplifyJTSAlgorithm, false, null, LineSimplifyJTS15AlgorithmPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNItemsMustBeSelectedCheck(1)).add(checkFactory.createSelectedItemsLayersMustBeEditableCheck());
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(sidebarText);
        dialog.addDoubleField(T3, 1.0, 5);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.maxPDisp = dialog.getDouble(T3);
    }

    protected Layer layer(PlugInContext context) {
        return (Layer)context.getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems().iterator().next();
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        this.simplify(context, this.maxPDisp, monitor);
        System.gc();
    }

    private boolean simplify(PlugInContext context, double maxDisp, TaskMonitor monitor) throws Exception {
        System.gc();
        Collection features = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
        EditTransaction transaction = new EditTransaction(features, this.getName(), this.layer(context), this.isRollingBackInvalidEdits(context), false, context.getWorkbenchFrame());
        int count = 0;
        int noItems = features.size();
        Geometry resultgeom = null;
        Iterator iter = features.iterator();
        while (iter.hasNext()) {
            ++count;
            Feature f = (Feature)iter.next();
            Geometry geom = f.getGeometry();
            LineString line = null;
            Polygon poly = null;
            if (geom instanceof LineString) {
                line = (LineString)geom;
                this.geomType = 1;
            } else if (geom instanceof Polygon) {
                poly = (Polygon)geom;
                line = poly.getExteriorRing();
                this.geomType = 2;
            } else {
                this.geomType = 0;
                context.getWorkbenchFrame().warnUser(sGeometryNotLineOrPolygon);
            }
            if (this.geomType <= 0) continue;
            if (this.geomType == 1) {
                resultgeom = DouglasPeuckerSimplifier.simplify((Geometry)line, (double)Math.abs(maxDisp));
            } else if (this.geomType == 2) {
                resultgeom = TopologyPreservingSimplifier.simplify((Geometry)poly, (double)Math.abs(maxDisp));
            }
            String mytext = sItem + ": " + count + " / " + noItems + " : " + sSimplificationFinalized;
            monitor.report(mytext);
            transaction.setGeometry(count - 1, resultgeom);
        }
        transaction.commit();
        return true;
    }
}

