/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.raster;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.geom.Point2D;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.sextante.OpenJUMPSextanteRasterLayer;
import org.openjump.core.rasterimage.sextante.rasterWrappers.GridWrapperNotInterpolated;

public class CreatePolygonGridFromSelectedImageLayerPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private PlugInContext context = null;
    private MultiInputDialog dialog;
    private String sSidebar = "Creates a polygon grid from the selected raster.";
    public String sRemoveZeroCells = "remove cells with values =< 0";
    public String sMaxCellsToDisplay = "max cells to display";
    private String sName = "Create Polygon Grid from Raster";
    private String sCreatingPolygons = "Creating polygons...";
    private String sGrid = "grid";
    private String sToManyPolygons = "To many polygons to generate";
    private String sBand = "band";
    GeometryFactory gfactory = new GeometryFactory();
    public int maxCells = 200000;
    public boolean removeZeroCells = false;

    public void initialize(PlugInContext context) throws Exception {
        this.sName = I18N.get("org.openjump.core.ui.plugin.raster.CreatePolygonGridFromSelectedImageLayerPlugIn.Create-Polygon-Grid-from-Raster");
        this.sRemoveZeroCells = I18N.get("org.openjump.core.ui.plugin.raster.CreatePolygonGridFromSelectedImageLayerPlugIn.remove-cells-with-values") + " =< 0";
        this.sSidebar = I18N.get("org.openjump.core.ui.plugin.raster.CreatePolygonGridFromSelectedImageLayerPlugIn.Creates-a-polygon-grid-from-the-selected-raster.");
        this.sMaxCellsToDisplay = I18N.get("org.openjump.core.ui.plugin.raster.CreatePolygonGridFromSelectedImageLayerPlugIn.max-cells-to-display");
        this.sCreatingPolygons = I18N.get("org.openjump.core.ui.plugin.raster.CreatePolygonGridFromSelectedImageLayerPlugIn.Creating-polygons") + "...";
        this.sGrid = I18N.get("org.openjump.core.ui.plugin.raster.CreatePolygonGridFromSelectedImageLayerPlugIn.grid");
        this.sToManyPolygons = I18N.get("org.openjump.core.ui.plugin.raster.CreatePolygonGridFromSelectedImageLayerPlugIn.To-many-polygons-to-generate");
        this.sBand = I18N.get("org.openjump.core.ui.plugin.raster.CreatePolygonGridFromSelectedImageLayerPlugIn.band");
        FeatureInstaller featureInstaller = new FeatureInstaller(context.getWorkbenchContext());
        featureInstaller.addMainMenuItem(this, new String[]{MenuNames.RASTER}, this.sName + "...", false, null, CreatePolygonGridFromSelectedImageLayerPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayerablesMustBeSelectedCheck(1, RasterImageLayer.class));
    }

    public String getIconString() {
        return null;
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.initDialog(context);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(this.dialog);
        return true;
    }

    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        GeometryFactory gf = new GeometryFactory();
        RasterImageLayer rLayer = (RasterImageLayer)LayerTools.getSelectedLayerable(context, RasterImageLayer.class);
        if (rLayer == null) {
            context.getWorkbenchFrame().warnUser(I18N.get("pirol.plugIns.EditAttributeByFormulaPlugIn.no-layer-selected"));
            return;
        }
        OpenJUMPSextanteRasterLayer rstLayer = new OpenJUMPSextanteRasterLayer();
        rstLayer.create(rLayer);
        GridWrapperNotInterpolated gwrapper = new GridWrapperNotInterpolated(rstLayer, rstLayer.getLayerGridExtent());
        FeatureSchema fs = new FeatureSchema();
        fs.addAttribute("geometry", AttributeType.GEOMETRY);
        int numBands = rstLayer.getBandsCount();
        for (int i = 0; i < numBands; ++i) {
            fs.addAttribute(this.sBand + "_" + i, AttributeType.DOUBLE);
        }
        FeatureDataset fd = new FeatureDataset(fs);
        monitor.report(this.sCreatingPolygons);
        int nx = rstLayer.getLayerGridExtent().getNX();
        int ny = rstLayer.getLayerGridExtent().getNY();
        double halfCellDim = 0.5 * rstLayer.getLayerGridExtent().getCellSize();
        int numPoints = nx * ny;
        if (numPoints > this.maxCells) {
            context.getWorkbenchFrame().warnUser(this.sToManyPolygons + ": " + numPoints + " > " + this.maxCells);
            return;
        }
        for (int x = 0; x < nx; ++x) {
            for (int y = 0; y < ny; ++y) {
                Coordinate[] coords;
                BasicFeature ftemp = new BasicFeature(fs);
                Point2D pt = rstLayer.getLayerGridExtent().getWorldCoordsFromGridCoords(x, y);
                coords = new Coordinate[]{new Coordinate(pt.getX() - halfCellDim, pt.getY() + halfCellDim), new Coordinate(pt.getX() + halfCellDim, pt.getY() + halfCellDim), new Coordinate(pt.getX() + halfCellDim, pt.getY() - halfCellDim), new Coordinate(pt.getX() - halfCellDim, pt.getY() - halfCellDim), (Coordinate)coords[0].clone()};
                LinearRing lr = gf.createLinearRing(coords);
                Polygon poly = gf.createPolygon(lr, null);
                ftemp.setGeometry((Geometry)poly);
                double sumvalue = 0.0;
                for (int i = 0; i < numBands; ++i) {
                    double value = gwrapper.getCellValueAsDouble(x, y, i);
                    ftemp.setAttribute(this.sBand + "_" + i, (Object)value);
                    sumvalue += value;
                }
                if (this.removeZeroCells) {
                    if (sumvalue > 0.0) {
                        fd.add(ftemp);
                    }
                } else {
                    fd.add(ftemp);
                }
                if (!monitor.isCancelRequested()) continue;
                if (fd.size() > 0) {
                    context.addLayer(StandardCategoryNames.RESULT, rstLayer.getName() + "_cancel_" + this.sGrid, fd);
                }
                return;
            }
        }
        if (fd.size() > 0) {
            context.addLayer(StandardCategoryNames.RESULT, rstLayer.getName() + "_" + this.sGrid, fd);
        }
    }

    private void initDialog(PlugInContext context) {
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.sName, true);
        this.dialog.setSideBarDescription(this.sSidebar);
        this.dialog.addCheckBox(this.sRemoveZeroCells, this.removeZeroCells);
        this.dialog.addIntegerField(this.sMaxCellsToDisplay, this.maxCells, 10, this.sMaxCellsToDisplay);
        GUIUtil.centreOnWindow(this.dialog);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.removeZeroCells = dialog.getBoolean(this.sRemoveZeroCells);
        this.maxCells = dialog.getInteger(this.sMaxCellsToDisplay);
    }
}

