/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.queries;

import buoy.event.CommandEvent;
import buoy.event.MouseEnteredEvent;
import buoy.event.ValueChangedEvent;
import buoy.event.WindowClosingEvent;
import buoy.widget.BButton;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BFileChooser;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.BProgressBar;
import buoy.widget.BorderContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.util.CollectionMap;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.FeatureSelection;
import com.vividsolutions.jump.workbench.ui.InfoFrame;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.border.Border;
import org.openjump.core.ui.plugin.queries.Condition;
import org.openjump.core.ui.plugin.queries.Function;
import org.openjump.core.ui.plugin.queries.Operator;

public class QueryDialog
extends BDialog {
    public static final int ALL_LAYERS = 0;
    public static final int SELECTION = 1;
    public static final int SELECTED_LAYERS = 2;
    public static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat();
    private PlugInContext context;
    List layers = new ArrayList();
    Set attributes = new TreeSet();
    String attribute;
    char attributeType;
    Function function;
    Operator operator;
    String value;
    Map enumerations = new HashMap();
    static boolean runningQuery = false;
    static boolean cancelQuery = false;
    Collection selection;
    BCheckBox charFilter;
    BCheckBox caseSensitive;
    BCheckBox numFilter;
    BCheckBox geoFilter;
    BCheckBox display;
    BCheckBox select;
    BCheckBox create;
    BComboBox layerCB;
    BComboBox attributeCB;
    BComboBox functionCB;
    BComboBox operatorCB;
    BComboBox valueCB;
    BLabel comments;
    BLabel progressBarTitle;
    BProgressBar progressBar;
    BButton okButton;
    BButton refreshButton;
    BButton cancelButton;
    BButton stopButton;

    public QueryDialog(PlugInContext context) {
        this.component = super.createComponent(context.getWorkbenchFrame(), "", false);
        this.addEventLink(WindowClosingEvent.class, (Object)this, "exit");
        this.context = context;
        this.setTitle(I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.query-builder"));
        this.initUI(context);
    }

    protected void initUI(PlugInContext context) {
        LayoutInfo centerNone6 = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(6, 6, 6, 6), new Dimension());
        LayoutInfo centerBoth3 = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, new Insets(3, 3, 3, 3), new Dimension());
        LayoutInfo centerBoth1 = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, new Insets(1, 1, 1, 1), new Dimension());
        LayoutInfo nwBoth1 = new LayoutInfo(LayoutInfo.NORTHWEST, LayoutInfo.BOTH, new Insets(1, 1, 1, 1), new Dimension());
        LayoutInfo centerNone3 = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(3, 3, 3, 3), new Dimension());
        LayoutInfo centerH3 = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, new Insets(3, 3, 3, 3), new Dimension());
        LayoutInfo centerBoth = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, new Insets(3, 3, 3, 3), new Dimension());
        LayoutInfo rightAlign = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.HORIZONTAL, new Insets(3, 3, 3, 3), new Dimension());
        LayoutInfo leftAlign = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.HORIZONTAL, new Insets(3, 3, 3, 3), new Dimension());
        LayoutInfo leftAlignShort = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, new Insets(3, 3, 3, 3), new Dimension());
        Border border = BorderFactory.createLineBorder(Color.BLACK);
        Border border2 = BorderFactory.createLineBorder(Color.BLACK, 2);
        BorderContainer dialogContainer = new BorderContainer();
        BorderContainer northPanel = new BorderContainer();
        BorderContainer titleContainer = new BorderContainer();
        titleContainer.setDefaultLayout(centerNone6);
        FormContainer centerPanel = new FormContainer(1, 3);
        FormContainer optionPanel = new FormContainer(4, 1);
        optionPanel.setDefaultLayout(centerBoth1);
        BOutline optionPanelB = new BOutline(optionPanel, border);
        FormContainer managerPanel = new FormContainer(3, 3);
        managerPanel.setDefaultLayout(nwBoth1);
        BOutline managerPanelB = new BOutline(managerPanel, BorderFactory.createTitledBorder(border, I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.query-manager")));
        FormContainer attributeFilterPanel = new FormContainer(2, 3);
        attributeFilterPanel.setDefaultLayout(nwBoth1);
        BOutline attributeFilterPanelB = new BOutline(attributeFilterPanel, BorderFactory.createTitledBorder(border, I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.filter-on-attribute-type")));
        FormContainer resultPanel = new FormContainer(1, 3);
        resultPanel.setDefaultLayout(nwBoth1);
        BOutline resultPanelB = new BOutline(resultPanel, BorderFactory.createTitledBorder(border, I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.results")));
        FormContainer queryConstructorPanel = new FormContainer(2, 7);
        queryConstructorPanel.setBackground(Color.decode(I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.color1")));
        queryConstructorPanel.setDefaultLayout(centerNone3);
        BOutline queryConstructorPanelB = new BOutline(queryConstructorPanel, border2);
        FormContainer progressBarPanel = new FormContainer(5, 1);
        FormContainer southPanel = new FormContainer(7, 1);
        BButton openButton = new BButton(I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.open"));
        openButton.addEventLink(CommandEvent.class, (Object)this, "open");
        managerPanel.add(openButton, 1, 0, centerH3);
        BButton saveasButton = new BButton(I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.save-as"));
        saveasButton.addEventLink(CommandEvent.class, (Object)this, "saveas");
        managerPanel.add(saveasButton, 1, 2, centerH3);
        this.charFilter = new BCheckBox(I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.string"), true);
        this.charFilter.addEventLink(ValueChangedEvent.class, (Object)this, "charFilterChanged");
        attributeFilterPanel.add(this.charFilter, 0, 0);
        this.caseSensitive = new BCheckBox(I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.case-sensitive"), false);
        attributeFilterPanel.add(this.caseSensitive, 1, 0, centerNone3);
        this.numFilter = new BCheckBox(I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.numeric"), true);
        this.numFilter.addEventLink(ValueChangedEvent.class, (Object)this, "numFilterChanged");
        attributeFilterPanel.add(this.numFilter, 0, 1);
        this.geoFilter = new BCheckBox(I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.geometric"), true);
        this.geoFilter.addEventLink(ValueChangedEvent.class, (Object)this, "geoFilterChanged");
        attributeFilterPanel.add(this.geoFilter, 0, 2);
        this.display = new BCheckBox(I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.display-the-table"), false);
        resultPanel.add(this.display, 0, 0);
        this.select = new BCheckBox(I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.select-the-result"), true);
        resultPanel.add(this.select, 0, 1);
        this.create = new BCheckBox(I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.create-a-new-layer"), false);
        resultPanel.add(this.create, 0, 2);
        BLabel layerLabel = new BLabel(I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.layer"), BLabel.EAST);
        queryConstructorPanel.add(layerLabel, 0, 0, rightAlign);
        BLabel attributeLabel = new BLabel(I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.attribute"), BLabel.EAST);
        queryConstructorPanel.add(attributeLabel, 0, 1, rightAlign);
        BLabel functionLabel = new BLabel(I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.function"), BLabel.EAST);
        queryConstructorPanel.add(functionLabel, 0, 2, rightAlign);
        BLabel operatorLabel = new BLabel(I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.operator"), BLabel.EAST);
        queryConstructorPanel.add(operatorLabel, 0, 3, rightAlign);
        BLabel valueLabel = new BLabel(I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.value"), BLabel.EAST);
        queryConstructorPanel.add(valueLabel, 0, 4, rightAlign);
        this.layerCB = new BComboBox();
        this.layerCB.addEventLink(ValueChangedEvent.class, (Object)this, "layerChanged");
        queryConstructorPanel.add(this.layerCB, 1, 0, leftAlign);
        ((JComboBox)this.layerCB.getComponent()).setPrototypeDisplayValue("012345678901234567890123456789O1");
        this.attributeCB = new BComboBox();
        this.attributeCB.addEventLink(ValueChangedEvent.class, (Object)this, "attributeChanged");
        queryConstructorPanel.add(this.attributeCB, 1, 1, leftAlign);
        ((JComboBox)this.attributeCB.getComponent()).setPrototypeDisplayValue("01234567890123456789012345678901");
        this.functionCB = new BComboBox();
        this.functionCB.addEventLink(ValueChangedEvent.class, (Object)this, "functionChanged");
        queryConstructorPanel.add(this.functionCB, 1, 2, leftAlignShort);
        this.operatorCB = new BComboBox();
        this.operatorCB.addEventLink(ValueChangedEvent.class, (Object)this, "operatorChanged");
        queryConstructorPanel.add(this.operatorCB, 1, 3, leftAlignShort);
        this.valueCB = new BComboBox();
        this.valueCB.addEventLink(ValueChangedEvent.class, (Object)this, "valueChanged");
        queryConstructorPanel.add(this.valueCB, 1, 4, leftAlign);
        ((JComboBox)this.valueCB.getComponent()).setPrototypeDisplayValue("012345678901234567890123456789012345678901234567");
        this.comments = new BLabel("<html>&nbsp;<br>&nbsp;</html>");
        queryConstructorPanel.add(this.comments, 0, 5, 2, 2, centerBoth);
        this.progressBarTitle = new BLabel(" ");
        progressBarPanel.add(this.progressBarTitle, 0, 0, 1, 1, centerH3);
        this.progressBar = new BProgressBar();
        progressBarPanel.add(this.progressBar, 1, 0, 4, 1, centerH3);
        optionPanel.add(managerPanelB, 0, 0);
        optionPanel.add(attributeFilterPanelB, 1, 0, 2, 1);
        optionPanel.add(resultPanelB, 3, 0);
        centerPanel.setDefaultLayout(centerBoth3);
        centerPanel.add(optionPanel, 0, 0);
        centerPanel.add(queryConstructorPanelB, 0, 1);
        centerPanel.add(progressBarPanel, 0, 2);
        this.okButton = new BButton(I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.ok"));
        this.okButton.addEventLink(CommandEvent.class, (Object)this, "ok");
        this.stopButton = new BButton(I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.stop"));
        this.stopButton.addEventLink(CommandEvent.class, (Object)this, "stop");
        this.refreshButton = new BButton(I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.refresh"));
        this.refreshButton.addEventLink(CommandEvent.class, (Object)this, "refresh");
        southPanel.add(this.okButton, 2, 0);
        southPanel.add(this.refreshButton, 3, 0);
        southPanel.add(this.stopButton, 4, 0);
        dialogContainer.add(northPanel, BorderContainer.NORTH);
        dialogContainer.add(centerPanel, BorderContainer.CENTER);
        dialogContainer.add(southPanel, BorderContainer.SOUTH);
        context.getLayerManager().addLayerListener(new LayerListener(){

            public void categoryChanged(CategoryEvent e) {
            }

            public void featuresChanged(FeatureEvent e) {
            }

            public void layerChanged(LayerEvent e) {
                if (!runningQuery) {
                    QueryDialog.this.refresh();
                }
            }
        });
        this.initComboBoxes();
        this.setContent(dialogContainer);
        this.addEventLink(MouseEnteredEvent.class, (Object)this, "toFront");
        this.pack();
        this.setVisible(true);
        this.toFront();
    }

    BButton getOkButton() {
        return this.okButton;
    }

    BButton getCancelButton() {
        return this.cancelButton;
    }

    void initVariables() {
        runningQuery = false;
        cancelQuery = false;
        this.progressBarTitle.setText("");
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(0);
        this.progressBar.setProgressText("");
        this.refreshButton.setEnabled(true);
    }

    void initComboBoxes() {
        this.layerCB.removeAll();
        this.layerCB.add(I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.all-layers"));
        this.layerCB.add(I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.selection"));
        this.layerCB.add(I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.selected-layers"));
        List layers = this.context.getLayerManager().getLayers();
        for (int i = 0; i < layers.size(); ++i) {
            Layer layer = (Layer)layers.get(i);
            this.layerCB.add(layer.getName());
        }
        this.layers = layers;
        this.attributes = this.authorizedAttributes(layers);
        this.attributeType = (char)71;
        this.attributeCB.setContents(this.attributes);
        this.functionCB.setContents(Function.GEOMETRIC_FUNCTIONS);
        this.function = (Function)this.functionCB.getSelectedValue();
        this.operatorCB.setContents(Operator.GEOMETRIC_OP);
        this.operator = (Operator)this.operatorCB.getSelectedValue();
        this.valueCB.setContents(this.availableTargets());
        this.valueChanged();
        this.pack();
        this.initVariables();
    }

    public void layerChanged() {
        this.layers.clear();
        this.attributes.clear();
        if (this.layerCB.getSelectedIndex() == 0) {
            this.layers.addAll(this.context.getLayerManager().getLayers());
        } else if (this.layerCB.getSelectedIndex() == 1) {
            this.layers.addAll(this.context.getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems());
        } else if (this.layerCB.getSelectedIndex() == 2) {
            Layer[] ll = this.context.getLayerNamePanel().getSelectedLayers();
            this.layers.addAll(Arrays.asList(ll));
        } else {
            this.layers.add(this.context.getLayerManager().getLayer((String)this.layerCB.getSelectedValue()));
        }
        this.attributes.addAll(this.authorizedAttributes(this.layers));
        this.attributeCB.setContents(this.attributes);
        this.attributeChanged();
    }

    private boolean isAttributeAuthorized(FeatureSchema fs, String attributeName) {
        AttributeType type = fs.getAttributeType(attributeName);
        if (type == AttributeType.GEOMETRY && this.geoFilter.getState()) {
            return true;
        }
        if (type == AttributeType.STRING && this.charFilter.getState()) {
            return true;
        }
        if (type == AttributeType.INTEGER && this.numFilter.getState()) {
            return true;
        }
        if (type == AttributeType.DOUBLE && this.numFilter.getState()) {
            return true;
        }
        return type == AttributeType.DATE && this.numFilter.getState();
    }

    private Set authorizedAttributes(List layers) {
        TreeSet<String> set = new TreeSet<String>();
        this.enumerations = new HashMap();
        if (this.geoFilter.getState()) {
            set.add(" (GEOMETRY)");
        }
        this.attribute = "";
        for (int i = 0; i < layers.size(); ++i) {
            Layer layer = (Layer)layers.get(i);
            FeatureSchema fs = layer.getFeatureCollectionWrapper().getFeatureSchema();
            for (int j = 0; j < fs.getAttributeCount(); ++j) {
                String att = fs.getAttributeName(j);
                AttributeType type = fs.getAttributeType(j);
                if (type == AttributeType.GEOMETRY || !this.isAttributeAuthorized(fs, att)) continue;
                set.add(att + " (" + type.toString().split(" ")[0] + ")");
            }
        }
        return set;
    }

    private void charFilterChanged() {
        if (this.charFilter.getState()) {
            this.caseSensitive.setVisible(true);
        } else {
            this.caseSensitive.setVisible(false);
        }
        this.layerChanged();
    }

    private void numFilterChanged() {
        this.layerChanged();
    }

    private void geoFilterChanged() {
        this.layerChanged();
    }

    public void attributeChanged() {
        String att = (String)this.attributeCB.getSelectedValue();
        this.attribute = att.substring(0, att.lastIndexOf(32));
        String attType = att.substring(att.lastIndexOf(40) + 1, att.lastIndexOf(41));
        int newat = 83;
        if (attType.equals("INTEGER")) {
            newat = 78;
        } else if (attType.equals("DATE")) {
            newat = 68;
        } else if (attType.equals("DOUBLE")) {
            newat = 78;
        } else if (attType.equals("STRING")) {
            newat = 83;
        } else if (attType.equals("GEOMETRY")) {
            newat = 71;
        }
        if (newat == this.attributeType) {
            if (newat == 83) {
                this.updateValues();
            }
        } else {
            this.attributeType = newat;
            this.updateFunctions();
            this.functionChanged();
            this.updateValues();
        }
    }

    private void updateFunctions() {
        switch (this.attributeType) {
            case 'B': {
                this.functionCB.setContents(Function.BOOLEAN_FUNCTIONS);
                break;
            }
            case 'N': {
                this.functionCB.setContents(Function.NUMERIC_FUNCTIONS);
                break;
            }
            case 'D': {
                this.functionCB.setContents(Function.DATE_FUNCTIONS);
                break;
            }
            case 'S': {
                this.functionCB.setContents(Function.STRING_FUNCTIONS);
                break;
            }
            case 'E': {
                this.functionCB.setContents(Function.STRING_FUNCTIONS);
                break;
            }
            case 'G': {
                this.functionCB.setContents(Function.GEOMETRIC_FUNCTIONS);
                break;
            }
        }
    }

    public void functionChanged() {
        String ft = this.functionCB.getSelectedValue().toString();
        try {
            if (this.functionCB.getSelectedValue() instanceof Function) {
                Function newfunction = (Function)this.functionCB.getSelectedValue();
                if (newfunction.type != this.function.type) {
                    this.updateOperators();
                    this.operatorChanged();
                    this.updateValues();
                }
                this.function = (Function)this.functionCB.getSelectedValue();
                if (this.function == Function.SUBS || this.function == Function.BUFF) {
                    this.functionCB.setEditable(true);
                } else {
                    this.functionCB.setEditable(false);
                }
            } else if (this.functionCB.getSelectedValue() instanceof String) {
                if (this.function == Function.SUBS) {
                    String f = this.functionCB.getSelectedValue().toString();
                    String sub = f.substring(f.lastIndexOf(40) + 1, f.lastIndexOf(41));
                    String[] ss = sub.split(",");
                    Function.SUBS.args = new int[ss.length];
                    if (ss.length > 0) {
                        Function.SUBS.args[0] = Integer.parseInt(ss[0]);
                    }
                    if (ss.length > 1) {
                        Function.SUBS.args[1] = Integer.parseInt(ss[1]);
                    }
                    this.functionCB.setSelectedValue(Function.SUBS);
                } else if (this.function == Function.BUFF) {
                    String f = this.functionCB.getSelectedValue().toString();
                    String sub = f.substring(f.lastIndexOf(40) + 1, f.lastIndexOf(41));
                    Function.BUFF.arg = Double.parseDouble(sub);
                    this.functionCB.setSelectedValue(Function.BUFF);
                } else {
                    this.functionCB.setEditable(false);
                    this.context.getWorkbenchFrame().warnUser("Cannot modify this function name");
                }
            }
        }
        catch (Exception e) {
            this.context.getWorkbenchFrame();
            WorkbenchFrame.toMessage(e);
        }
    }

    private void updateOperators() {
        this.function = (Function)this.functionCB.getSelectedValue();
        switch (this.function.type) {
            case 'E': 
            case 'S': {
                this.operatorCB.setContents(Operator.STRING_OP);
                break;
            }
            case 'B': {
                this.operatorCB.setContents(Operator.BOOLEAN_OP);
                break;
            }
            case 'D': 
            case 'N': {
                this.operatorCB.setContents(Operator.NUMERIC_OP);
                break;
            }
            case 'G': {
                this.operatorCB.setContents(Operator.GEOMETRIC_OP);
                break;
            }
        }
    }

    public void operatorChanged() {
        String newopstring = this.operatorCB.getSelectedValue().toString();
        try {
            if (this.operatorCB.getSelectedValue() instanceof Operator) {
                Operator newop = (Operator)this.operatorCB.getSelectedValue();
                if (newop.type != this.operator.type) {
                    this.updateValues();
                }
                if (this.operator != Operator.MATC && this.operator != Operator.FIND && (newop == Operator.MATC || newop == Operator.FIND)) {
                    this.updateValues();
                }
                if ((this.operator == Operator.MATC || this.operator == Operator.FIND) && newop != Operator.MATC && newop != Operator.FIND) {
                    this.updateValues();
                }
                this.operator = newop;
                if (this.operator == Operator.WDIST) {
                    this.operatorCB.setEditable(true);
                } else {
                    this.operatorCB.setEditable(false);
                }
            } else if (this.operatorCB.getSelectedValue() instanceof String) {
                if (this.operator == Operator.WDIST) {
                    String f = this.operatorCB.getSelectedValue().toString();
                    String sub = f.substring(f.lastIndexOf(40) + 1, f.lastIndexOf(41));
                    Operator.WDIST.arg = Double.parseDouble(sub);
                    this.operatorCB.setSelectedValue(Operator.WDIST);
                } else {
                    this.operatorCB.setEditable(false);
                    this.context.getWorkbenchFrame().warnUser("Cannot modify this function name");
                }
            }
        }
        catch (Exception e) {
            this.context.getWorkbenchFrame();
            WorkbenchFrame.toMessage(e);
        }
    }

    private void updateValues() {
        if (this.function.type == 'B') {
            this.valueCB.setContents(new String[]{I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.true"), I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.false")});
            this.valueCB.setEditable(false);
        } else if (this.operator.type == 'G') {
            this.valueCB.setContents(this.availableTargets());
            this.valueCB.setEditable(true);
        } else if (this.attributeType == 'E') {
            if (this.operator.type == 'S') {
                this.valueCB.setContents((Object[])this.enumerations.get(this.attribute));
            } else if (this.operator.type == 'N') {
                this.valueCB.setContents(new Object[]{"0"});
            }
            this.valueCB.setEditable(true);
        } else if (this.attributeType == 'D') {
            this.valueCB.setContents(new Object[]{DATE_FORMATTER.format(new Date())});
        } else if (this.attributeType == 'S') {
            this.valueCB.setContents(this.availableStrings(this.attribute, 12));
            if (this.operator == Operator.MATC || this.operator == Operator.FIND) {
                this.valueCB.setContents(new String[]{I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.regular-expression")});
            }
            this.valueCB.setEditable(true);
        } else {
            this.valueCB.setContents(new String[]{""});
            this.valueCB.setEditable(true);
        }
    }

    private void valueChanged() {
        this.value = (String)this.valueCB.getSelectedValue();
    }

    private List availableTargets() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.all-layers"));
        list.add(I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.selection"));
        list.add(I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.selected-layers"));
        List layers = this.context.getLayerManager().getLayers();
        for (int i = 0; i < layers.size(); ++i) {
            list.add(((Layer)layers.get(i)).getName());
        }
        return list;
    }

    private Set availableStrings(String attribute, int maxsize) {
        TreeSet<Object> set = new TreeSet<Object>();
        set.add("");
        for (int i = 0; i < this.layers.size(); ++i) {
            FeatureCollectionWrapper fc = ((Layer)this.layers.get(i)).getFeatureCollectionWrapper();
            if (!fc.getFeatureSchema().hasAttribute(attribute)) continue;
            Iterator it = fc.iterator();
            while (it.hasNext() && set.size() < maxsize) {
                Feature f = (Feature)it.next();
                Object val = f.getAttribute(attribute);
                if (val == null) continue;
                set.add(val);
            }
        }
        return set;
    }

    private void open() {
        BFileChooser bfc = new BFileChooser(BFileChooser.OPEN_FILE, I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.open"));
        Properties prop = new Properties();
        if (bfc.showDialog(this)) {
            try {
                File f = bfc.getSelectedFile();
                prop.load(new FileInputStream(f));
            }
            catch (IOException e) {
                this.context.getWorkbenchFrame().warnUser(e.getMessage());
            }
        } else {
            return;
        }
        this.charFilter.setState(new Boolean(prop.getProperty("org.openjump.core.ui.plugin.queries.SimpleQuery.string")));
        this.caseSensitive.setState(new Boolean(prop.getProperty("org.openjump.core.ui.plugin.queries.SimpleQuery.case-sensitive")));
        this.numFilter.setState(new Boolean(prop.getProperty("org.openjump.core.ui.plugin.queries.SimpleQuery.numeric")));
        this.geoFilter.setState(new Boolean(prop.getProperty("org.openjump.core.ui.plugin.queries.SimpleQuery.geometric")));
        this.display.setState(new Boolean(prop.getProperty("org.openjump.core.ui.plugin.queries.SimpleQuery.display-the-table")));
        this.select.setState(new Boolean(prop.getProperty("org.openjump.core.ui.plugin.queries.SimpleQuery.select-the-result")));
        this.create.setState(new Boolean(prop.getProperty("org.openjump.core.ui.plugin.queries.SimpleQuery.create-a-new-layer")));
        this.initComboBoxes();
        int layerIndex = Integer.parseInt(prop.getProperty("layer_index"));
        String layerName = prop.getProperty("layer_name");
        if (layerIndex < 3) {
            this.layerCB.setSelectedIndex(layerIndex);
        } else {
            this.layerCB.setSelectedValue(layerName);
        }
        if (!layerName.equals(this.layerCB.getSelectedValue().toString())) {
            this.context.getWorkbenchFrame().warnUser(layerName + " " + I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.does-not-exist"));
            return;
        }
        this.layerChanged();
        int attributeIndex = Integer.parseInt(prop.getProperty("attribute_index"));
        String attributeName = prop.getProperty("attribute_name");
        this.attributeCB.setSelectedValue(attributeName);
        if (!attributeName.equals(this.attributeCB.getSelectedValue().toString())) {
            this.context.getWorkbenchFrame().warnUser(attributeName + " " + I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.does-not-exist"));
            return;
        }
        this.attributeChanged();
        int functionIndex = Integer.parseInt(prop.getProperty("function_index"));
        String functionName = prop.getProperty("function_name");
        this.functionCB.setSelectedIndex(functionIndex % this.functionCB.getItemCount());
        if (!functionName.equals(this.functionCB.getSelectedValue().toString())) {
            if (this.functionCB.getItem(functionIndex) == Function.SUBS) {
                this.functionCB.setEditable(true);
                this.functionCB.setSelectedValue(functionName);
            } else if (this.functionCB.getItem(functionIndex) == Function.BUFF) {
                this.functionCB.setEditable(true);
                this.functionCB.setSelectedValue(functionName);
            } else {
                this.context.getWorkbenchFrame().warnUser(functionName + " " + I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.does-not-exist"));
                return;
            }
        }
        this.functionChanged();
        int operatorIndex = Integer.parseInt(prop.getProperty("operator_index"));
        String operatorName = prop.getProperty("operator_name");
        this.operatorCB.setSelectedIndex(operatorIndex % this.operatorCB.getItemCount());
        if (!operatorName.equals(this.operatorCB.getSelectedValue().toString())) {
            if (this.operatorCB.getItem(operatorIndex) == Operator.WDIST) {
                this.operatorCB.setEditable(true);
                this.operatorCB.setSelectedValue(operatorName);
            } else {
                this.context.getWorkbenchFrame().warnUser(operatorName + " " + I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.does-not-exist"));
                return;
            }
        }
        this.operatorChanged();
        String value = prop.getProperty("value");
        this.valueCB.setSelectedValue(value);
    }

    private void saveas() {
        Properties prop = new Properties();
        prop.setProperty("org.openjump.core.ui.plugin.queries.SimpleQuery.string", "" + this.charFilter.getState());
        prop.setProperty("org.openjump.core.ui.plugin.queries.SimpleQuery.case-sensitive", "" + this.caseSensitive.getState());
        prop.setProperty("org.openjump.core.ui.plugin.queries.SimpleQuery.numeric", "" + this.numFilter.getState());
        prop.setProperty("org.openjump.core.ui.plugin.queries.SimpleQuery.geometric", "" + this.geoFilter.getState());
        prop.setProperty("org.openjump.core.ui.plugin.queries.SimpleQuery.display-the-table", "" + this.display.getState());
        prop.setProperty("org.openjump.core.ui.plugin.queries.SimpleQuery.select-the-result", "" + this.select.getState());
        prop.setProperty("org.openjump.core.ui.plugin.queries.SimpleQuery.create-a-new-layer", "" + this.create.getState());
        prop.setProperty("layer_index", "" + this.layerCB.getSelectedIndex());
        prop.setProperty("layer_name", "" + this.layerCB.getSelectedValue());
        prop.setProperty("attribute_index", "" + this.attributeCB.getSelectedIndex());
        prop.setProperty("attribute_name", "" + this.attributeCB.getSelectedValue());
        prop.setProperty("function_index", "" + this.functionCB.getSelectedIndex());
        prop.setProperty("function_name", "" + this.functionCB.getSelectedValue());
        prop.setProperty("operator_index", "" + this.operatorCB.getSelectedIndex());
        prop.setProperty("operator_name", "" + this.operatorCB.getSelectedValue());
        prop.setProperty("value", "" + this.valueCB.getSelectedValue());
        BFileChooser bfc = new BFileChooser(BFileChooser.SAVE_FILE, I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.save-as"));
        if (bfc.showDialog(this)) {
            try {
                File f = bfc.getSelectedFile();
                prop.store(new FileOutputStream(f), "Query file for Sqi4jump");
            }
            catch (FileNotFoundException e) {
                this.context.getWorkbenchFrame().warnUser(e.getMessage());
            }
            catch (IOException e) {
                this.context.getWorkbenchFrame().warnUser(e.getMessage());
            }
        }
    }

    void executeQuery() {
        final QueryDialog queryDialog = this;
        Runnable runnable = new Runnable(){

            public void run() {
                runningQuery = true;
                cancelQuery = false;
                QueryDialog.this.refreshButton.setEnabled(false);
                Condition condition = new Condition(queryDialog, QueryDialog.this.context);
                QueryDialog.this.comments.setText("<html>" + I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.select-from") + " \"" + QueryDialog.this.layerCB.getSelectedValue() + "\" " + I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.features-where") + " " + condition + "...</html>");
                FeatureSelection selectedFeatures = QueryDialog.this.context.getLayerViewPanel().getSelectionManager().getFeatureSelection();
                CollectionMap srcFeaturesMap = new CollectionMap();
                int total = 0;
                int featuresfound = 0;
                if (QueryDialog.this.layerCB.getSelectedIndex() == 1) {
                    for (Layer layer : selectedFeatures.getLayersWithSelectedItems()) {
                        srcFeaturesMap.put(layer, selectedFeatures.getFeaturesWithSelectedItems(layer));
                    }
                    total = srcFeaturesMap.size();
                } else {
                    for (int i = 0; i < QueryDialog.this.layers.size(); ++i) {
                        total += ((Layer)QueryDialog.this.layers.get(i)).getFeatureCollectionWrapper().size();
                    }
                }
                if (QueryDialog.this.operator.type == 'G' && QueryDialog.this.valueCB.getSelectedIndex() == 1) {
                    QueryDialog.this.selection = QueryDialog.this.context.getLayerViewPanel().getSelectionManager().getSelectedItems();
                }
                if (QueryDialog.this.select.getState()) {
                    selectedFeatures.unselectItems();
                }
                InfoFrame info = null;
                if (QueryDialog.this.display.getState()) {
                    info = new InfoFrame(QueryDialog.this.context.getWorkbenchContext(), QueryDialog.this.context, (TaskFrame)QueryDialog.this.context.getWorkbenchFrame().getActiveInternalFrame());
                }
                int count = 0;
                for (int i = 0; i < QueryDialog.this.layers.size(); ++i) {
                    Layer layer = (Layer)QueryDialog.this.layers.get(i);
                    FeatureCollectionWrapper fc = layer.getFeatureCollectionWrapper();
                    if (QueryDialog.this.attributeType != 'G' && !fc.getFeatureSchema().hasAttribute(QueryDialog.this.attribute)) continue;
                    Collection features = null;
                    features = QueryDialog.this.layerCB.getSelectedIndex() == 1 ? (Collection)srcFeaturesMap.get(layer) : fc.getFeatures();
                    QueryDialog.this.progressBarTitle.setText(layer.getName());
                    QueryDialog.this.progressBarTitle.getParent().layoutChildren();
                    QueryDialog.this.progressBar.setMinimum(0);
                    QueryDialog.this.progressBar.setMaximum(total);
                    QueryDialog.this.progressBar.setValue(0);
                    QueryDialog.this.progressBar.setProgressText("0/" + total);
                    QueryDialog.this.progressBar.setShowProgressText(true);
                    FeatureDataset dataset = new FeatureDataset(fc.getFeatureSchema());
                    ArrayList<BasicFeature> okFeatures = new ArrayList<BasicFeature>();
                    int mod = 1;
                    if (total > 1000) {
                        mod = 10;
                    }
                    if (total > 33000) {
                        mod = 100;
                    }
                    if (total > 1000000) {
                        mod = 1000;
                    }
                    try {
                        Iterator it = features.iterator();
                        while (it.hasNext()) {
                            BasicFeature f;
                            if (++count % mod == 0) {
                                QueryDialog.this.progressBar.setProgressText("" + count + "/" + total);
                                QueryDialog.this.progressBar.setValue(count);
                            }
                            if (condition.test(f = (BasicFeature)it.next())) {
                                okFeatures.add(f);
                                ++featuresfound;
                            }
                            Thread.yield();
                            if (!cancelQuery) continue;
                            break;
                        }
                        QueryDialog.this.progressBar.setProgressText("" + count + "/" + total);
                        QueryDialog.this.progressBar.setValue(count);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (cancelQuery) break;
                    if (okFeatures.size() == 0) continue;
                    if (QueryDialog.this.select.getState()) {
                        selectedFeatures.selectItems(layer, okFeatures);
                    }
                    if (QueryDialog.this.create.getState() || QueryDialog.this.display.getState()) {
                        dataset.addAll(okFeatures);
                    }
                    if (QueryDialog.this.create.getState()) {
                        QueryDialog.this.context.getLayerManager().addLayer(StandardCategoryNames.RESULT, layer.getName() + "_" + QueryDialog.this.value, dataset);
                    }
                    if (!QueryDialog.this.display.getState()) continue;
                    info.getModel().add(layer, okFeatures);
                }
                if (cancelQuery) {
                    QueryDialog.this.initVariables();
                    QueryDialog.this.comments.setText(I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.query-interrupted"));
                    return;
                }
                QueryDialog.this.progressBarTitle.setText(I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.result-display"));
                QueryDialog.this.progressBar.setIndeterminate(true);
                QueryDialog.this.comments.setText("<html>" + I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.select-from") + " \"" + QueryDialog.this.layerCB.getSelectedValue() + "\" " + I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.features-where") + " " + condition + " : " + featuresfound + " " + I18N.get("org.openjump.core.ui.plugin.queries.SimpleQuery.features-found") + "</html>");
                if (QueryDialog.this.select.getState()) {
                    QueryDialog.this.selection = QueryDialog.this.context.getLayerViewPanel().getSelectionManager().getSelectedItems();
                }
                if (QueryDialog.this.display.getState()) {
                    QueryDialog.this.context.getWorkbenchFrame().addInternalFrame(info);
                }
                if (QueryDialog.this.create.getState()) {
                    QueryDialog.this.initComboBoxes();
                }
                QueryDialog.this.progressBar.setIndeterminate(false);
                QueryDialog.this.progressBar.setValue(QueryDialog.this.progressBar.getMaximum());
                QueryDialog.this.initVariables();
            }
        };
        Thread t = new Thread(runnable);
        t.setPriority(Thread.currentThread().getPriority() - 1);
        t.start();
    }

    private void ok() {
        this.executeQuery();
    }

    private void stop() {
        if (runningQuery) {
            cancelQuery = true;
        }
    }

    private void refresh() {
        this.initComboBoxes();
    }

    private void exit() {
        if (runningQuery) {
            cancelQuery = true;
        }
        this.setVisible(false);
    }
}

