/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer.pirolraster;

import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.TIFFEncodeParam;
import com.sun.media.jai.codecimpl.TIFFCodec;
import com.sun.media.jai.codecimpl.TIFFImageEncoder;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.media.jai.PlanarImage;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.WorldFileHandler;
import org.openjump.core.ui.plugin.layer.pirolraster.LoadSextanteRasterImagePlugIn;

public class SaveRasterImageAsImagePlugIn
extends AbstractPlugIn {
    protected static final String TIFENDING = ".tif";
    protected static final String GEOENDING = ".tfw";
    private Properties properties = null;
    private static String propertiesFile = LoadSextanteRasterImagePlugIn.getPropertiesFile();
    private String lastPath;

    public boolean execute(PlugInContext context) throws Exception {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(SaveRasterImageAsImagePlugIn.TIFENDING);
            }

            public String getDescription() {
                return "TIFF Image";
            }
        });
        this.properties = new Properties();
        try {
            FileInputStream fis = new FileInputStream(propertiesFile);
            this.properties.load(fis);
            this.lastPath = this.properties.getProperty(LoadSextanteRasterImagePlugIn.KEY_PATH);
            fis.close();
        }
        catch (FileNotFoundException e) {
            context.getWorkbenchFrame().warnUser(I18N.get("org.openjump.core.ui.plugin.layer.pirolraster.SaveRasterImageAsImagePlugIn.File-not-found"));
        }
        catch (IOException e) {
            context.getWorkbenchFrame().warnUser(GenericNames.ERROR);
        }
        if (this.lastPath != null) {
            fc.setCurrentDirectory(new File(this.lastPath));
        }
        fc.setMultiSelectionEnabled(false);
        fc.setDialogTitle(this.getName());
        int returnVal = fc.showSaveDialog(fc);
        if (returnVal == 0) {
            String tifFileName = fc.getSelectedFile().getAbsolutePath();
            if (!tifFileName.toLowerCase().endsWith(TIFENDING.toLowerCase())) {
                tifFileName = tifFileName + TIFENDING;
            }
            File tifFile = new File(tifFileName);
            FileOutputStream tifOut = new FileOutputStream(tifFile);
            RasterImageLayer rLayer = (RasterImageLayer)LayerTools.getSelectedLayerable(context, RasterImageLayer.class);
            Raster r = rLayer.getRasterData();
            SampleModel sm = r.getSampleModel();
            ColorModel colorModel = PlanarImage.createColorModel((SampleModel)sm);
            BufferedImage image = new BufferedImage(colorModel, (WritableRaster)rLayer.getRasterData(), false, null);
            TIFFEncodeParam param = new TIFFEncodeParam();
            param.setCompression(1);
            TIFFImageEncoder encoder = (TIFFImageEncoder)TIFFCodec.createImageEncoder((String)"tiff", (OutputStream)tifOut, (ImageEncodeParam)param);
            encoder.encode((RenderedImage)image);
            tifOut.close();
            Envelope envelope = rLayer.getEnvelope();
            WorldFileHandler worldFileHandler = new WorldFileHandler(tifFileName, false);
            worldFileHandler.writeWorldFile(envelope, image.getWidth(), image.getHeight());
            rLayer.setImageFileName(tifFileName);
            rLayer.setNeedToKeepImage(false);
        }
        return true;
    }

    public void initialize(PlugInContext context) throws Exception {
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        MultiEnableCheck multiEnableCheck = new MultiEnableCheck();
        multiEnableCheck.add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(1, RasterImageLayer.class));
        return multiEnableCheck;
    }

    public String getName() {
        return I18N.get("org.openjump.core.ui.plugin.layer.pirolraster.SaveRasterImageAsImagePlugIn.Save-Raster-Image-As-Image");
    }

    public String getIconString() {
        return null;
    }
}

