/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer.pirolraster;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import org.openjump.core.rasterimage.RasterImageLayer;

public class RemoveSelectedRasterImageLayersPlugIn
extends AbstractPlugIn {
    public String getName() {
        return I18N.get("org.openjump.core.ui.plugin.layer.pirolraster.RemoveSelectedRasterImageLayersPlugIn.Remove-Selected-Raster-Image-Layers");
    }

    public boolean execute(PlugInContext context) throws Exception {
        this.remove(context.getLayerNamePanel().selectedNodes(Layerable.class).toArray(new Layerable[0]));
        return true;
    }

    public void remove(Layerable[] selectedLayers) {
        for (int i = 0; i < selectedLayers.length; ++i) {
            selectedLayers[i].getLayerManager().dispose(selectedLayers[i]);
            if (selectedLayers[i] instanceof RasterImageLayer) {
                ((RasterImageLayer)selectedLayers[i]).flushImages(false);
            }
            selectedLayers[i] = null;
        }
        System.gc();
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayerablesMustBeSelectedCheck(1, Layerable.class));
    }

    public String getIconString() {
        return null;
    }
}

