/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer.pirolraster;

import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codec.TIFFDirectory;
import com.sun.media.jai.codec.TIFFField;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.TitledPopupMenu;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.wizard.WizardDialog;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import java.awt.Frame;
import java.awt.Point;
import java.awt.geom.NoninvertibleTransformException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.WorldFileHandler;
import org.openjump.core.ui.plugin.layer.pirolraster.PasteRasterImageLayersPlugIn;
import org.openjump.core.ui.plugin.layer.pirolraster.RasterImageWizardPanel;
import org.openjump.io.PropertiesHandler;
import org.openjump.util.metaData.MetaInformationHandler;

public class LoadSextanteRasterImagePlugIn
extends AbstractPlugIn {
    private String imageFileName = "";
    private String cachedLayer = "default-layer-name";
    protected WorldFileHandler worldFileHandler = null;
    protected PropertiesHandler properties = null;
    protected static String propertiesFile = "RasterImage.properties";
    protected String lastPath = null;
    public static String KEY_PATH = "path";
    protected String KEY_ALLWAYSACCEPT_TWF_EXT = "allwaysCheckForTWFExtension";
    protected boolean allwaysLookForTFWExtension = true;
    protected String KEY_ZOOM_TO_INSERTED_IMAGE = "zoomToImage";
    protected boolean zoomToInsertedImage = true;
    protected static PlugInContext plugInContext = null;

    public static String getPropertiesFile() {
        return propertiesFile;
    }

    public String getName() {
        return I18N.get("org.openjump.core.rasterimage.AddRasterImageLayerWizard.Add-Sextante-Raster-Image");
    }

    private boolean addImage(WorkbenchContext context, Envelope envelope, Point imageDimensions) {
        String newLayerName = context.getLayerManager().uniqueLayerName(this.cachedLayer);
        String catName = StandardCategoryNames.WORKING;
        try {
            catName = ((Category)context.createPlugInContext().getLayerNamePanel().getSelectedCategories().toArray()[0]).getName();
        }
        catch (RuntimeException e1) {
            // empty catch block
        }
        int layersAsideImage = context.getLayerManager().getLayerables(Layerable.class).size();
        RasterImageLayer rLayer = new RasterImageLayer(newLayerName, context.getLayerManager(), this.imageFileName, null, null, envelope);
        MetaInformationHandler mih = new MetaInformationHandler(rLayer);
        mih.addMetaInformation(I18N.get("file-name"), this.imageFileName);
        mih.addMetaInformation(I18N.get("resolution"), imageDimensions.x + " (px) x " + imageDimensions.y + " (px)");
        mih.addMetaInformation(I18N.get("real-world-width"), new Double(envelope.getWidth()));
        mih.addMetaInformation(I18N.get("real-world-height"), new Double(envelope.getHeight()));
        context.getLayerManager().addLayerable(catName, rLayer);
        if (this.zoomToInsertedImage || layersAsideImage == 0) {
            try {
                context.getLayerViewPanel().getViewport().zoom(envelope);
            }
            catch (NoninvertibleTransformException e) {
                // empty catch block
            }
        }
        return true;
    }

    public void initialize(PlugInContext context) throws Exception {
        plugInContext = context;
        WorkbenchContext workbenchContext = context.getWorkbenchContext();
        RasterImageLayer.setWorkbenchContext(context.getWorkbenchContext());
        if (context.getWorkbenchContext().getLayerViewPanel() == null) {
            // empty if block
        }
        FeatureInstaller featureInstaller = new FeatureInstaller(workbenchContext);
        featureInstaller.addMainMenuItem(this, new String[]{MenuNames.LAYER}, this.getName() + "..." + "{pos:1}", false, null, null);
        TitledPopupMenu layerNamePopupMenu = context.getWorkbenchContext().getWorkbench().getFrame().getCategoryPopupMenu();
        layerNamePopupMenu.addSeparator();
        PasteRasterImageLayersPlugIn pasteRasterImagePlugIn = new PasteRasterImageLayersPlugIn();
        featureInstaller.addPopupMenuItem((JPopupMenu)layerNamePopupMenu, (PlugIn)pasteRasterImagePlugIn, I18N.get("org.openjump.core.ui.plugin.layer.pirolraster.PasteRasterImageLayersPlugIn.paste-raster-layer") + "...", false, null, (EnableCheck)pasteRasterImagePlugIn.createEnableCheck(context.getWorkbenchContext()));
        featureInstaller.addPopupMenuItem((JPopupMenu)layerNamePopupMenu, (PlugIn)this, I18N.get("org.openjump.core.rasterimage.AddRasterImageLayerWizard.Add-Sextante-Raster-Image") + "...", false, null, null);
        layerNamePopupMenu.addSeparator();
    }

    public boolean execute(PlugInContext context) throws Exception {
        String selectedFilename;
        this.reportNothingToUndoYet(context);
        JFileChooser fileChooser = new JFileChooser();
        this.properties = new PropertiesHandler(propertiesFile);
        try {
            this.properties.load();
            this.lastPath = this.properties.getProperty(KEY_PATH);
            this.allwaysLookForTFWExtension = this.properties.getPropertyAsBoolean(this.KEY_ALLWAYSACCEPT_TWF_EXT, this.allwaysLookForTFWExtension);
            this.zoomToInsertedImage = this.properties.getPropertyAsBoolean(this.KEY_ZOOM_TO_INSERTED_IMAGE, this.zoomToInsertedImage);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.lastPath != null) {
            fileChooser.setCurrentDirectory(new File(this.lastPath));
        }
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileFilter(new FileFilter(){

            public String getDescription() {
                return I18N.get("supported-image-types");
            }

            public boolean accept(File f) {
                return f.exists() && f.isFile() && (f.getName().toLowerCase().endsWith(".gif") || f.getName().toLowerCase().endsWith(".jpg") || f.getName().toLowerCase().endsWith(".tif") || f.getName().toLowerCase().endsWith(".tiff") || f.getName().toLowerCase().endsWith(".png")) || f.isDirectory();
            }
        });
        fileChooser.showOpenDialog(context.getWorkbenchFrame());
        if (fileChooser.getSelectedFile() == null || !fileChooser.getSelectedFile().exists()) {
            return false;
        }
        this.properties.setProperty(KEY_PATH, fileChooser.getSelectedFile().getPath());
        this.properties.store(" " + this.KEY_ZOOM_TO_INSERTED_IMAGE + I18N.get("RasterImagePlugIn.28") + this.KEY_ALLWAYSACCEPT_TWF_EXT + I18N.get("RasterImagePlugIn.29") + KEY_PATH + I18N.get("RasterImagePlugIn.30"));
        this.imageFileName = selectedFilename = fileChooser.getSelectedFile().getPath();
        this.cachedLayer = selectedFilename.substring(selectedFilename.lastIndexOf(File.separator) + 1, selectedFilename.lastIndexOf("."));
        boolean imageAdded = false;
        Point imageDimensions = RasterImageLayer.getImageDimensions(context.getWorkbenchContext(), selectedFilename);
        Envelope env = this.getGeoReferencing(selectedFilename, this.allwaysLookForTFWExtension, imageDimensions, context);
        if (env != null) {
            imageAdded = this.addImage(context.getWorkbenchContext(), env, imageDimensions);
        }
        return imageAdded;
    }

    protected Envelope getGeoReferencing(String fileName, boolean allwaysLookForTFWExtension, Point imageDimensions, PlugInContext context) throws IOException {
        Envelope env = null;
        this.worldFileHandler = new WorldFileHandler(fileName, allwaysLookForTFWExtension);
        if (imageDimensions == null) {
            context.getWorkbenchFrame().warnUser(I18N.get("org.openjump.core.rasterimage.AddRasterImageLayerWizard.can-not-determine-image-dimensions"));
            return null;
        }
        if (this.worldFileHandler.isWorldFileExistentForImage() != null) {
            env = this.worldFileHandler.readWorldFile(imageDimensions.x, imageDimensions.y);
        }
        if (env == null) {
            boolean isGeoTiff = false;
            if (fileName.toLowerCase().endsWith(".tif") || fileName.toLowerCase().endsWith(".tiff")) {
                Coordinate tiePoint = null;
                Coordinate pixelOffset = null;
                Coordinate pixelScale = null;
                double[] doubles = null;
                FileSeekableStream fileSeekableStream = new FileSeekableStream(fileName);
                TIFFDirectory tiffDirectory = new TIFFDirectory((SeekableStream)fileSeekableStream, 0);
                TIFFField[] availTags = tiffDirectory.getFields();
                for (int i = 0; i < availTags.length; ++i) {
                    if (availTags[i].getTag() == 33922) {
                        doubles = availTags[i].getAsDoubles();
                        if (doubles.length != 6) {
                            context.getWorkbenchFrame().warnUser("unsupported value for ModelTiepointTag (33922)");
                            break;
                        }
                        if (doubles[0] != 0.0 || doubles[1] != 0.0 || doubles[2] != 0.0) {
                            pixelOffset = doubles[2] == 0.0 ? new Coordinate(doubles[0], doubles[1]) : new Coordinate(doubles[0], doubles[1], doubles[2]);
                        }
                        if (doubles[5] == 0.0) {
                            tiePoint = new Coordinate(doubles[3], doubles[4]);
                            continue;
                        }
                        tiePoint = new Coordinate(doubles[3], doubles[4], doubles[5]);
                        continue;
                    }
                    if (availTags[i].getTag() != 33550) continue;
                    doubles = availTags[i].getAsDoubles();
                    pixelScale = doubles[2] == 0.0 ? new Coordinate(doubles[0], doubles[1]) : new Coordinate(doubles[0], doubles[1], doubles[2]);
                }
                fileSeekableStream.close();
                if (tiePoint != null && pixelScale != null) {
                    isGeoTiff = true;
                    Coordinate upperLeft = null;
                    Coordinate lowerRight = null;
                    upperLeft = pixelOffset == null ? tiePoint : new Coordinate(tiePoint.x - pixelOffset.x * pixelScale.x, tiePoint.y - pixelOffset.y * pixelScale.y);
                    lowerRight = new Coordinate(upperLeft.x + (double)imageDimensions.x * pixelScale.x, upperLeft.y - (double)imageDimensions.y * pixelScale.y);
                    env = new Envelope(upperLeft, lowerRight);
                }
            }
            if (!isGeoTiff || env == null) {
                context.getWorkbenchFrame().warnUser(I18N.get("org.openjump.core.rasterimage.AddRasterImageLayerWizard.no-worldfile-found"));
                WizardDialog d = new WizardDialog((Frame)context.getWorkbenchFrame(), I18N.get("RasterImagePlugIn.34") + this.worldFileHandler.getWorldFileName() + I18N.get("RasterImagePlugIn.35"), context.getErrorHandler());
                d.init(new WizardPanel[]{new RasterImageWizardPanel()});
                d.setSize(500, 400);
                GUIUtil.centreOnWindow(d);
                d.setVisible(true);
                if (!d.wasFinishPressed()) {
                    return null;
                }
                double minx = Double.parseDouble((String)d.getData(RasterImageWizardPanel.MINX_KEY));
                double maxx = Double.parseDouble((String)d.getData(RasterImageWizardPanel.MAXX_KEY));
                double miny = Double.parseDouble((String)d.getData(RasterImageWizardPanel.MINY_KEY));
                double maxy = Double.parseDouble((String)d.getData(RasterImageWizardPanel.MAXY_KEY));
                env = new Envelope(minx, maxx, miny, maxy);
            }
            this.worldFileHandler = new WorldFileHandler(fileName, this.allwaysLookForTFWExtension);
            this.worldFileHandler.writeWorldFile(env, imageDimensions.x, imageDimensions.y);
        }
        return env;
    }

    public String getIconString() {
        return null;
    }

    public static PlugInContext getPlugInContext() {
        return plugInContext;
    }
}

