/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.ImageIcon;
import org.openjump.core.ui.plugin.layer.SortCategoryAbstractPlugIn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortCategoryByFeaturesPlugIn
extends SortCategoryAbstractPlugIn {
    private static final ImageIcon ICON = null;
    private String subMenuLabel = "By Features";
    private String mostLabel = "By Least Number of Features";
    private String leastLabel = "By Most Number of Features";

    @Override
    protected String getSubMenuLabel() {
        return this.subMenuLabel;
    }

    @Override
    protected void addMenuOptions(PlugInContext context) {
        this.subMenuLabel = I18N.get("org.openjump.core.ui.plugin.layer.SortCategoryByFeaturesPlugIn.By-Featues");
        this.mostLabel = I18N.get("org.openjump.core.ui.plugin.layer.SortCategoryByFeaturesPlugIn.By-Least-Number-of-Features");
        this.leastLabel = I18N.get("org.openjump.core.ui.plugin.layer.SortCategoryByFeaturesPlugIn.By-Most-Number-of-Features");
        FeatureInstaller.addMainMenu(context.getFeatureInstaller(), new String[]{MenuNames.LAYER}, this.menuLabelOnLayer, 5);
        context.getFeatureInstaller().addMainMenuItem(this, new String[]{MenuNames.LAYER, this.menuLabelOnLayer, this.subMenuLabel}, this.leastLabel, false, ICON, SortCategoryByFeaturesPlugIn.createEnableCheck(context.getWorkbenchContext()));
        context.getFeatureInstaller().addMainMenuItem(this, new String[]{MenuNames.LAYER, this.menuLabelOnLayer, this.subMenuLabel}, this.mostLabel, false, ICON, SortCategoryByFeaturesPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    @Override
    ArrayList<Layerable> getOrderedLayersInCategory(Category category, String sortLabel) {
        ArrayList<Layerable> layers = this.getCategoryArrayList(category);
        if (sortLabel.equals(this.mostLabel)) {
            Collections.sort(layers, new LayerableFeatureSort());
        } else if (sortLabel.equals(this.leastLabel)) {
            Collections.sort(layers, Collections.reverseOrder(new LayerableFeatureSort()));
        } else {
            throw new IllegalStateException();
        }
        return layers;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LayerableFeatureSort
    implements Comparator<Layerable> {
        LayerableFeatureSort() {
        }

        @Override
        public int compare(Layerable layerable1, Layerable layerable2) {
            boolean layer1Feature = false;
            boolean layer2Feature = false;
            if (layerable1 instanceof Layer) {
                layer1Feature = true;
            }
            if (layerable2 instanceof Layer) {
                layer2Feature = true;
            }
            if (layer1Feature && layer2Feature) {
                Layer layer1 = (Layer)layerable1;
                Layer layer2 = (Layer)layerable2;
                return layer2.getFeatureCollectionWrapper().size() - layer1.getFeatureCollectionWrapper().size();
            }
            if (!layer1Feature && !layer2Feature) {
                return 0;
            }
            if (layer1Feature) {
                return 1;
            }
            return -1;
        }
    }
}

