/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file.open;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import org.openjump.core.ui.io.file.FileLayerLoader;
import org.openjump.core.ui.plugin.file.open.OpenFileWizardState;
import org.openjump.swing.util.SpringUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectFileLoaderPanel
extends JPanel
implements WizardPanel {
    private static final long serialVersionUID = -3105562554743126639L;
    public static final String KEY = SelectFileLoaderPanel.class.getName();
    public static final String TITLE = I18N.get(KEY);
    public static final String FILE_TYPE = I18N.get(KEY + ".file-type");
    public static final String INSTRUCTIONS = I18N.get(KEY + ".instructions");
    public static final String USE_SAME_SETTINGS_FOR = I18N.get(KEY + ".use-same-settings-for");
    private Map<String, JPanel> extensionPanelMap = new HashMap<String, JPanel>();
    private JPanel mainPanel;
    private Map<File, FileLayerLoader> fileLoaderMap = new HashMap<File, FileLayerLoader>();
    private Set<InputChangedListener> listeners = new LinkedHashSet<InputChangedListener>();
    private OpenFileWizardState state;

    public SelectFileLoaderPanel() {
        super(new BorderLayout());
        JPanel scrollPanel = new JPanel(new BorderLayout());
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        scrollPanel.add((Component)this.mainPanel, "North");
        JScrollPane scrollPane = new JScrollPane(scrollPanel);
        this.add((Component)scrollPane, "Center");
    }

    public OpenFileWizardState getState() {
        return this.state;
    }

    public void setState(OpenFileWizardState state) {
        this.state = state;
    }

    private void addFiles(final String extension, final Set<URI> files, final Set<FileLayerLoader> loaders) {
        final JPanel panel = new JPanel(new SpringLayout());
        panel.setBorder(BorderFactory.createTitledBorder("*." + extension));
        ActionListener useSameListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                panel.removeAll();
                if (((JCheckBox)e.getSource()).isSelected()) {
                    SelectFileLoaderPanel.this.addSameSettingsFields(panel, extension, files, loaders, this);
                } else {
                    SelectFileLoaderPanel.this.addIndividualSettingsFields(panel, extension, files, loaders, this);
                }
                SelectFileLoaderPanel.this.mainPanel.revalidate();
                SelectFileLoaderPanel.this.mainPanel.repaint();
            }
        };
        this.addSameSettingsFields(panel, extension, files, loaders, useSameListener);
        this.mainPanel.add(panel);
    }

    protected void addIndividualSettingsFields(JPanel panel, String extension, Set<URI> files, Set<FileLayerLoader> loaders, ActionListener useSameListener) {
        if (files.size() > 1) {
            panel.add(new JLabel(USE_SAME_SETTINGS_FOR + " *." + extension));
            JCheckBox useSameField = new JCheckBox();
            useSameField.setSelected(false);
            panel.add(useSameField);
            useSameField.addActionListener(useSameListener);
        }
        for (final URI file : files) {
            panel.add(new JLabel(this.state.getFileName(file)));
            JComboBox<FileLayerLoader> loaderField = new JComboBox<FileLayerLoader>();
            for (FileLayerLoader loader : loaders) {
                loaderField.addItem(loader);
            }
            FileLayerLoader selectedLoader = this.state.getFileLoader(file);
            if (selectedLoader == null) {
                loaderField.setSelectedIndex(0);
                this.state.setFileLoader(file, loaders.iterator().next());
            } else {
                loaderField.setSelectedItem(selectedLoader);
            }
            loaderField.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        FileLayerLoader fileLayerLoader = (FileLayerLoader)e.getItem();
                        SelectFileLoaderPanel.this.state.setFileLoader(file, fileLayerLoader);
                        SelectFileLoaderPanel.this.fireInputChanged();
                    }
                }
            });
            panel.add(loaderField);
        }
        SpringUtilities.makeCompactGrid(panel, panel.getComponentCount() / 2, 2, 5, 5, 5, 5);
    }

    protected void addSameSettingsFields(JPanel panel, final String extension, Set<URI> files, Set<FileLayerLoader> loaders, ActionListener useSameListener) {
        panel.add(new JLabel(USE_SAME_SETTINGS_FOR + " *." + extension));
        JCheckBox useSameField = new JCheckBox();
        useSameField.setSelected(true);
        useSameField.addActionListener(useSameListener);
        panel.add(useSameField);
        panel.add(new JLabel(FILE_TYPE));
        JComboBox<FileLayerLoader> loaderField = new JComboBox<FileLayerLoader>();
        for (FileLayerLoader loader : loaders) {
            loaderField.addItem(loader);
        }
        loaderField.setSelectedIndex(0);
        this.state.setFileLoader(extension, loaders.iterator().next());
        panel.add(loaderField);
        loaderField.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FileLayerLoader fileLayerLoader = (FileLayerLoader)e.getItem();
                    SelectFileLoaderPanel.this.state.setFileLoader(extension, fileLayerLoader);
                    SelectFileLoaderPanel.this.fireInputChanged();
                }
            }
        });
        SpringUtilities.makeCompactGrid(panel, 2, 2, 5, 5, 5, 5);
    }

    @Override
    public void enteredFromLeft(Map dataMap) {
        this.mainPanel.removeAll();
        this.state.setCurrentPanel(SelectFileLoaderPanel.class.getName());
        Map<String, Set<URI>> multiLoaderFiles = this.state.getMultiLoaderFiles();
        for (Map.Entry<String, Set<URI>> entry : multiLoaderFiles.entrySet()) {
            String extension = entry.getKey();
            Set<URI> extensionFiles = entry.getValue();
            this.addFiles(extension, extensionFiles, this.state.getExtensionLoaderMap().get(extension));
        }
    }

    @Override
    public void exitingToRight() throws Exception {
    }

    @Override
    public String getID() {
        return this.getClass().getName();
    }

    @Override
    public String getInstructions() {
        return INSTRUCTIONS;
    }

    @Override
    public String getNextID() {
        return this.state.getNextPanel(KEY);
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public boolean isInputValid() {
        return true;
    }

    @Override
    public void add(InputChangedListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void remove(InputChangedListener listener) {
        this.listeners.remove(listener);
    }

    private void fireInputChanged() {
        for (InputChangedListener listener : this.listeners) {
            listener.inputChanged();
        }
    }
}

