/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.io.DriverProperties;
import com.vividsolutions.jump.io.datasource.DataSource;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.io.datasource.StandardReaderWriterFileDataSource;
import com.vividsolutions.jump.task.DummyTaskMonitor;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import org.openjump.core.ui.images.IconLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveLayersWithoutDataSourcePlugIn
extends AbstractPlugIn {
    private static final String KEY = SaveLayersWithoutDataSourcePlugIn.class.getName();
    public static final String LAYERS_WITHOUT_DATASOURCE = I18N.get("org.openjump.core.ui.plugin.file.SaveLayersWithoutDataSourcePlugIn.layers-without-datasource-management");
    public static final String DONOTSAVE = I18N.get("org.openjump.core.ui.plugin.file.SaveLayersWithoutDataSourcePlugIn.do-not-save");
    public static final String SAVEASJML = I18N.get("org.openjump.core.ui.plugin.file.SaveLayersWithoutDataSourcePlugIn.save-as-jml");
    public static final String SAVEASSHP = I18N.get("org.openjump.core.ui.plugin.file.SaveLayersWithoutDataSourcePlugIn.save-as-shp");
    public static final String FILECHOOSER = I18N.get("org.openjump.core.ui.plugin.file.SaveLayersWithoutDataSourcePlugIn.directory-chooser");
    public static final String WARN_USER = I18N.get("org.openjump.core.ui.plugin.file.SaveLayersWithoutDataSourcePlugIn.every-layer-has-a-datasource");
    private JFileChooser fileChooser;

    @Override
    public String getName() {
        return I18N.get(KEY);
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        WorkbenchContext workbenchContext = context.getWorkbenchContext();
        EnableCheck enableCheck = this.createEnableCheck(workbenchContext);
        FeatureInstaller installer = new FeatureInstaller(workbenchContext);
        installer.addMainMenuItem(this, new String[]{MenuNames.FILE}, this.getName() + "..." + "{pos:9}", false, IconLoader.icon("disk_multiple.png"), this.createEnableCheck(context.getWorkbenchContext()));
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileSelectionMode(1);
        this.fileChooser.setDialogTitle(FILECHOOSER);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Collection<Layer> layersWithoutDataSource = this.layersWithoutDataSource(context.getTask());
        if (layersWithoutDataSource.size() == 0) {
            context.getWorkbenchFrame().warnUser(WARN_USER);
            return false;
        }
        int ret = this.fileChooser.showSaveDialog(context.getWorkbenchFrame());
        if (ret == 0) {
            return this.execute(context, layersWithoutDataSource, this.fileChooser.getSelectedFile());
        }
        return false;
    }

    public boolean execute(PlugInContext context, Collection<Layer> collection, File dir) throws Exception {
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), LAYERS_WITHOUT_DATASOURCE, true);
        String tooltip = "<html>" + Arrays.toString(collection.toArray(new Object[0])).replaceAll(",", "<br>") + "</html>";
        dialog.addSubTitle(I18N.getMessage("org.openjump.core.ui.plugin.file.SaveLayersWithoutDataSourcePlugIn.layers-without-datasource", new Object[]{new Integer(collection.size())})).setToolTipText(tooltip);
        dialog.addLabel(I18N.get("org.openjump.core.ui.plugin.file.SaveLayersWithoutDataSourcePlugIn.hover-the-label-to-see-the-list")).setToolTipText(tooltip);
        dialog.addRadioButton(DONOTSAVE, "ACTION", true, "");
        dialog.addRadioButton(SAVEASJML, "ACTION", false, "");
        dialog.addRadioButton(SAVEASSHP, "ACTION", false, "");
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (dialog.wasOKPressed()) {
            if (dialog.getBoolean(DONOTSAVE)) {
                return false;
            }
            dir.mkdir();
            for (Layer layer : collection) {
                String ext = null;
                StandardReaderWriterFileDataSource.ClassicReaderWriterFileDataSource dataSource = null;
                if (dialog.getBoolean(SAVEASJML)) {
                    ext = "jml";
                    dataSource = new StandardReaderWriterFileDataSource.JML();
                } else if (dialog.getBoolean(SAVEASSHP)) {
                    ext = "shp";
                    dataSource = new StandardReaderWriterFileDataSource.Shapefile();
                }
                this.saveLayer(layer, dir, dataSource, ext);
            }
            return true;
        }
        return false;
    }

    private void saveLayer(Layer layer, File dir, DataSource dataSource, String ext) throws Exception {
        String name = FileUtil.getFileNameFromLayerName(layer.getName());
        File fileName = FileUtil.addExtensionIfNone(new File(name), ext);
        String path = new File(dir, fileName.getName()).getAbsolutePath();
        DriverProperties dp = new DriverProperties();
        dp.set("File", path);
        dataSource.setProperties(dp);
        DataSourceQuery dsq = new DataSourceQuery(dataSource, path, path);
        layer.setDataSourceQuery(dsq).setFeatureCollectionModified(false);
        dataSource.getConnection().executeUpdate("", layer.getFeatureCollectionWrapper(), new DummyTaskMonitor());
    }

    private Collection<Layer> layersWithoutDataSource(Task task) {
        ArrayList<Layer> layersWithoutDataSource = new ArrayList<Layer>();
        for (Layer layer : task.getLayerManager().getLayers()) {
            if (layer.hasReadableDataSource()) continue;
            layersWithoutDataSource.add(layer);
        }
        return layersWithoutDataSource;
    }

    public EnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        final WorkbenchContext wc = workbenchContext;
        EnableCheckFactory enableCheckFactory = new EnableCheckFactory(workbenchContext);
        MultiEnableCheck enableCheck = new MultiEnableCheck();
        enableCheck.add(enableCheckFactory.createWindowWithLayerManagerMustBeActiveCheck());
        enableCheck.add(new EnableCheck(){

            public String check(JComponent component) {
                return SaveLayersWithoutDataSourcePlugIn.this.layersWithoutDataSource(wc.getTask()).size() > 0 ? null : I18N.get("org.openjump.core.ui.plugin.file.SaveLayersWithoutDataSourcePlugIn.a-layer-without-datasource-must-exist");
            }
        });
        return enableCheck;
    }
}

