/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openjump.core.geomutils.Arc;
import org.openjump.core.geomutils.MathVector;
import org.openjump.core.ui.plugin.edittoolbox.cursortools.ConstrainedMultiClickArcTool;

public class DrawConstrainedArcTool
extends ConstrainedMultiClickArcTool {
    private FeatureDrawingUtil featureDrawingUtil;
    static final String drawConstrainedArc = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.DrawConstrainedArcTool.Draw-Constrained-Arc");
    static final String theArcMustHaveAtLeast3Points = I18N.get("org.openjump.core.ui.plugin.edittoolbox.cursortools.DrawConstrainedArcTool.The-arc-must-have-at-least-3-points");

    private DrawConstrainedArcTool(FeatureDrawingUtil featureDrawingUtil) {
        this.drawClosed = false;
        this.featureDrawingUtil = featureDrawingUtil;
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy) {
        FeatureDrawingUtil featureDrawingUtil = new FeatureDrawingUtil(layerNamePanelProxy);
        return featureDrawingUtil.prepare(new DrawConstrainedArcTool(featureDrawingUtil), true);
    }

    public String getName() {
        return drawConstrainedArc;
    }

    public Icon getIcon() {
        return new ImageIcon(this.getClass().getResource("DrawArcConstrained.gif"));
    }

    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        if (!this.checkArc()) {
            return;
        }
        this.execute(this.featureDrawingUtil.createAddCommand((Geometry)this.getArc(), this.isRollingBackInvalidEdits(), this.getPanel(), this));
    }

    protected LineString getArc() throws NoninvertibleTransformException {
        ArrayList points = new ArrayList(this.getCoordinates());
        if (points.size() > 1) {
            Coordinate a = (Coordinate)points.get(0);
            Coordinate b = (Coordinate)points.get(1);
            Coordinate c = this.tentativeCoordinate;
            if (points.size() > 2) {
                c = (Coordinate)points.get(points.size() - 1);
            }
            MathVector v1 = new MathVector(b).vectorBetween(new MathVector(a));
            MathVector v2 = new MathVector(c).vectorBetween(new MathVector(a));
            double arcAngle = v1.angleDeg(v2);
            Arc arc = new Arc(a, b, this.fullAngle);
            return arc.getLineString();
        }
        return null;
    }

    protected boolean checkArc() throws NoninvertibleTransformException {
        if (this.getCoordinates().size() < 3) {
            this.getPanel().getContext().warnUser(theArcMustHaveAtLeast3Points);
            return false;
        }
        IsValidOp isValidOp = new IsValidOp((Geometry)this.getArc());
        if (!isValidOp.isValid()) {
            this.getPanel().getContext().warnUser(isValidOp.getValidationError().getMessage());
            if (this.getWorkbench().getBlackboard().get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false)) {
                return false;
            }
        }
        return true;
    }
}

