/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.graph.delauneySimplexInsert;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openjump.core.graph.delauneySimplexInsert.Simplex;

public class Triangulation {
    private HashMap neighbors = new HashMap();

    public Triangulation(Simplex simplex) {
        this.neighbors.put(simplex, new HashSet());
    }

    public String toString() {
        return "Triangulation (with " + this.neighbors.size() + " elements)";
    }

    public int size() {
        return this.neighbors.size();
    }

    public boolean contains(Simplex simplex) {
        return this.neighbors.containsKey(simplex);
    }

    public Iterator iterator() {
        return Collections.unmodifiableSet(this.neighbors.keySet()).iterator();
    }

    public void printStuff() {
        boolean remember = Simplex.moreInfo;
        System.out.println("Neighbor data for " + this);
        for (Simplex simplex : this.neighbors.keySet()) {
            Simplex.moreInfo = true;
            System.out.print("    " + simplex + ":");
            Simplex.moreInfo = false;
            Iterator otherIt = ((Set)this.neighbors.get(simplex)).iterator();
            while (otherIt.hasNext()) {
                System.out.print(" " + otherIt.next());
            }
            System.out.println();
        }
        Simplex.moreInfo = remember;
    }

    public Simplex neighborOpposite(Object vertex, Simplex simplex) {
        if (!simplex.contains(vertex)) {
            throw new IllegalArgumentException("Bad vertex; not in simplex");
        }
        block0: for (Simplex s : (Set)this.neighbors.get(simplex)) {
            for (Object v : simplex) {
                if (v.equals(vertex) || s.contains(v)) continue;
                continue block0;
            }
            return s;
        }
        return null;
    }

    public Set neighbors(Simplex simplex) {
        return new HashSet((Set)this.neighbors.get(simplex));
    }

    public void update(Set oldSet, Set newSet) {
        HashSet allNeighbors = new HashSet();
        Iterator it = oldSet.iterator();
        while (it.hasNext()) {
            allNeighbors.addAll((Set)this.neighbors.get((Simplex)it.next()));
        }
        for (Simplex simplex : oldSet) {
            Iterator otherIt = ((Set)this.neighbors.get(simplex)).iterator();
            while (otherIt.hasNext()) {
                ((Set)this.neighbors.get(otherIt.next())).remove(simplex);
            }
            this.neighbors.remove(simplex);
            allNeighbors.remove(simplex);
        }
        allNeighbors.addAll(newSet);
        it = newSet.iterator();
        while (it.hasNext()) {
            this.neighbors.put((Simplex)it.next(), new HashSet());
        }
        for (Simplex s1 : newSet) {
            for (Simplex s2 : allNeighbors) {
                if (!s1.isNeighbor(s2)) continue;
                ((Set)this.neighbors.get(s1)).add(s2);
                ((Set)this.neighbors.get(s2)).add(s1);
            }
        }
    }
}

