/*
 * Decompiled with CFR 0.152.
 */
package de.soldin.jumpcore.geomconv;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.GeometryEditor;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.FeatureSelection;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.OKCancelDialog;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import de.soldin.jumpcore.ExtCorePlugIn;
import de.soldin.jumpcore.UndoableSetGeometry;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GCPlugin
extends ExtCorePlugIn {
    private GeometryFactory factory = new GeometryFactory();
    private List items;
    private WorkbenchContext wbc;
    private String target;
    private boolean youvebeenwarned = false;

    public GCPlugin() {
        this(null, null);
    }

    public GCPlugin(WorkbenchContext wbc, String target) {
        this.wbc = wbc;
        this.target = target;
        this.i18nPath = "language/geomconv/gc";
        this.items = new ArrayList(this.getCreatableGeoms().keySet());
        Collections.sort(this.items);
        this.items.add("separator");
        this.items.add("close-lines");
        this.items.add("remove-closing-segment");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        this.wbc = context.getWorkbenchContext();
        String[] menuchain = new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_GEOMETRY, this.getName()};
        JPopupMenu popupMenu = LayerViewPanel.popupMenu();
        String[] popupchain = new String[]{this.getName()};
        this.addToMainMenu(this.wbc, menuchain);
        try {
            this.addToPopupMenu(this.wbc, popupMenu, popupchain);
        }
        catch (NoSuchMethodError e) {
            System.out.println("update to oj 1.4.1 for popupmenu entries");
        }
    }

    public void addToPopupMenu(WorkbenchContext wbc, JPopupMenu popupMenu, String[] popupchain) {
        PlugInContext context = wbc.createPlugInContext();
        EnableCheck checker = this.createEnableCheck();
        for (String menuentry : this.items) {
            GCPlugin plugin = new GCPlugin(wbc, menuentry);
            if (menuentry.equals("separator")) {
                this.getSubMenu(popupMenu, popupchain).addSeparator();
                continue;
            }
            context.getFeatureInstaller().addPopupMenuItem(popupMenu, plugin, popupchain, this._(menuentry.toLowerCase()), false, null, checker);
        }
    }

    public void addToMainMenu(WorkbenchContext wbc, String[] menuchain) {
        PlugInContext context = wbc.createPlugInContext();
        EnableCheck checker = this.createEnableCheck();
        for (String menuentry : this.items) {
            GCPlugin plugin = new GCPlugin(wbc, menuentry);
            if (menuentry.equals("separator")) {
                context.getFeatureInstaller().addMenuSeparator(menuchain);
                continue;
            }
            context.getFeatureInstaller().addMainMenuItem(plugin, menuchain, this._(menuentry.toLowerCase()), false, null, checker);
        }
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Collection layers;
        if (this.layerMode()) {
            String message;
            layers = this.getLayers();
            StringBuffer buf = new StringBuffer();
            for (Layer layer : layers) {
                String name = layer.getName();
                buf.append(buf.length() == 0 ? name : ", " + name);
            }
            String string = message = this.target.equalsIgnoreCase("close-lines") || this.target.equalsIgnoreCase("remove-closing-segment") ? "treat-all-with-tools" : "convert-all-to";
            if (!this.okCancel(this._("are-you-sure"), this._(message, buf, this._(this.target.toLowerCase())))) {
                return false;
            }
        }
        context.getLayerManager().getUndoableEditReceiver().reportNothingToUndoYet();
        layers = this.getLayers();
        UndoableSetGeometry action = new UndoableSetGeometry(this.getName());
        for (Layer layer : layers) {
            Collection feats = this.getFeatures(layer);
            UndoableSetGeometry layeraction = new UndoableSetGeometry(layer, this.getName());
            Iterator i = feats.iterator();
            while (i.hasNext()) {
                try {
                    Geometry geom_orig;
                    Feature feat = (Feature)i.next();
                    Geometry geom_src = geom_orig = layeraction.getGeom(feat);
                    Geometry geom_new = null;
                    this.youvebeenwarned = false;
                    if (this.target.equalsIgnoreCase("close-lines") || this.target.equalsIgnoreCase("remove-closing-segment")) {
                        if (geom_src instanceof LinearRing || geom_src instanceof Polygon || geom_src instanceof MultiPolygon) {
                            geom_src = this.factory.createMultiLineString(this.getLines(geom_src));
                        }
                        int count = geom_src.getNumGeometries();
                        boolean changed = false;
                        Geometry[] geoms_new = new Geometry[count];
                        GeometryEditor editor = new GeometryEditor();
                        for (int j = 0; j < count; ++j) {
                            Geometry geom = geom_src.getGeometryN(j);
                            if (geom instanceof LinearRing) {
                                geom = this.factory.createLineString(geom.getCoordinates());
                            }
                            if (this.target.equalsIgnoreCase("close-lines")) {
                                geoms_new[j] = editor.edit(geom, (GeometryEditor.GeometryEditorOperation)new CloseRing());
                            } else if (this.target.equalsIgnoreCase("remove-closing-segment")) {
                                geoms_new[j] = editor.edit(geom, (GeometryEditor.GeometryEditorOperation)new RemoveClosing());
                            }
                            if (geoms_new[j].equalsExact(geom)) continue;
                            changed = true;
                        }
                        if (changed && count > 1) {
                            geom_new = this.factory.createGeometryCollection(geoms_new);
                            geom_new = this.convert(geom_new, geom_src.getGeometryType());
                        } else if (changed && count == 1) {
                            geom_new = geoms_new[0];
                        } else {
                            this.warnUser(this._("nothing-to-do", feat.getID()));
                        }
                    } else {
                        geom_new = this.convert(geom_src, this.target);
                    }
                    if (geom_new == null || geom_new.equalsExact(geom_orig)) continue;
                    layeraction.setGeom(feat, geom_new);
                }
                catch (IllegalArgumentException e) {
                    this.warnUser(this._e(e.getMessage()));
                }
                catch (InvocationTargetException ie) {
                    if (ie.getCause() == null) continue;
                    this.warnUser(this._e(ie.getCause().getLocalizedMessage()));
                }
            }
            if (layeraction.isEmpty()) continue;
            action.add(layeraction);
        }
        if (!action.isEmpty()) {
            action.execute();
            this.wbc.getLayerManager().getUndoableEditReceiver().receive(action);
            return true;
        }
        if (!this.youvebeenwarned) {
            this.warnUser(this._("nothing-changed"));
        }
        return false;
    }

    @Override
    public String getName() {
        return this._("convert-selected-to");
    }

    private JMenu getSubMenu(MenuElement menu, String[] keys) {
        MenuElement[] ms = menu.getSubElements();
        String key = keys[0];
        for (int i = 0; i < ms.length; ++i) {
            MenuElement m = ms[i];
            if (m == null || !(m instanceof JMenu) || !((JMenu)m).getText().equals(key)) continue;
            if (keys.length > 1) {
                String[] subkeys = new String[keys.length - 1];
                for (int j = 1; j < keys.length; ++j) {
                    subkeys[j] = keys[j];
                }
                m = this.getSubMenu(menu, subkeys);
                continue;
            }
            return (JMenu)m;
        }
        return null;
    }

    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = new EnableCheckFactory(this.wbc);
        MultiEnableCheck checker = new MultiEnableCheck();
        checker.add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
        checker.add(new EnableCheck(){

            public String check(JComponent component) {
                Collection layers = GCPlugin.this.getLayers();
                if (layers == null || layers.isEmpty()) {
                    return GCPlugin.this._("select-geometries-or-layers");
                }
                for (Layer layer : layers) {
                    if (layer.isEditable()) continue;
                    return GCPlugin.this._("layer-not-editable", layer.getName());
                }
                return null;
            }
        });
        return checker;
    }

    private boolean layerMode() {
        FeatureSelection sel = ((SelectionManagerProxy)((Object)this.wbc.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getFeatureSelection();
        return sel.getFeaturesWithSelectedItems().isEmpty();
    }

    private Collection getFeatures(Layer layer) {
        FeatureSelection sel = ((SelectionManagerProxy)((Object)this.wbc.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getFeatureSelection();
        Collection feats = !sel.getFeaturesWithSelectedItems().isEmpty() ? sel.getFeaturesWithSelectedItems(layer) : layer.getFeatureCollectionWrapper().getFeatures();
        return feats;
    }

    private Collection getLayers() {
        List<Layer> layers = ((SelectionManagerProxy)((Object)this.wbc.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getFeatureSelection().getLayersWithSelectedItems();
        return layers.isEmpty() ? Arrays.asList(this.wbc.getLayerNamePanel().getSelectedLayers()) : layers;
    }

    private Collection<String> getTypes(GeometryCollection geom) {
        Vector<String> types = new Vector<String>();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            String type = geom.getGeometryN(i).getGeometryType();
            if (types.contains(type)) continue;
            types.add(type);
        }
        return types;
    }

    private Map getCreatableGeoms() {
        Hashtable<String, Method> geoms = new Hashtable<String, Method>();
        Class<?> cfactory = this.factory.getClass();
        Method[] methods = cfactory.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String id;
            Method method = methods[i];
            if (!method.getName().startsWith("create")) continue;
            Class<?>[] cparams = methods[i].getParameterTypes();
            boolean wrong = false;
            for (int j = 0; j < cparams.length; ++j) {
                Class<?> cparam = cparams[j];
                if (this.validType(cparam)) continue;
                wrong = true;
                break;
            }
            if (wrong || (id = method.getName().replaceFirst("create", "")).equals("PointFromInternalCoord") || id.equals("Geometry")) continue;
            geoms.put(id, method);
        }
        return geoms;
    }

    private boolean validType(Class clazz) {
        String name = clazz.isArray() ? clazz.getComponentType().getName() : clazz.getName();
        return name.equals("com.vividsolutions.jts.geom.Coordinate") || name.equals("com.vividsolutions.jts.geom.LinearRing") || name.equals("com.vividsolutions.jts.geom.LineString") || name.equals("com.vividsolutions.jts.geom.Polygon") || name.equals("com.vividsolutions.jts.geom.Geometry");
    }

    private void warnUser(String message) {
        this.youvebeenwarned = true;
        this.wbc.getLayerViewPanel().getContext().warnUser(message);
    }

    private Geometry convert(Geometry geom_src, String type) throws Exception {
        String name;
        Class<?>[] cparams;
        Geometry geom_new = null;
        Method method = (Method)this.getCreatableGeoms().get(type);
        Class<?>[] classArray = cparams = method instanceof Method ? method.getParameterTypes() : null;
        if (!(method instanceof Method)) {
            this.warnUser(this._("no-conversion-method", this._(type.toLowerCase()), type));
            return null;
        }
        boolean isArray = cparams[0].isArray();
        String string = name = isArray ? cparams[0].getComponentType().getName() : cparams[0].getName();
        if (!isArray && name.equals("com.vividsolutions.jts.geom.Coordinate")) {
            if (geom_src.getCoordinates().length == 1) {
                geom_new = (Geometry)method.invoke((Object)this.factory, geom_src.getCoordinates()[0]);
            } else {
                this.warnUser(this._("only-one-coordinate", type));
            }
        } else if (isArray && name.equals("com.vividsolutions.jts.geom.Coordinate")) {
            geom_new = (Geometry)method.invoke((Object)this.factory, new Object[]{geom_src.getCoordinates()});
        } else if (isArray && name.equals("com.vividsolutions.jts.geom.LineString")) {
            Coordinate[] coords = geom_src.getCoordinates();
            geom_new = (Geometry)method.invoke((Object)this.factory, new Object[]{this.getLines(geom_src)});
        } else if (cparams.length == 2 && name.equals("com.vividsolutions.jts.geom.LinearRing") && cparams[1].isArray() && name.equals(cparams[1].getComponentType().getName())) {
            geom_new = this.constructPolygon(geom_src);
        } else if (isArray && name.equals("com.vividsolutions.jts.geom.Polygon")) {
            Polygon[] polys = this.constructPolygons(geom_src);
            if (polys != null) {
                geom_new = (Geometry)method.invoke((Object)this.factory, new Object[]{polys});
            }
        } else if (isArray && name.equals("com.vividsolutions.jts.geom.Geometry")) {
            Geometry[] geoms = new Geometry[geom_src.getNumGeometries()];
            for (int j = 0; j < geom_src.getNumGeometries(); ++j) {
                geoms[j] = geom_src.getGeometryN(j);
            }
            geom_new = (Geometry)method.invoke((Object)this.factory, new Object[]{geoms});
        } else {
            this.warnUser(this._("conversion-not-implemented", this._(type.toLowerCase()), type));
        }
        return geom_new;
    }

    private Polygon constructPolygon(Geometry src) {
        Collection<String> types;
        if (src instanceof GeometryCollection && (types = this.getTypes((GeometryCollection)src)).size() == 1 && types.iterator().next().equalsIgnoreCase("point")) {
            src = this.factory.createLinearRing(src.getCoordinates());
        }
        ArrayList<Object> shells = new ArrayList<Object>();
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        try {
            for (int i = 0; i < src.getNumGeometries(); ++i) {
                Geometry geom = src.getGeometryN(i);
                LinearRing ring = this.factory.createLinearRing(geom.getCoordinates());
                if (CGAlgorithms.isCCW((Coordinate[])ring.getCoordinates())) {
                    holes.add(ring);
                    continue;
                }
                shells.add(ring);
            }
            if (shells.size() != 1) {
                shells.addAll(holes);
                holes.clear();
                ArrayList<LinearRing> foundholes = this.findCWHoles(shells);
                if (foundholes.size() > 0) {
                    shells.removeAll(foundholes);
                    for (int j = 0; j < foundholes.size(); ++j) {
                        LinearRing hole = foundholes.get(j);
                        if (!CGAlgorithms.isCCW((Coordinate[])hole.getCoordinates())) {
                            hole = this.reverseRing(hole);
                        }
                        holes.add(hole);
                    }
                }
            }
            if (shells.size() != 1) {
                this.warnUser(this._("missing-exactly-one-shell"));
                return null;
            }
            return this.factory.createPolygon((LinearRing)shells.get(0), holes.toArray(new LinearRing[0]));
        }
        catch (IllegalArgumentException e) {
            this.warnUser(this._e(e.getMessage()));
            return null;
        }
    }

    public Polygon[] constructPolygons(Geometry src) {
        int i;
        src = this.factory.createMultiLineString((LineString[])this.getRings(src));
        GeometryFactory geometryFactory = this.factory;
        ArrayList<LinearRing> shells = new ArrayList<LinearRing>();
        ArrayList<Object> holes = new ArrayList();
        for (int i2 = 0; i2 < src.getNumGeometries(); ++i2) {
            Geometry geom = src.getGeometryN(i2);
            Coordinate[] points = geom.getCoordinates();
            try {
                LinearRing ring = geometryFactory.createLinearRing(points);
                if (CGAlgorithms.isCCW((Coordinate[])points)) {
                    holes.add(ring);
                    continue;
                }
                shells.add(ring);
                continue;
            }
            catch (IllegalArgumentException e) {
                this.warnUser(this._("bad-rings"));
                return null;
            }
        }
        if (shells.size() > 1 && holes.size() == 0 && (holes = this.findCWHoles(shells)).size() > 0) {
            shells.removeAll(holes);
            ArrayList<LinearRing> ccwHoles = new ArrayList<LinearRing>(holes.size());
            for (int i3 = 0; i3 < holes.size(); ++i3) {
                ccwHoles.add(this.reverseRing((LinearRing)holes.get(i3)));
            }
            holes = ccwHoles;
        }
        ArrayList holesForShells = new ArrayList(shells.size());
        ArrayList<LinearRing> holesWithoutShells = new ArrayList<LinearRing>();
        for (i = 0; i < shells.size(); ++i) {
            holesForShells.add(new ArrayList());
        }
        for (i = 0; i < holes.size(); ++i) {
            LinearRing testRing = (LinearRing)holes.get(i);
            LinearRing minShell = null;
            Envelope minEnv = null;
            Envelope testEnv = testRing.getEnvelopeInternal();
            Coordinate testPt = testRing.getCoordinateN(0);
            for (int j = 0; j < shells.size(); ++j) {
                LinearRing tryRing = (LinearRing)shells.get(j);
                Envelope tryEnv = tryRing.getEnvelopeInternal();
                if (minShell != null) {
                    minEnv = minShell.getEnvelopeInternal();
                }
                boolean isContained = false;
                Coordinate[] coordList = tryRing.getCoordinates();
                if (tryEnv.contains(testEnv) && CGAlgorithms.isPointInRing((Coordinate)testPt, (Coordinate[])coordList)) {
                    isContained = true;
                }
                if (!isContained || minShell != null && !minEnv.contains(tryEnv)) continue;
                minShell = tryRing;
            }
            if (minShell == null) {
                holesWithoutShells.add(testRing);
                continue;
            }
            ((ArrayList)holesForShells.get(shells.indexOf(minShell))).add(testRing);
        }
        Polygon[] polygons = new Polygon[shells.size() + holesWithoutShells.size()];
        for (i = 0; i < shells.size(); ++i) {
            polygons[i] = geometryFactory.createPolygon((LinearRing)shells.get(i), ((ArrayList)holesForShells.get(i)).toArray(new LinearRing[0]));
        }
        for (i = 0; i < holesWithoutShells.size(); ++i) {
            polygons[shells.size() + i] = geometryFactory.createPolygon(this.reverseRing((LinearRing)holesWithoutShells.get(i)), null);
        }
        holesForShells = null;
        holesWithoutShells = null;
        shells = null;
        holes = null;
        return polygons;
    }

    private ArrayList<LinearRing> findCWHoles(ArrayList shells) {
        ArrayList<LinearRing> holesCW = new ArrayList<LinearRing>(shells.size());
        LinearRing[] noHole = new LinearRing[]{};
        for (int i = 0; i < shells.size(); ++i) {
            LinearRing iRing = (LinearRing)shells.get(i);
            Envelope iEnv = iRing.getEnvelopeInternal();
            Coordinate[] coordList = iRing.getCoordinates();
            for (int j = 0; j < shells.size(); ++j) {
                Polygon jPoly;
                Polygon iPoly;
                if (i == j) continue;
                LinearRing jRing = (LinearRing)shells.get(j);
                Envelope jEnv = jRing.getEnvelopeInternal();
                Coordinate jPt = jRing.getCoordinateN(0);
                Coordinate jPt2 = jRing.getCoordinateN(1);
                if (!iEnv.contains(jEnv) || !CGAlgorithms.isPointInRing((Coordinate)jPt, (Coordinate[])coordList) || !CGAlgorithms.isPointInRing((Coordinate)jPt2, (Coordinate[])coordList) || holesCW.contains(jRing) || !(iPoly = this.factory.createPolygon(iRing, noHole)).contains((Geometry)(jPoly = this.factory.createPolygon(jRing, noHole)))) continue;
                holesCW.add(jRing);
            }
        }
        return holesCW;
    }

    private LinearRing reverseRing(LinearRing lr) {
        int numPoints = lr.getNumPoints();
        Coordinate[] newCoords = new Coordinate[numPoints];
        for (int t = 0; t < numPoints; ++t) {
            newCoords[t] = lr.getCoordinateN(numPoints - t - 1);
        }
        return this.factory.createLinearRing(newCoords);
    }

    private LineString[] getLines(Geometry geom_src) {
        return (LineString[])this.getLines(geom_src, false);
    }

    private LinearRing[] getRings(Geometry geom_src) {
        return (LinearRing[])this.getLines(geom_src, true);
    }

    private Geometry[] getLines(Geometry geom_src, boolean asRings) {
        ArrayList<Object> linescol = new ArrayList<Object>();
        for (int i = 0; i < geom_src.getNumGeometries(); ++i) {
            Geometry g = geom_src.getGeometryN(i);
            if (g.getNumGeometries() > 1) {
                linescol.addAll(Arrays.asList(this.getLines(g, asRings)));
                continue;
            }
            if (g.getGeometryType().toLowerCase().endsWith("polygon")) {
                LinearComponentExtracter.getLines((Geometry)g, linescol, (!asRings ? 1 : 0) != 0);
                continue;
            }
            if (asRings) {
                linescol.add(this.factory.createLinearRing(g.getCoordinates()));
                continue;
            }
            linescol.add(this.factory.createLineString(g.getCoordinates()));
        }
        return asRings ? GeometryFactory.toLinearRingArray(linescol) : GeometryFactory.toLineStringArray(linescol);
    }

    private boolean okCancel(String title, String message) {
        JPanel panel = new JPanel();
        JLabel label = new JLabel("<html> " + message + " </html>");
        Font xx = label.getFont();
        int fontHeight = label.getFontMetrics(xx).getHeight();
        int stringWidth = label.getFontMetrics(xx).stringWidth(label.getText());
        int linesCount = (int)Math.floor(stringWidth / 300);
        linesCount = Math.max(1, linesCount + 2);
        label.setPreferredSize(new Dimension(300, fontHeight * linesCount));
        FlowLayout f = new FlowLayout(1, 10, 10);
        panel.setLayout(f);
        panel.add(label);
        OKCancelDialog dlg = new OKCancelDialog(this.wbc.getWorkbench().getFrame(), title, true, (Component)panel, new OKCancelDialog.Validator(){

            public String validateInput(Component component) {
                return null;
            }
        });
        dlg.setVisible(true);
        return dlg.wasOKPressed();
    }

    private class LineFilter
    implements GeometryComponentFilter {
        private Collection lines;

        public LineFilter(List lines) {
            this.lines = lines;
        }

        public void filter(Geometry geom) {
            ArrayList linescol = new ArrayList();
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                LineString line = geom.getFactory().createLineString(geom.getGeometryN(i).getCoordinates());
                this.lines.add(line);
            }
        }
    }

    private class RemoveClosing
    extends GeometryEditor.CoordinateOperation {
        private RemoveClosing() {
        }

        public Coordinate[] edit(Coordinate[] coordinates, Geometry geometry) {
            if (coordinates.length < 2) {
                return coordinates;
            }
            Coordinate first = coordinates[0];
            Coordinate last = coordinates[coordinates.length - 1];
            while (first.equals((Object)last)) {
                coordinates = this.removeLast(coordinates);
                first = coordinates[0];
                last = coordinates[coordinates.length - 1];
            }
            return coordinates;
        }

        private Coordinate[] removeLast(Coordinate[] coordinates) {
            Coordinate[] coordinates_new = new Coordinate[coordinates.length - 1];
            for (int i = 0; i < coordinates.length - 1; ++i) {
                coordinates_new[i] = coordinates[i];
            }
            return coordinates_new;
        }
    }

    private class CloseRing
    extends GeometryEditor.CoordinateOperation {
        private CloseRing() {
        }

        public Coordinate[] edit(Coordinate[] coordinates, Geometry geometry) {
            Coordinate first = coordinates[0];
            Coordinate last = coordinates[coordinates.length - 1];
            if (first.equals((Object)last)) {
                return coordinates;
            }
            Coordinate[] coordinates_new = new Coordinate[coordinates.length + 1];
            for (int i = 0; i < coordinates.length; ++i) {
                coordinates_new[i] = coordinates[i];
            }
            coordinates_new[coordinates_new.length - 1] = coordinates[0];
            return coordinates_new;
        }
    }
}

