/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.wms;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.wms.Capabilities;
import com.vividsolutions.wms.MapRequest;
import com.vividsolutions.wms.Parser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JOptionPane;
import net.iharder.Base64;

public class WMService {
    public static final String WMS_1_0_0 = "1.0.0";
    public static final String WMS_1_1_0 = "1.1.0";
    public static final String WMS_1_1_1 = "1.1.1";
    private String serverUrl;
    private String wmsVersion = "1.0.0";
    private Capabilities cap;

    public WMService(String serverUrl, String wmsVersion) {
        this.serverUrl = serverUrl;
        this.wmsVersion = wmsVersion;
        this.cap = null;
    }

    public WMService(String serverUrl) {
        this.serverUrl = serverUrl;
        this.cap = null;
    }

    public void initialize() throws IOException {
        this.initialize(false);
    }

    public void initialize(boolean alertDifferingURL) throws IOException {
        String req = "request=capabilities&WMTVER=1.0";
        if (WMS_1_1_0.equals(this.wmsVersion)) {
            req = "SERVICE=WMS&VERSION=1.1.0&REQUEST=GetCapabilities";
        } else if (WMS_1_1_1.equals(this.wmsVersion)) {
            req = "SERVICE=WMS&VERSION=1.1.1&REQUEST=GetCapabilities";
        }
        try {
            String url2;
            String requestUrlString = this.serverUrl + req;
            URL requestUrl = new URL(requestUrlString);
            URLConnection con = requestUrl.openConnection();
            if (requestUrl.getUserInfo() != null) {
                con.setRequestProperty("Authorization", "Basic " + Base64.encodeBytes(requestUrl.getUserInfo().getBytes()));
            }
            Parser p = new Parser();
            this.cap = p.parseCapabilities(this, con.getInputStream());
            String url1 = this.cap.getService().getServerUrl();
            if (!url1.equals(url2 = this.cap.getGetMapURL())) {
                if (!new URL(url1).equals(new URL(url2)) && alertDifferingURL) {
                    int resp = JOptionPane.showConfirmDialog(null, I18N.getMessage("com.vididsolutions.wms.WMService.Other-GetMap-URL-Found", new Object[]{url2}), null, 0);
                    if (resp == 1) {
                        this.cap.setGetMapURL(url1);
                    }
                } else {
                    this.cap.setGetMapURL(url1);
                }
            }
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(null, I18N.getMessage("com.vividsolutions.wms.WMService.WMS-Not-Found", new Object[]{e.getLocalizedMessage()}), I18N.get("com.vividsolutions.wms.WMService.Error"), 0);
            throw e;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, I18N.getMessage("com.vividsolutions.wms.WMService.WMS-IO-Error", new Object[]{e.getClass().getSimpleName(), e.getLocalizedMessage()}), I18N.get("com.vividsolutions.wms.WMService.Error"), 0);
            throw e;
        }
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getTitle() {
        return this.cap.getTitle();
    }

    public Capabilities getCapabilities() {
        return this.cap;
    }

    public MapRequest createMapRequest() {
        MapRequest mr = new MapRequest(this);
        mr.setVersion(this.wmsVersion);
        return mr;
    }

    public String getVersion() {
        return this.wmsVersion;
    }
}

