/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.zoom;

import com.vividsolutions.jump.util.MathUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.zoom.AbstractZoomTool;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class ZoomTool
extends AbstractZoomTool {
    public static final String ZOOM_TOOL_NAME = "Zoom In/Out";

    public ZoomTool() {
        this.setColor(Color.black);
    }

    public Icon getIcon() {
        return IconLoader.icon("Magnify.gif");
    }

    public String getName() {
        return ZOOM_TOOL_NAME;
    }

    public Cursor getCursor() {
        return ZoomTool.createCursor(IconLoader.icon("MagnifyCursor.gif").getImage());
    }

    protected void gestureFinished() throws NoninvertibleTransformException {
        this.reportNothingToUndoYet();
        double minX = Math.min(this.getViewSource().getX(), this.getViewDestination().getX());
        double maxX = Math.max(this.getViewSource().getX(), this.getViewDestination().getX());
        double minY = Math.min(this.getViewSource().getY(), this.getViewDestination().getY());
        double maxY = Math.max(this.getViewSource().getY(), this.getViewDestination().getY());
        double widthOfNewViewAsPerceivedByOldView = maxX - minX;
        double heightOfNewViewAsPerceivedByOldView = maxY - minY;
        if (widthOfNewViewAsPerceivedByOldView == 0.0 && heightOfNewViewAsPerceivedByOldView == 0.0) {
            return;
        }
        if (widthOfNewViewAsPerceivedByOldView < 4.0 && heightOfNewViewAsPerceivedByOldView < 4.0) {
            this.zoomAt(new Point2D.Double(MathUtil.avg(minX, maxX), MathUtil.avg(minY, maxY)), 2.0);
            return;
        }
        Point2D.Double centreOfNewViewAsPerceivedByOldView = new Point2D.Double(minX + widthOfNewViewAsPerceivedByOldView / 2.0, minY + heightOfNewViewAsPerceivedByOldView / 2.0);
        this.getPanel().getViewport().zoom(centreOfNewViewAsPerceivedByOldView, widthOfNewViewAsPerceivedByOldView, heightOfNewViewAsPerceivedByOldView);
    }

    public void mouseClicked(MouseEvent e) {
        try {
            double zoomFactor = SwingUtilities.isRightMouseButton(e) ? 0.5 : 2.0;
            this.zoomAt(e.getPoint(), zoomFactor);
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    public void mousePressed(MouseEvent e) {
        try {
            if (SwingUtilities.isLeftMouseButton(e)) {
                super.mousePressed(e);
            }
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    private void zoomAt(Point2D p, double zoomFactor) throws NoninvertibleTransformException {
        this.zoomAt(p, zoomFactor, this.getAnimatingZoom());
    }

    public boolean isRightMouseButtonUsed() {
        return true;
    }

    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
    }

    public void activate(LayerViewPanel layerViewPanel) {
        super.activate(layerViewPanel);
    }

    public void deactivate() {
        super.deactivate();
    }

    public void mouseEntered(MouseEvent e) {
        super.mouseEntered(e);
    }

    public void mouseExited(MouseEvent e) {
        super.mouseExited(e);
    }

    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
    }
}

