/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.LabelStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import com.vividsolutions.jump.workbench.ui.style.CopyStylesPlugIn;
import java.util.ArrayList;
import javax.swing.ImageIcon;

public class PasteStylesPlugIn
extends AbstractPlugIn {
    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(1));
    }

    public String getName() {
        return I18N.get("ui.style.PasteStylesPlugIn.paste-styles");
    }

    public ImageIcon getIcon() {
        return IconLoader.icon("Palette_out.gif");
    }

    public boolean execute(PlugInContext context) throws Exception {
        if (CopyStylesPlugIn.stylesBuffer == null) {
            return false;
        }
        Layer[] selectedLayers = context.getSelectedLayers();
        for (int i = 0; i < selectedLayers.length; ++i) {
            this.validateStyleForLayer(selectedLayers[i]);
            this.pasteStyles(selectedLayers[i]);
        }
        return true;
    }

    private void pasteStyles(Layer layer) {
        layer.setStyles(CopyStylesPlugIn.stylesBuffer);
    }

    private void validateStyleForLayer(Layer layer) {
        String attribName2 = "";
        try {
            FeatureSchema featureSchema = layer.getFeatureCollectionWrapper().getFeatureSchema();
            ArrayList<String> attribList = new ArrayList<String>();
            for (Style style : CopyStylesPlugIn.stylesBuffer) {
                ColorThemingStyle ctStyle;
                if (style instanceof LabelStyle) {
                    LabelStyle labelStyle = (LabelStyle)style;
                    if (!labelStyle.isEnabled()) continue;
                    attribName2 = labelStyle.getAttribute();
                    if (attribName2 != "") {
                        attribList.add(attribName2);
                    }
                    if ((attribName2 = labelStyle.getAngleAttribute()) != "") {
                        attribList.add(attribName2);
                    }
                    if ((attribName2 = labelStyle.getHeightAttribute()) == "") continue;
                    attribList.add(attribName2);
                    continue;
                }
                if (!(style instanceof ColorThemingStyle) || !(ctStyle = (ColorThemingStyle)style).isEnabled() || (attribName2 = ctStyle.getAttributeName()) == "") continue;
                attribList.add(attribName2);
            }
            for (String attribName2 : attribList) {
                featureSchema.getAttributeIndex(attribName2);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Attribute " + attribName2 + " not found on Layer: " + layer.getName());
        }
    }
}

