/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.imagery;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.Block;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.util.OrderedMap;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.imagery.ImageryLayerDataset;
import com.vividsolutions.jump.workbench.imagery.ReferencedImage;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageFactory;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageStyle;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class ImageFeatureCreator {
    public Collection getImages(PlugInContext context, Layer layer) {
        String LAST_DIRECTORY_KEY = this.getClass().getName() + " - LAST DIRECTORY";
        String LAST_FILE_FILTER_DESCRIPTION_KEY = this.getClass().getName() + " - LAST FILE FILTER DESCRIPTION";
        Blackboard blackboard = PersistentBlackboardPlugIn.get(context.getWorkbenchContext());
        JFileChooser fileChooser = GUIUtil.createJFileChooserWithExistenceChecking();
        fileChooser.setCurrentDirectory(new File((String)blackboard.get(LAST_DIRECTORY_KEY, fileChooser.getCurrentDirectory().getPath())));
        GUIUtil.removeChoosableFileFilters(fileChooser);
        OrderedMap fileFilterToReferencedImageFactoryMap = this.getFileFilterToReferencedImageFactoryMap(this.insertCompositeReferencedImageFactory(context.getWorkbenchContext().getRegistry().getEntries(ReferencedImageFactory.REGISTRY_CLASSIFICATION)));
        for (FileFilter fileFilter : fileFilterToReferencedImageFactoryMap.keyList()) {
            fileChooser.addChoosableFileFilter(fileFilter);
        }
        fileChooser.setFileFilter((FileFilter)fileFilterToReferencedImageFactoryMap.keyList().get(0));
        for (FileFilter fileFilter : Arrays.asList(fileChooser.getChoosableFileFilters())) {
            if (!fileFilter.getDescription().equals(blackboard.get(LAST_FILE_FILTER_DESCRIPTION_KEY, ""))) continue;
            fileChooser.setFileFilter(fileFilter);
            break;
        }
        fileChooser.setMultiSelectionEnabled(true);
        Collection selectedFeatures = null;
        if (0 == fileChooser.showOpenDialog(context.getWorkbenchFrame())) {
            blackboard.put(LAST_DIRECTORY_KEY, fileChooser.getCurrentDirectory().getPath());
            blackboard.put(LAST_FILE_FILTER_DESCRIPTION_KEY, fileChooser.getFileFilter().getDescription());
            File[] selectedFiles = fileChooser.getSelectedFiles();
            if (selectedFiles != null && selectedFiles.length > 0) {
                ReferencedImageFactory rif = (ReferencedImageFactory)fileFilterToReferencedImageFactoryMap.get(fileChooser.getFileFilter());
                if (rif.isAvailable(context.getWorkbenchContext())) {
                    selectedFeatures = this.createFeatures(rif, selectedFiles, this.getImageryLayerDataset(layer));
                } else {
                    Object[] options = new Object[]{"OK"};
                    JOptionPane.showOptionDialog(null, I18N.get("ui.plugin.imagery.ImageFeatureCreator.The-driver-for") + " " + rif.getTypeName() + " " + I18N.get("ui.plugin.imagery.ImageFeatureCreator.is-not-available-Please-check-your-configuration"), I18N.get("ui.plugin.imagery.ImageFeatureCreator.Warning"), -1, 2, null, options, options[0]);
                }
            }
        }
        return selectedFeatures;
    }

    public void setLayerSelectability(Layer layer) {
        boolean selectable = false;
        List features = layer.getFeatureCollectionWrapper().getFeatures();
        if (features.size() == 1) {
            Feature f = (Feature)features.iterator().next();
            String imageFilePath = (String)f.getAttribute("IMAGEFILE");
            String factoryClassPath = (String)f.getAttribute("IMAGEFACT");
            if (imageFilePath != null && factoryClassPath != null) {
                try {
                    ReferencedImageFactory imageFactory = (ReferencedImageFactory)Class.forName(factoryClassPath).newInstance();
                    selectable = imageFactory.isEditableImage(imageFilePath);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        layer.setSelectable(selectable);
        layer.setEditable(selectable);
        layer.setReadonly(!selectable);
    }

    private ReferencedImageFactory getReferencedImageFactoryProper(ReferencedImageFactory factory, File file) {
        return factory instanceof CompositeReferencedImageFactory ? ((CompositeReferencedImageFactory)factory).referencedImageFactory(FileUtil.getExtension(file)) : factory;
    }

    private ImageryLayerDataset getImageryLayerDataset(Layer layer) {
        ReferencedImageStyle irs = (ReferencedImageStyle)layer.getStyle(ReferencedImageStyle.class);
        return irs.getImageryLayerDataset();
    }

    private Collection createFeatures(final ReferencedImageFactory referencedImageFactory, File[] files, final ImageryLayerDataset imageryLayerDataset) {
        return CollectionUtil.collect(Arrays.asList(files), new Block(){

            public Object yield(Object file) {
                return ImageFeatureCreator.this.createFeature(referencedImageFactory, (File)file, imageryLayerDataset);
            }
        });
    }

    private Feature createFeature(ReferencedImageFactory referencedImageFactory, File file, ImageryLayerDataset imageryLayerDataset) {
        BasicFeature feature = new BasicFeature(ImageryLayerDataset.getSchema());
        feature.setAttribute("IMAGEFILE", (Object)file.getPath());
        feature.setAttribute("IMAGEFORMAT", (Object)this.getReferencedImageFactoryProper(referencedImageFactory, file).getTypeName());
        feature.setAttribute("IMAGEFACT", (Object)this.getReferencedImageFactoryProper(referencedImageFactory, file).getClass().getName());
        feature.setGeometry((Geometry)new GeometryFactory().createPoint((Coordinate)null));
        imageryLayerDataset.createImage(feature);
        return feature;
    }

    private OrderedMap getFileFilterToReferencedImageFactoryMap(Collection referencedImageFactories) {
        OrderedMap fileFilterToReferencedImageFactoryMap = new OrderedMap();
        for (ReferencedImageFactory referencedImageFactory : referencedImageFactories) {
            fileFilterToReferencedImageFactoryMap.put(this.createFileFilter(referencedImageFactory), referencedImageFactory);
        }
        return fileFilterToReferencedImageFactoryMap;
    }

    private FileFilter createFileFilter(ReferencedImageFactory referencedImageFactory) {
        return GUIUtil.createFileFilter((referencedImageFactory.getTypeName().equals(referencedImageFactory.getDescription()) ? "" : referencedImageFactory.getTypeName() + " - ") + referencedImageFactory.getDescription(), referencedImageFactory.getExtensions());
    }

    private Collection insertCompositeReferencedImageFactory(List referencedImageFactories) {
        return CollectionUtil.concatenate(Arrays.asList(Collections.singleton(new CompositeReferencedImageFactory(referencedImageFactories)), referencedImageFactories));
    }

    private static class CompositeReferencedImageFactory
    implements ReferencedImageFactory {
        private List referencedImageFactories = new ArrayList();

        public CompositeReferencedImageFactory(List referencedImageFactories) {
            for (ReferencedImageFactory referencedImageFactory : referencedImageFactories) {
                if (!referencedImageFactory.isAvailable(null)) continue;
                this.referencedImageFactories.add(referencedImageFactory);
            }
        }

        public String getTypeName() {
            return I18N.get("ui.plugin.imagery.ImageFeatureCreator.All-Formats");
        }

        public boolean isEditableImage(String location) {
            return false;
        }

        public String getDescription() {
            return this.getTypeName();
        }

        public String[] getExtensions() {
            return CollectionUtil.concatenate(CollectionUtil.collect(this.referencedImageFactories, new Block(){

                public Object yield(Object referencedImageFactory) {
                    return Arrays.asList(((ReferencedImageFactory)referencedImageFactory).getExtensions());
                }
            })).toArray(new String[0]);
        }

        public ReferencedImageFactory referencedImageFactory(String extension) {
            for (ReferencedImageFactory referencedImageFactory : this.referencedImageFactories) {
                if (!Arrays.asList(referencedImageFactory.getExtensions()).contains(extension.toLowerCase())) continue;
                return referencedImageFactory;
            }
            Assert.shouldNeverReachHere();
            return null;
        }

        public ReferencedImage createImage(String location) {
            throw new UnsupportedOperationException();
        }

        public boolean isAvailable(WorkbenchContext context) {
            return true;
        }
    }
}

