/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.datastore;

import com.vividsolutions.jump.datastore.FilterQuery;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.datasource.Connection;
import com.vividsolutions.jump.io.datasource.DataSource;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.util.LangUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.datastore.ConnectionManager;
import com.vividsolutions.jump.workbench.model.cache.CachingFeatureCollection;
import com.vividsolutions.jump.workbench.model.cache.DynamicFeatureCollection;
import com.vividsolutions.jump.workbench.ui.plugin.WorkbenchContextReference;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.PasswordPrompter;
import java.util.ArrayList;
import java.util.Collection;

public class DataStoreDataSource
extends DataSource
implements WorkbenchContextReference {
    public static final String DATASET_NAME_KEY = "Dataset Name";
    public static final String GEOMETRY_ATTRIBUTE_NAME_KEY = "Geometry Attribute Name";
    public static final String WHERE_CLAUSE_KEY = "Where Clause";
    public static final String CACHING_KEY = "Caching";
    public static final String CONNECTION_DESCRIPTOR_KEY = "Connection Descriptor";
    private WorkbenchContext context;

    public DataStoreDataSource() {
    }

    public DataStoreDataSource(String datasetName, String geometryAttributeName, String whereClause, ConnectionDescriptor connectionDescriptor, boolean caching, WorkbenchContext context) {
        this.setProperties(CollectionUtil.createMap(new Object[]{DATASET_NAME_KEY, datasetName, GEOMETRY_ATTRIBUTE_NAME_KEY, geometryAttributeName, WHERE_CLAUSE_KEY, whereClause, CONNECTION_DESCRIPTOR_KEY, connectionDescriptor, CACHING_KEY, caching}));
        this.setWorkbenchContext(context);
    }

    public boolean isWritable() {
        return false;
    }

    public Connection getConnection() {
        return new Connection(){

            public FeatureCollection executeQuery(String query, Collection exceptions, TaskMonitor monitor) {
                try {
                    return DataStoreDataSource.this.createFeatureCollection();
                }
                catch (Exception e) {
                    exceptions.add(e);
                    return null;
                }
            }

            public FeatureCollection executeQuery(String query, TaskMonitor monitor) throws Exception {
                ArrayList exceptions = new ArrayList();
                FeatureCollection featureCollection = this.executeQuery(query, exceptions, monitor);
                if (!exceptions.isEmpty()) {
                    throw (Exception)exceptions.iterator().next();
                }
                return featureCollection;
            }

            public void executeUpdate(String query, FeatureCollection featureCollection, TaskMonitor monitor) throws Exception {
                throw new UnsupportedOperationException();
            }

            public void close() {
            }
        };
    }

    private FeatureCollection createFeatureCollection() {
        FilterQuery query = new FilterQuery();
        query.setDatasetName((String)this.getProperties().get(DATASET_NAME_KEY));
        query.setGeometryAttributeName((String)this.getProperties().get(GEOMETRY_ATTRIBUTE_NAME_KEY));
        if (((String)this.getProperties().get(WHERE_CLAUSE_KEY)).length() > 0) {
            query.setCondition((String)this.getProperties().get(WHERE_CLAUSE_KEY));
        }
        return new CachingFeatureCollection(new DynamicFeatureCollection((ConnectionDescriptor)this.getProperties().get(CONNECTION_DESCRIPTOR_KEY), ConnectionManager.instance(this.context), query)).setCachingByEnvelope((Boolean)LangUtil.ifNull(this.getProperties().get(CACHING_KEY), Boolean.TRUE));
    }

    public void setWorkbenchContext(WorkbenchContext context) {
        this.context = context;
        try {
            new PasswordPrompter().getOpenConnection(ConnectionManager.instance(context), (ConnectionDescriptor)this.getProperties().get(CONNECTION_DESCRIPTOR_KEY), context.getWorkbench().getFrame());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

