/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.clipboard;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import java.util.Iterator;
import org.openjump.core.rasterimage.RasterImageLayer;

public abstract class LayerableClipboardPlugIn
extends AbstractPlugIn {
    protected Layerable cloneLayerable(Layerable layerable) {
        if (layerable instanceof Layer) {
            return this.cloneLayer((Layer)layerable);
        }
        if (layerable instanceof WMSLayer) {
            try {
                return (Layerable)((WMSLayer)layerable).clone();
            }
            catch (CloneNotSupportedException e) {
                Assert.shouldNeverReachHere();
            }
        }
        if (layerable instanceof RasterImageLayer) {
            try {
                return (Layerable)((RasterImageLayer)layerable).clone();
            }
            catch (CloneNotSupportedException e) {
                Assert.shouldNeverReachHere();
            }
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    protected Layer cloneLayer(Layer layer) {
        LayerManager dummyLayerManager = new LayerManager();
        dummyLayerManager.setFiringEvents(false);
        Layer clone = new Layer();
        clone.setLayerManager(dummyLayerManager);
        clone.setStyles(layer.cloneStyles());
        clone.setName(layer.getName());
        clone.setFeatureCollection(this.cloneFeatureCollection(layer.getFeatureCollectionWrapper()));
        return clone;
    }

    private FeatureCollection cloneFeatureCollection(FeatureCollection featureCollection) {
        FeatureDataset d = new FeatureDataset(featureCollection.getFeatureSchema());
        Iterator i = featureCollection.iterator();
        while (i.hasNext()) {
            Feature f = (Feature)i.next();
            d.add((Feature)f.clone());
        }
        return d;
    }
}

