/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPlugIn;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;

public class EditablePlugIn
extends AbstractPlugIn {
    private EditingPlugIn editingPlugIn;
    public static final ImageIcon ICON = IconLoader.icon("edit.gif");

    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        boolean makeEditable = !context.getSelectedLayer(0).isEditable();
        for (Layer selectedLayer : Arrays.asList(context.getSelectedLayers())) {
            selectedLayer.setEditable(makeEditable);
        }
        if (makeEditable && !this.editingPlugIn.getToolbox(context.getWorkbenchContext()).isVisible()) {
            this.editingPlugIn.execute(context);
        }
        return true;
    }

    public EnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        MultiEnableCheck mec = new MultiEnableCheck();
        mec.add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck());
        mec.add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(1));
        mec.add(new EnableCheck(){

            public String check(JComponent component) {
                ((JCheckBoxMenuItem)component).setSelected(workbenchContext.createPlugInContext().getSelectedLayer(0).isEditable());
                return null;
            }
        });
        mec.add(new EnableCheck(){

            public String check(JComponent component) {
                String errMsg = null;
                if (workbenchContext.createPlugInContext().getSelectedLayer(0).isReadonly()) {
                    errMsg = I18N.get("ui.plugin.EditablePlugIn.The-selected-layer-cannot-be-made-editable");
                }
                return errMsg;
            }
        });
        return mec;
    }

    public EditablePlugIn(EditingPlugIn editingPlugIn) {
        this.editingPlugIn = editingPlugIn;
    }
}

