/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.cursortool.CoordinateListMetrics;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.MultiClickTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.geom.NoninvertibleTransformException;
import javax.swing.Icon;

public class DrawLineStringTool
extends MultiClickTool {
    private FeatureDrawingUtil featureDrawingUtil;

    private DrawLineStringTool(FeatureDrawingUtil featureDrawingUtil) {
        this.featureDrawingUtil = featureDrawingUtil;
        this.setMetricsDisplay(new CoordinateListMetrics());
    }

    public static CursorTool create(LayerNamePanelProxy layerNamePanelProxy) {
        FeatureDrawingUtil featureDrawingUtil = new FeatureDrawingUtil(layerNamePanelProxy);
        return featureDrawingUtil.prepare(new DrawLineStringTool(featureDrawingUtil), true);
    }

    public String getName() {
        return I18N.get("ui.cursortool.editing.DrawLineString.draw-linestring");
    }

    public Icon getIcon() {
        return IconLoader.icon("DrawLineString.gif");
    }

    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        if (!this.checkLineString()) {
            return;
        }
        this.featureDrawingUtil.drawLineString(this.getLineString(), this.isRollingBackInvalidEdits(), this, this.getPanel());
    }

    protected LineString getLineString() throws NoninvertibleTransformException {
        return new GeometryFactory().createLineString(this.toArray(this.getCoordinates()));
    }

    protected boolean checkLineString() throws NoninvertibleTransformException {
        if (this.getCoordinates().size() < 2) {
            this.getPanel().getContext().warnUser(I18N.get("ui.cursortool.editing.DrawLineString.the-linestring-must-have-at-least-2-points"));
            return false;
        }
        IsValidOp isValidOp = new IsValidOp((Geometry)this.getLineString());
        if (!isValidOp.isValid()) {
            this.getPanel().getContext().warnUser(isValidOp.getValidationError().getMessage());
            if (this.getWorkbench().getBlackboard().get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false)) {
                return false;
            }
        }
        return true;
    }
}

