/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.plugin;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.Configuration;
import com.vividsolutions.jump.workbench.plugin.Extension;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;

public class PlugInManager {
    private static Logger LOG = Logger.getLogger(PlugInManager.class);
    private TaskMonitor monitor;
    private WorkbenchContext context;
    private Collection configurations = new ArrayList();
    private File plugInDirectory;
    private ClassLoader classLoader;

    public PlugInManager(WorkbenchContext context, File plugInDirectory, TaskMonitor monitor) throws Exception {
        this.monitor = monitor;
        Assert.isTrue((plugInDirectory == null || plugInDirectory.isDirectory() ? 1 : 0) != 0);
        this.classLoader = plugInDirectory != null ? new URLClassLoader(this.toURLs(this.findFilesRecursively(plugInDirectory).toArray(new File[0]))) : this.getClass().getClassLoader();
        I18N.setClassLoader(this.classLoader);
        this.context = context;
        this.configurations.addAll(plugInDirectory != null ? this.findConfigurations(plugInDirectory) : new ArrayList());
        this.configurations.addAll(this.findConfigurations(context.getWorkbench().getProperties().getConfigurationClasses()));
        this.plugInDirectory = plugInDirectory;
    }

    public void load() throws Exception {
        this.loadPlugInClasses(this.context.getWorkbench().getProperties().getPlugInClasses(this.getClassLoader()));
        this.loadConfigurations();
    }

    private void loadConfigurations() throws Exception {
        for (Configuration configuration : this.configurations) {
            configuration.configure(new PlugInContext(this.context, null, null, null, null));
        }
    }

    public static String name(Configuration configuration) {
        if (configuration instanceof Extension) {
            return ((Extension)configuration).getName();
        }
        return StringUtil.toFriendlyName(configuration.getClass().getName(), "Configuration") + " (" + configuration.getClass().getPackage().getName() + ")";
    }

    public static String version(Configuration configuration) {
        if (configuration instanceof Extension) {
            return ((Extension)configuration).getVersion();
        }
        return "";
    }

    private Collection findConfigurations(List classes) throws Exception {
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        for (Class c : classes) {
            if (!Configuration.class.isAssignableFrom(c)) continue;
            LOG.debug((Object)("Loading " + c.getName()));
            System.out.println("Loading " + c.getName());
            Configuration configuration = (Configuration)c.newInstance();
            configurations.add(configuration);
            this.monitor.report("Loading " + PlugInManager.name(configuration) + " " + PlugInManager.version(configuration));
        }
        return configurations;
    }

    private void loadPlugInClasses(List plugInClasses) throws Exception {
        for (Class plugInClass : plugInClasses) {
            PlugIn plugIn = (PlugIn)plugInClass.newInstance();
            plugIn.initialize(new PlugInContext(this.context, null, null, null, null));
        }
    }

    private Collection findFilesRecursively(File directory) {
        Assert.isTrue((boolean)directory.isDirectory());
        ArrayList<File> files = new ArrayList<File>();
        for (File file : Arrays.asList(directory.listFiles())) {
            if (file.isDirectory()) {
                files.addAll(this.findFilesRecursively(file));
            }
            if (!file.isFile()) continue;
            files.add(file);
        }
        return files;
    }

    private Collection findConfigurations(File plugInDirectory) throws Exception {
        ArrayList configurations = new ArrayList();
        for (File file : this.findFilesRecursively(plugInDirectory)) {
            try {
                configurations.addAll(this.findConfigurations(this.classes(new ZipFile(file), this.classLoader)));
            }
            catch (ZipException e) {}
        }
        return configurations;
    }

    private URL[] toURLs(File[] files) {
        URL[] urls = new URL[files.length];
        for (int i = 0; i < files.length; ++i) {
            try {
                urls[i] = new URL("jar:file:" + files[i].getPath() + "!/");
                continue;
            }
            catch (MalformedURLException e) {
                Assert.shouldNeverReachHere((String)e.toString());
            }
        }
        return urls;
    }

    private List classes(ZipFile zipFile, ClassLoader classLoader) {
        ArrayList<Class> classes = new ArrayList<Class>();
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        while (e.hasMoreElements()) {
            Class c;
            ZipEntry entry = e.nextElement();
            if (!entry.getName().endsWith("Extension.class") && !entry.getName().endsWith("Configuration.class") || (c = this.toClass(entry, classLoader)) == null) continue;
            classes.add(c);
        }
        return classes;
    }

    private Class toClass(ZipEntry entry, ClassLoader classLoader) {
        Class<?> candidate;
        if (entry.isDirectory()) {
            return null;
        }
        if (!entry.getName().endsWith(".class")) {
            return null;
        }
        if (entry.getName().indexOf("$") != -1) {
            return null;
        }
        String className = entry.getName();
        className = className.substring(0, className.length() - ".class".length());
        className = StringUtil.replaceAll(className, "/", ".");
        try {
            candidate = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            Assert.shouldNeverReachHere((String)("Class not found: " + className + ". Refine class name algorithm."));
            return null;
        }
        catch (Throwable t) {
            LOG.error((Object)("Throwable encountered loading " + className + ":"));
            t.printStackTrace(System.out);
            return null;
        }
        return candidate;
    }

    public Collection getConfigurations() {
        return Collections.unmodifiableCollection(this.configurations);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public File getPlugInDirectory() {
        return this.plugInDirectory;
    }
}

