/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.coordsys.CoordinateSystem;
import com.vividsolutions.jump.coordsys.Reprojector;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.CategoryEventType;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.FenceLayerFinder;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.model.UndoableEditReceiver;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelProxy;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.style.AbstractPalettePanel;
import java.awt.Color;
import java.awt.geom.Line2D;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JInternalFrame;

public class LayerManager {
    private static int layerManagerCount = 0;
    private UndoableEditReceiver undoableEditReceiver = new UndoableEditReceiver();
    private CoordinateSystem coordinateSystem = CoordinateSystem.UNSPECIFIED;
    private ArrayList categories = new ArrayList();
    private ArrayList layerReferencesToDispose = new ArrayList();
    private boolean firingEvents = true;
    private ArrayList layerListeners = new ArrayList();
    private Iterator firstColors;
    private Blackboard blackboard = new Blackboard();
    private Task task;

    public LayerManager() {
        this.firstColors = this.firstColors().iterator();
        ++layerManagerCount;
    }

    public LayerManager(Task task) {
        this();
        this.task = task;
    }

    public UndoableEditReceiver getUndoableEditReceiver() {
        return this.undoableEditReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deferFiringEvents(Runnable r) {
        boolean firingEvents = this.isFiringEvents();
        this.setFiringEvents(false);
        try {
            r.run();
        }
        finally {
            this.setFiringEvents(firingEvents);
        }
    }

    private Collection firstColors() {
        ArrayList<Color> firstColors = new ArrayList<Color>();
        for (BasicStyle basicStyle : AbstractPalettePanel.basicStyles()) {
            if (!basicStyle.isRenderingFill()) continue;
            firstColors.add(basicStyle.getFillColor());
        }
        return firstColors;
    }

    public Color generateLayerFillColor() {
        Color color = this.firstColors.hasNext() ? (Color)this.firstColors.next() : new Color((int)Math.floor(Math.random() * 256.0), (int)Math.floor(Math.random() * 256.0), (int)Math.floor(Math.random() * 256.0));
        color = new Color(color.getRed(), color.getGreen(), color.getBlue());
        return color;
    }

    public Layer addLayer(String categoryName, Layer layer) {
        this.addLayerable(categoryName, layer);
        return layer;
    }

    public void addLayerable(String categoryName, Layerable layerable) {
        if (layerable instanceof Layer) {
            if (this.size() == 0 && this.getCoordinateSystem() == CoordinateSystem.UNSPECIFIED) {
                this.setCoordinateSystem(((Layer)layerable).getFeatureCollectionWrapper().getFeatureSchema().getCoordinateSystem());
            } else {
                this.reproject((Layer)layerable, this.coordinateSystem);
            }
            this.layerReferencesToDispose.add(new WeakReference<Layerable>(layerable));
        }
        this.addCategory(categoryName);
        Category cat = this.getCategory(categoryName);
        cat.add(0, layerable);
        this.fireLayerChanged(layerable, LayerEventType.METADATA_CHANGED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reproject(Layer layer, CoordinateSystem coordinateSystem) {
        try {
            Assert.isTrue((this.indexOf(layer) == -1 ? 1 : 0) != 0, (String)"If the LayerManager contained this layer, we'd need to be concerned about rolling back on an error [Jon Aquino]");
            if (!Reprojector.instance().wouldChangeValues(layer.getFeatureCollectionWrapper().getFeatureSchema().getCoordinateSystem(), coordinateSystem)) {
                return;
            }
            Iterator i = layer.getFeatureCollectionWrapper().iterator();
            while (i.hasNext()) {
                Feature feature = (Feature)i.next();
                Reprojector.instance().reproject(feature.getGeometry(), layer.getFeatureCollectionWrapper().getFeatureSchema().getCoordinateSystem(), coordinateSystem);
            }
        }
        finally {
            layer.getFeatureCollectionWrapper().getFeatureSchema().setCoordinateSystem(coordinateSystem);
        }
    }

    public void addCategory(String categoryName) {
        this.addCategory(categoryName, this.categories.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCategory(String categoryName, int index) {
        if (this.getCategory(categoryName) != null) {
            return;
        }
        Category category = new Category();
        category.setLayerManager(this);
        boolean firingEvents = this.isFiringEvents();
        this.setFiringEvents(false);
        try {
            category.setName(categoryName);
        }
        finally {
            this.setFiringEvents(firingEvents);
        }
        this.categories.add(index, category);
        this.fireCategoryChanged(category, CategoryEventType.ADDED, this.indexOf(category));
    }

    public Category getCategory(String name) {
        for (Category category : this.categories) {
            if (!category.getName().equals(name)) continue;
            return category;
        }
        return null;
    }

    public List getCategories() {
        return Collections.unmodifiableList(this.categories);
    }

    public Layer addLayer(String categoryName, String layerName, FeatureCollection featureCollection) {
        String actualName = layerName == null ? "Layer" : layerName;
        Layer layer = new Layer(actualName, this.generateLayerFillColor(), featureCollection, this);
        this.addLayerable(categoryName, layer);
        return layer;
    }

    public Layer addOrReplaceLayer(String categoryName, String layerName, FeatureCollection featureCollection) {
        Layer oldLayer = this.getLayer(layerName);
        if (oldLayer != null) {
            this.remove(oldLayer);
        }
        Layer newLayer = this.addLayer(categoryName, layerName, featureCollection);
        if (oldLayer != null) {
            newLayer.setStyles(oldLayer.cloneStyles());
        }
        return newLayer;
    }

    public String uniqueLayerName(String name) {
        String newName;
        if (!this.isExistingLayerableName(name)) {
            return name;
        }
        if (name == "Relative Vectors") {
            new Throwable().printStackTrace(System.err);
        }
        int i = 2;
        do {
            newName = name + " (" + i + ")";
            ++i;
        } while (this.isExistingLayerableName(newName));
        return newName;
    }

    private boolean isExistingLayerableName(String name) {
        for (Layerable layerable : this.getLayerables(Layerable.class)) {
            if (!layerable.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void remove(Layerable layerable) {
        for (Category c : this.categories) {
            int index = c.indexOf(layerable);
            if (index == -1) continue;
            c.remove(layerable);
            this.fireLayerChanged(layerable, LayerEventType.REMOVED, c, index);
        }
    }

    public void removeIfEmpty(Category category) {
        if (!category.isEmpty()) {
            return;
        }
        int categoryIndex = this.indexOf(category);
        this.categories.remove(category);
        this.fireCategoryChanged(category, CategoryEventType.REMOVED, categoryIndex);
    }

    public int indexOf(Category category) {
        return this.categories.indexOf(category);
    }

    public void fireCategoryChanged(Category category, CategoryEventType type) {
        this.fireCategoryChanged(category, type, this.indexOf(category));
    }

    private void fireCategoryChanged(final Category category, final CategoryEventType type, final int categoryIndex) {
        if (!this.firingEvents) {
            return;
        }
        for (final LayerListener layerListener : new ArrayList(this.layerListeners)) {
            this.fireLayerEvent(new Runnable(){

                public void run() {
                    layerListener.categoryChanged(new CategoryEvent(category, type, categoryIndex));
                }
            });
        }
    }

    public void fireFeaturesChanged(Collection features, FeatureEventType type, Layer layer) {
        Assert.isTrue((type != FeatureEventType.GEOMETRY_MODIFIED ? 1 : 0) != 0);
        this.fireFeaturesChanged(features, type, layer, null);
    }

    public void fireGeometryModified(Collection features, Layer layer, Collection oldFeatureClones) {
        Assert.isTrue((oldFeatureClones != null ? 1 : 0) != 0);
        this.fireFeaturesChanged(features, FeatureEventType.GEOMETRY_MODIFIED, layer, oldFeatureClones);
    }

    private void fireFeaturesChanged(final Collection features, final FeatureEventType type, final Layer layer, final Collection oldFeatureClones) {
        if (!this.firingEvents) {
            return;
        }
        for (final LayerListener layerListener : new ArrayList(this.layerListeners)) {
            this.fireLayerEvent(new Runnable(){

                public void run() {
                    layerListener.featuresChanged(new FeatureEvent(features, type, layer, oldFeatureClones));
                }
            });
        }
    }

    private void fireLayerEvent(Runnable eventFirer) {
        try {
            GUIUtil.invokeOnEventThread(eventFirer);
        }
        catch (InterruptedException e) {
            Assert.shouldNeverReachHere();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace(System.err);
            Assert.shouldNeverReachHere();
        }
    }

    private void fireLayerChanged(final Layerable layerable, final LayerEventType layerChangeType, final Category category, final int layerIndex) {
        if (!this.firingEvents) {
            return;
        }
        for (final LayerListener layerListener : new ArrayList(this.layerListeners)) {
            this.fireLayerEvent(new Runnable(){

                public void run() {
                    layerListener.layerChanged(new LayerEvent(layerable, layerChangeType, category, layerIndex));
                }
            });
        }
    }

    public void fireLayerChanged(Layerable layerable, LayerEventType type) {
        Category cat = this.getCategory(layerable);
        if (cat == null) {
            Assert.isTrue((!this.isFiringEvents() ? 1 : 0) != 0, (String)("If this event is being fired because you are constructing a Layer, cat will be null because you haven't yet added the Layer to the LayerManager. While constructing a layer, you should set firingEvents to false. (Layerable = " + layerable.getName() + ")"));
            return;
        }
        this.fireLayerChanged(layerable, type, cat, cat.indexOf(layerable));
    }

    public void setFiringEvents(boolean firingEvents) {
        this.firingEvents = firingEvents;
    }

    public boolean isFiringEvents() {
        return this.firingEvents;
    }

    public Iterator reverseIterator(Class layerableClass) {
        ArrayList layerablesCopy = new ArrayList(this.getLayerables(layerableClass));
        Collections.reverse(layerablesCopy);
        this.moveLayersDrawnLastToEnd(layerablesCopy);
        return layerablesCopy.iterator();
    }

    private void moveLayersDrawnLastToEnd(List layerables) {
        ArrayList<Layer> layersDrawnLast = new ArrayList<Layer>();
        Iterator i = layerables.iterator();
        while (i.hasNext()) {
            Layer layer;
            Layerable layerable = (Layerable)i.next();
            if (!(layerable instanceof Layer) || !(layer = (Layer)layerable).isDrawingLast()) continue;
            layersDrawnLast.add(layer);
            i.remove();
        }
        layerables.addAll(layersDrawnLast);
    }

    public Iterator iterator() {
        return this.getLayers().iterator();
    }

    public Layer getLayer(String name) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Layer layer = (Layer)i.next();
            if (!layer.getName().equals(name)) continue;
            return layer;
        }
        return null;
    }

    public void addLayerListener(LayerListener layerListener) {
        Assert.isTrue((!this.layerListeners.contains(layerListener) ? 1 : 0) != 0);
        this.layerListeners.add(layerListener);
    }

    public void removeLayerListener(LayerListener layerListener) {
        this.layerListeners.remove(layerListener);
    }

    public Layer getLayer(int index) {
        return (Layer)this.getLayers().get(index);
    }

    public int size() {
        return this.getLayers().size();
    }

    public Envelope getEnvelopeOfAllLayers() {
        return this.getEnvelopeOfAllLayers(false);
    }

    public Envelope getEnvelopeOfAllLayers(boolean visibleLayersOnly) {
        Envelope envelope = new Envelope();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Layer layer = (Layer)i.next();
            if (visibleLayersOnly && !layer.isVisible()) continue;
            envelope.expandToInclude(layer.getFeatureCollectionWrapper().getEnvelope());
        }
        return envelope;
    }

    public int indexOf(Layer layer) {
        return this.getLayers().indexOf(layer);
    }

    public Category getCategory(Layerable layerable) {
        for (Category category : this.categories) {
            if (!category.contains(layerable)) continue;
            return category;
        }
        return null;
    }

    public List getLayers() {
        return this.getLayerables(Layer.class);
    }

    public List getLayerables(Class layerableClass) {
        Assert.isTrue((boolean)Layerable.class.isAssignableFrom(layerableClass));
        ArrayList<Layerable> layers = new ArrayList<Layerable>();
        for (Category c : new ArrayList(this.categories)) {
            for (Layerable l : new ArrayList(c.getLayerables())) {
                if (!layerableClass.isInstance(l)) continue;
                layers.add(l);
            }
        }
        return layers;
    }

    public List getVisibleLayers(boolean includeFence) {
        ArrayList visibleLayers = new ArrayList(this.getLayers());
        Iterator i = visibleLayers.iterator();
        while (i.hasNext()) {
            Layer layer = (Layer)i.next();
            if (layer.getName().equals(FenceLayerFinder.LAYER_NAME) && !includeFence) {
                i.remove();
                continue;
            }
            if (layer.isVisible()) continue;
            i.remove();
        }
        return visibleLayers;
    }

    public void dispose(Layerable layerable) {
        for (Category c : this.categories) {
            int index = c.indexOf(layerable);
            if (index == -1) continue;
            c.remove(layerable);
            for (WeakReference reference : this.layerReferencesToDispose) {
                Layer layer = (Layer)reference.get();
                if (layer != layerable) continue;
                layer.dispose();
                --layerManagerCount;
            }
            this.fireLayerChanged(layerable, LayerEventType.REMOVED, c, index);
        }
    }

    public void dispose(WorkbenchFrame frame, Layerable layerable) {
        JInternalFrame[] internalFrames = frame.getInternalFrames();
        for (int i = 0; i < internalFrames.length; ++i) {
            JInternalFrame internalFrame = internalFrames[i];
            if (!(internalFrame instanceof LayerViewPanelProxy)) continue;
            ((LayerViewPanelProxy)((Object)internalFrame)).getLayerViewPanel().getRenderingManager().removeLayerRenderer(layerable);
        }
        for (Category c : this.categories) {
            int index = c.indexOf(layerable);
            if (index == -1) continue;
            c.remove(layerable);
            for (WeakReference reference : this.layerReferencesToDispose) {
                Layer layer = (Layer)reference.get();
                if (layer != layerable) continue;
                layer.dispose();
                --layerManagerCount;
            }
            this.fireLayerChanged(layerable, LayerEventType.REMOVED, c, index);
        }
    }

    public void dispose() {
        for (WeakReference reference : this.layerReferencesToDispose) {
            Layer layer = (Layer)reference.get();
            if (layer == null) continue;
            layer.dispose();
        }
        --layerManagerCount;
        this.undoableEditReceiver.getUndoManager().discardAllEdits();
    }

    public static int layerManagerCount() {
        return layerManagerCount;
    }

    public Collection getEditableLayers() {
        ArrayList<Layer> editableLayers = new ArrayList<Layer>();
        for (Layer layer : this.getLayers()) {
            if (!layer.isEditable()) continue;
            editableLayers.add(layer);
        }
        return editableLayers;
    }

    public Blackboard getBlackboard() {
        return this.blackboard;
    }

    public Collection getLayersWithModifiedFeatureCollections() {
        ArrayList<Layer> layersWithModifiedFeatureCollections = new ArrayList<Layer>();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Layer layer = (Layer)i.next();
            if (!layer.isFeatureCollectionModified()) continue;
            layersWithModifiedFeatureCollections.add(layer);
        }
        return layersWithModifiedFeatureCollections;
    }

    public LinkedList getLayersWithNullDataSource() {
        LinkedList<Layer> list = new LinkedList<Layer>();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Layer layer = (Layer)i.next();
            if (layer.getDataSourceQuery() != null) continue;
            list.add(layer);
        }
        return list;
    }

    public void setCoordinateSystem(CoordinateSystem coordinateSystem) {
        this.coordinateSystem = coordinateSystem;
    }

    public static void main(String[] args) throws ParseException {
        System.out.println(Line2D.linesIntersect(708248.882609455, 2402253.07294874, 708249.523621829, 2402244.3124463, 708247.896591321, 2402252.48269854, 708261.854734465, 2402182.39086576));
        System.out.println(new WKTReader().read("LINESTRING(708248.882609455 2402253.07294874, 708249.523621829 2402244.3124463)").intersects(new WKTReader().read("LINESTRING(708247.896591321 2402252.48269854, 708261.854734465 2402182.39086576)")));
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public void fireFeaturesAttChanged(Collection features, FeatureEventType type, Layer layer, Collection oldFeatureClones) {
        Assert.isTrue((type != FeatureEventType.GEOMETRY_MODIFIED ? 1 : 0) != 0);
        this.fireFeaturesChanged(features, type, layer, oldFeatureClones);
    }

    public Task getTask() {
        return this.task;
    }
}

