/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.datasource;

import com.vividsolutions.jump.util.Block;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.DataSourceQueryChooser;
import com.vividsolutions.jump.workbench.datasource.DataSourceQueryChooserManager;
import com.vividsolutions.jump.workbench.datasource.FileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public abstract class LoadSaveDatasetFileMixin {
    private String selectedFormat = "";

    protected void setSelectedFormat(String selectedFormat) {
        this.selectedFormat = selectedFormat;
    }

    protected String getSelectedFormat() {
        return this.selectedFormat;
    }

    protected Collection showDialog(JFileChooser fileChooser, Class fileDataSourceQueryChooserClass, WorkbenchContext context) {
        try {
            return this.showDialogProper(fileChooser, fileDataSourceQueryChooserClass, context);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract String getName();

    protected abstract String getLastDirectoryKey();

    private Collection showDialogProper(final JFileChooser fileChooser, Class fileDataSourceQueryChooserClass, WorkbenchContext context) throws IOException {
        fileChooser.setDialogTitle(this.getName());
        fileChooser.setCurrentDirectory(new File((String)PersistentBlackboardPlugIn.get(context).get(this.getLastDirectoryKey(), fileChooser.getCurrentDirectory().getCanonicalPath())));
        fileChooser.setSelectedFile(this.initiallySelectedFile(fileChooser.getCurrentDirectory()));
        fileChooser.setFileSelectionMode(0);
        GUIUtil.removeChoosableFileFilters(fileChooser);
        final HashMap<FileFilter, FileDataSourceQueryChooser> fileFilterToFileDataSourceQueryChooserMap = new HashMap<FileFilter, FileDataSourceQueryChooser>();
        for (DataSourceQueryChooser dataSourceQueryChooser : CollectionUtil.concatenate(DataSourceQueryChooserManager.get(context.getWorkbench().getBlackboard()).getLoadDataSourceQueryChoosers(), DataSourceQueryChooserManager.get(context.getWorkbench().getBlackboard()).getSaveDataSourceQueryChoosers())) {
            if (!fileDataSourceQueryChooserClass.isInstance(dataSourceQueryChooser)) continue;
            FileDataSourceQueryChooser fileDataSourceQueryChooser = (FileDataSourceQueryChooser)dataSourceQueryChooser;
            fileChooser.addChoosableFileFilter(fileDataSourceQueryChooser.getFileFilter());
            fileFilterToFileDataSourceQueryChooserMap.put(fileDataSourceQueryChooser.getFileFilter(), fileDataSourceQueryChooser);
        }
        for (FileFilter fileFilter : fileFilterToFileDataSourceQueryChooserMap.keySet()) {
            if (!fileFilter.getDescription().equals(this.selectedFormat)) continue;
            fileChooser.setFileFilter(fileFilter);
        }
        if (0 != fileChooser.showDialog(context.getWorkbench().getFrame(), null)) {
            return null;
        }
        PersistentBlackboardPlugIn.get(context).put(this.getLastDirectoryKey(), fileChooser.getCurrentDirectory().getCanonicalPath());
        this.selectedFormat = fileChooser.getFileFilter().getDescription();
        return CollectionUtil.collect(fileChooser.isMultiSelectionEnabled() ? Arrays.asList(fileChooser.getSelectedFiles()) : Collections.singletonList(fileChooser.getSelectedFile()), new Block(){

            public Object yield(Object file) {
                FileDataSourceQueryChooser fileDataSourceQueryChooser = (FileDataSourceQueryChooser)fileFilterToFileDataSourceQueryChooserMap.get(fileChooser.getFileFilter());
                return fileDataSourceQueryChooser.toDataSourceQuery(LoadSaveDatasetFileMixin.this.addExtensionIfRequested((File)file, fileDataSourceQueryChooser.getExtensions()[0]));
            }
        });
    }

    public abstract File initiallySelectedFile(File var1);

    private File addExtensionIfRequested(File file, String extension) {
        return this.isAddingExtensionIfRequested() ? FileUtil.addExtensionIfNone(file, extension) : file;
    }

    public abstract boolean isAddingExtensionIfRequested();
}

