/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.datasource;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.coordsys.CoordinateSystemRegistry;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.datasource.Connection;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.DataSourceQueryChooserDialog;
import com.vividsolutions.jump.workbench.datasource.DataSourceQueryChooserManager;
import com.vividsolutions.jump.workbench.datasource.FileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.datasource.LoadFileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;

public class LoadDatasetPlugIn
extends ThreadedBasePlugIn {
    private static String LAST_FORMAT_KEY = LoadDatasetPlugIn.class.getName() + " - LAST FORMAT";

    private DataSourceQueryChooserDialog getDialog(PlugInContext context) {
        String KEY;
        Blackboard blackboard = context.getWorkbenchContext().getWorkbench().getBlackboard();
        if (null == blackboard.get(KEY = this.getClass().getName() + " - DIALOG")) {
            DataSourceQueryChooserDialog dlg = new DataSourceQueryChooserDialog(DataSourceQueryChooserManager.get(blackboard).getLoadDataSourceQueryChoosers(), context.getWorkbenchFrame(), this.getName(), true);
            blackboard.put(KEY, dlg);
            Object obj = blackboard.get(LoadFileDataSourceQueryChooser.FILE_CHOOSER_KEY);
            if (obj != null && obj instanceof JFileChooser) {
                JFileChooser chooser = (JFileChooser)obj;
                chooser.addActionListener(new DoubleClickActionListener(dlg));
            }
        }
        return (DataSourceQueryChooserDialog)blackboard.get(KEY);
    }

    public String getName() {
        return I18N.get("datasource.LoadDatasetPlugIn.load-dataset");
    }

    public void initialize(final PlugInContext context) throws Exception {
        context.getWorkbenchFrame().addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                String format = (String)PersistentBlackboardPlugIn.get(context.getWorkbenchContext()).get(LAST_FORMAT_KEY);
                if (format != null) {
                    LoadDatasetPlugIn.this.getDialog(context).setSelectedFormat(format);
                }
            }
        });
    }

    public boolean execute(PlugInContext context) throws Exception {
        FileDataSourceQueryChooser.FileChooserPanel fcp = (FileDataSourceQueryChooser.FileChooserPanel)context.getWorkbenchContext().getBlackboard().get(LoadFileDataSourceQueryChooser.FILE_CHOOSER_PANEL_KEY);
        if (fcp != null) {
            JFileChooser jfc = fcp.getChooser();
            jfc.rescanCurrentDirectory();
        }
        GUIUtil.centreOnWindow(this.getDialog(context));
        this.getDialog(context).setVisible(true);
        if (this.getDialog(context).wasOKPressed()) {
            PersistentBlackboardPlugIn.get(context.getWorkbenchContext()).put(LAST_FORMAT_KEY, this.getDialog(context).getSelectedFormat());
        }
        return this.getDialog(context).wasOKPressed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        Collection dataSourceQueries = this.getDialog(context).getCurrentChooser().getDataSourceQueries();
        Assert.isTrue((!dataSourceQueries.isEmpty() ? 1 : 0) != 0);
        boolean exceptionsEncountered = false;
        for (DataSourceQuery dataSourceQuery : dataSourceQueries) {
            ArrayList exceptions = new ArrayList();
            Assert.isTrue((boolean)dataSourceQuery.getDataSource().isReadable());
            monitor.report("Loading " + dataSourceQuery.toString() + "...");
            Connection connection = dataSourceQuery.getDataSource().getConnection();
            try {
                FeatureCollection dataset = dataSourceQuery.getDataSource().installCoordinateSystem(connection.executeQuery(dataSourceQuery.getQuery(), exceptions, monitor), CoordinateSystemRegistry.instance(context.getWorkbenchContext().getBlackboard()));
                if (dataset != null) {
                    context.getLayerManager().addLayer(this.chooseCategory(context), dataSourceQuery.toString(), dataset).setDataSourceQuery(dataSourceQuery).setFeatureCollectionModified(false);
                }
            }
            finally {
                connection.close();
            }
            if (exceptions.isEmpty()) continue;
            if (!exceptionsEncountered) {
                context.getOutputFrame().createNewDocument();
                exceptionsEncountered = true;
            }
            this.reportExceptions(exceptions, dataSourceQuery, context);
        }
        if (exceptionsEncountered) {
            context.getWorkbenchFrame().warnUser(I18N.get("datasource.LoadDatasetPlugIn.problems-were-encountered"));
        }
    }

    private void reportExceptions(ArrayList exceptions, DataSourceQuery dataSourceQuery, PlugInContext context) {
        context.getOutputFrame().addHeader(1, exceptions.size() + " " + I18N.get("datasource.LoadDatasetPlugIn.problem") + StringUtil.s(exceptions.size()) + " " + I18N.get("datasource.LoadDatasetPlugIn.loading") + " " + dataSourceQuery.toString() + "." + (exceptions.size() > 10 ? I18N.get("datasource.LoadDatasetPlugIn.first-and-last-five") : ""));
        context.getOutputFrame().addText(I18N.get("datasource.LoadDatasetPlugIn.see-view-log"));
        context.getOutputFrame().append("<ul>");
        ArrayList exceptionsToReport = exceptions.size() <= 10 ? exceptions : CollectionUtil.concatenate(Arrays.asList(exceptions.subList(0, 5), exceptions.subList(exceptions.size() - 5, exceptions.size())));
        for (Exception exception : exceptionsToReport) {
            context.getWorkbenchFrame().log(StringUtil.stackTrace(exception));
            context.getOutputFrame().append("<li>");
            context.getOutputFrame().append(GUIUtil.escapeHTML(WorkbenchFrame.toMessage(exception), true, true));
            context.getOutputFrame().append("</li>");
        }
        context.getOutputFrame().append("</ul>");
    }

    private String chooseCategory(PlugInContext context) {
        return context.getLayerNamePanel().getSelectedCategories().isEmpty() ? StandardCategoryNames.WORKING : context.getLayerNamePanel().getSelectedCategories().iterator().next().toString();
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = new EnableCheckFactory(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck());
    }

    public static ImageIcon getIcon() {
        return IconLoader.icon("Plus.gif");
    }

    class DoubleClickActionListener
    implements ActionListener {
        private DataSourceQueryChooserDialog dlg;

        public DoubleClickActionListener(DataSourceQueryChooserDialog dlg) {
            this.dlg = dlg;
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.dlg.wasOKPressed()) {
                this.dlg.setOKPressed();
            }
        }
    }
}

