/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.tools;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.precision.EnhancedPrecisionOp;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.IndexedFeatureCollection;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.tools.AttributeMapping;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class OverlayEngine {
    private static Logger LOG = Logger.getLogger(OverlayEngine.class);
    private boolean splittingGeometryCollections = true;
    private boolean allowingPolygonsOnly = true;

    public FeatureCollection overlay(FeatureCollection a, FeatureCollection b, TaskMonitor monitor) {
        return this.overlay(a, b, new AttributeMapping(a.getFeatureSchema(), b.getFeatureSchema()), monitor);
    }

    public FeatureCollection overlay(FeatureCollection a, FeatureCollection b, AttributeMapping mapping, TaskMonitor monitor) {
        monitor.allowCancellationRequests();
        monitor.report(I18N.get("tools.OverlayEngine.indexing-second-feature-collection"));
        IndexedFeatureCollection indexedB = new IndexedFeatureCollection(b);
        monitor.report(I18N.get("tools.OverlayEngine.overlaying-feature-collections"));
        FeatureDataset overlay = new FeatureDataset(mapping.createSchema("GEOMETRY"));
        List aFeatures = a.getFeatures();
        for (int i = 0; i < aFeatures.size() && !monitor.isCancelRequested(); ++i) {
            Feature aFeature = (Feature)aFeatures.get(i);
            Iterator j = indexedB.query(aFeature.getGeometry().getEnvelopeInternal()).iterator();
            while (j.hasNext() && !monitor.isCancelRequested()) {
                Feature bFeature = (Feature)j.next();
                this.addIntersection(aFeature, bFeature, mapping, overlay, monitor);
            }
            monitor.report(i + 1, a.size(), "features");
        }
        return overlay;
    }

    private void addIntersection(Feature a, Feature b, AttributeMapping mapping, FeatureCollection overlay, TaskMonitor monitor) {
        if (!a.getGeometry().getEnvelope().intersects(b.getGeometry().getEnvelope())) {
            return;
        }
        Geometry intersection = null;
        try {
            intersection = EnhancedPrecisionOp.intersection((Geometry)a.getGeometry(), (Geometry)b.getGeometry());
        }
        catch (Exception ex) {
            monitor.report(ex);
            LOG.error((Object)a.getGeometry());
            LOG.error((Object)b.getGeometry());
        }
        if (intersection == null || intersection.isEmpty()) {
            return;
        }
        this.addFeature(intersection, overlay, mapping, a, b);
    }

    protected void addFeature(Geometry intersection, FeatureCollection overlay, AttributeMapping mapping, Feature a, Feature b) {
        if (this.splittingGeometryCollections && intersection instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)intersection;
            for (int i = 0; i < gc.getNumGeometries(); ++i) {
                this.addFeature(gc.getGeometryN(i), overlay, mapping, a, b);
            }
            return;
        }
        if (this.allowingPolygonsOnly && !(intersection instanceof Polygon) && !(intersection instanceof MultiPolygon)) {
            return;
        }
        BasicFeature feature = new BasicFeature(overlay.getFeatureSchema());
        mapping.transferAttributes(a, b, feature);
        feature.setGeometry(intersection);
        overlay.add(feature);
    }

    public void setSplittingGeometryCollections(boolean splittingGeometryCollections) {
        this.splittingGeometryCollections = splittingGeometryCollections;
    }

    public void setAllowingPolygonsOnly(boolean allowingPolygonsOnly) {
        this.allowingPolygonsOnly = allowingPolygonsOnly;
    }
}

